/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.model.java;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ReflectionToStringBuilder;

public class Base {
    private String className;
    private String desc;
    private String packageName;
    private String tableName;
    private List<String> importLists = Lists.newArrayList();
    private static final Map<String, String> classMap = Maps.newHashMap();

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getClassPath() {
        return StringUtils.replace((String)this.packageName, (String)".", (String)"/");
    }

    public List<String> getImportLists() {
        return this.importLists;
    }

    public void addImport(String importClass) {
        String _importClass = importClass;
        if (importClass.indexOf("<") > 0 && importClass.indexOf(".") > 0) {
            _importClass = importClass.substring(0, importClass.indexOf("<"));
            this.importLists.add(_importClass);
        }
        if (classMap.containsKey(_importClass.toLowerCase())) {
            String classZ = classMap.get(_importClass.toLowerCase());
            if (StringUtils.isNotBlank((String)classZ) && !this.importLists.contains(classZ)) {
                this.importLists.add(classZ);
            }
        } else if (!this.importLists.contains(_importClass) && importClass.indexOf("<") < 0) {
            this.importLists.add(_importClass);
        }
    }

    public String getDesc() {
        return this.desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this);
    }

    static {
        classMap.put("long", null);
        classMap.put("int", null);
        classMap.put("double", null);
        classMap.put("float", null);
        classMap.put("integer", null);
        classMap.put("boolean", null);
        classMap.put("byte", null);
        classMap.put("string", null);
        classMap.put("date", "java.util.Date");
        classMap.put("list", "java.util.List");
    }
}

