/*
 * Decompiled with CFR 0.152.
 */
package cn.dalgen.mybatis.gen.enums;

import cn.dalgen.mybatis.gen.exception.DalgenException;
import java.util.HashMap;
import java.util.Map;

public enum TypeMapEnum {
    CHAR("CHAR", "String"),
    VARCHAR("VARCHAR", "String"),
    LONGVARCHAR("LONGVARCHAR", "String"),
    NUMERIC("NUMERIC", "java.math.BigDecimal"),
    DECIMAL("DECIMAL", "java.math.BigDecimal"),
    BIT("BIT", "Boolean"),
    TINYINT("TINYINT", "Integer"),
    SMALLINT("SMALLINT", "Integer"),
    INT("INT", "Integer"),
    INTEGER("INTEGER", "Integer"),
    BIGINT("BIGINT", "Long"),
    REAL("REAL", "Float"),
    FLOAT("FLOAT", "Double"),
    DOUBLE("DOUBLE", "Double"),
    BINARY("BINARY", "byte"),
    VARBINARY("VARBINARY", "byte"),
    LONGVARBINARY("LONGVARBINARY", "byte"),
    DATE("DATE", "java.sql.Date"),
    TIME("TIME", "java.sql.Time"),
    DATETIME("TIMESTAMP", "java.sql.Time"),
    TIMESTAMP("TIMESTAMP", "java.sql.Timestamp"),
    OTHER("other", "other");

    private String jdbcType;
    private String javaType;
    private static Map<String, TypeMapEnum> codeLookup;

    private TypeMapEnum(String jdbcType, String javaType) {
        this.jdbcType = jdbcType;
        this.javaType = javaType;
    }

    public static TypeMapEnum getByJdbcType(String jdbcType) {
        TypeMapEnum type = codeLookup.get(jdbcType);
        if (type != null) {
            return type;
        }
        throw new DalgenException("\u7c7b\u578b\u8f6c\u6362\u9519\u8bef:" + jdbcType);
    }

    public static TypeMapEnum getByJdbcTypeWithOther(String jdbcType) {
        TypeMapEnum type = codeLookup.get(jdbcType);
        if (type != null) {
            return type;
        }
        return OTHER;
    }

    public String getJdbcType() {
        return this.jdbcType;
    }

    public String getJavaType() {
        return this.javaType;
    }

    static {
        codeLookup = new HashMap<String, TypeMapEnum>();
        for (TypeMapEnum type : TypeMapEnum.values()) {
            codeLookup.put(type.name(), type);
        }
    }
}

