/*
 * Decompiled with CFR 0.152.
 */
package ai.djl.huggingface.translator;

import ai.djl.huggingface.tokenizers.Encoding;
import ai.djl.huggingface.tokenizers.HuggingFaceTokenizer;
import ai.djl.huggingface.tokenizers.jni.CharSpan;
import ai.djl.huggingface.translator.PretrainedConfig;
import ai.djl.huggingface.translator.TokenClassificationBatchTranslator;
import ai.djl.modality.nlp.translator.NamedEntity;
import ai.djl.ndarray.NDArray;
import ai.djl.ndarray.NDList;
import ai.djl.translate.ArgumentsUtil;
import ai.djl.translate.Batchifier;
import ai.djl.translate.Translator;
import ai.djl.translate.TranslatorContext;
import ai.djl.util.JsonUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Map;

public class TokenClassificationTranslator
implements Translator<String, NamedEntity[]> {
    private HuggingFaceTokenizer tokenizer;
    private Batchifier batchifier;
    private PretrainedConfig config;

    TokenClassificationTranslator(HuggingFaceTokenizer tokenizer, Batchifier batchifier) {
        this.tokenizer = tokenizer;
        this.batchifier = batchifier;
    }

    public Batchifier getBatchifier() {
        return this.batchifier;
    }

    public void prepare(TranslatorContext ctx) throws IOException {
        Path path = ctx.getModel().getModelPath();
        Path file = path.resolve("config.json");
        try (BufferedReader reader = Files.newBufferedReader(file);){
            this.config = (PretrainedConfig)JsonUtils.GSON.fromJson((Reader)reader, PretrainedConfig.class);
        }
    }

    public NDList processInput(TranslatorContext ctx, String input) {
        Encoding encoding = this.tokenizer.encode(input);
        ctx.setAttachment("encoding", (Object)encoding);
        return encoding.toNDList(ctx.getNDManager(), false);
    }

    public NamedEntity[] processOutput(TranslatorContext ctx, NDList list) {
        Encoding encoding = (Encoding)ctx.getAttachment("encoding");
        return TokenClassificationTranslator.toNamedEntities(encoding, list, this.config);
    }

    public TokenClassificationBatchTranslator toBatchTranslator(Batchifier batchifier) {
        this.tokenizer.enableBatch();
        return new TokenClassificationBatchTranslator(this.tokenizer, batchifier);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer) {
        return new Builder(tokenizer);
    }

    public static Builder builder(HuggingFaceTokenizer tokenizer, Map<String, ?> arguments) {
        Builder builder = TokenClassificationTranslator.builder(tokenizer);
        builder.configure(arguments);
        return builder;
    }

    static NamedEntity[] toNamedEntities(Encoding encoding, NDList list, PretrainedConfig config) {
        NDArray logits = (NDArray)list.get(0);
        long[] inputIds = encoding.getIds();
        CharSpan[] offsetMapping = encoding.getCharTokenSpans();
        long[] specialTokenMasks = encoding.getSpecialTokenMask();
        NDArray probabilities = logits.softmax(1);
        ArrayList<NamedEntity> entities = new ArrayList<NamedEntity>();
        for (int i = 0; i < inputIds.length; ++i) {
            if (specialTokenMasks[i] != 0L) continue;
            int entityIdx = (int)probabilities.get(new long[]{i}).argMax().getLong(new long[0]);
            String entity = config.id2label.get(String.valueOf(entityIdx));
            if ("O".equals(entity)) continue;
            float score = probabilities.get(new long[]{i}).getFloat(new long[]{entityIdx});
            String word = encoding.getTokens()[i];
            int start = offsetMapping[i].getStart();
            int end = offsetMapping[i].getEnd();
            NamedEntity item = new NamedEntity(entity, score, i, word, start, end);
            entities.add(item);
        }
        return entities.toArray(new NamedEntity[0]);
    }

    public static final class Builder {
        private HuggingFaceTokenizer tokenizer;
        private Batchifier batchifier = Batchifier.STACK;

        Builder(HuggingFaceTokenizer tokenizer) {
            this.tokenizer = tokenizer;
        }

        public Builder optBatchifier(Batchifier batchifier) {
            this.batchifier = batchifier;
            return this;
        }

        public void configure(Map<String, ?> arguments) {
            String batchifierStr = ArgumentsUtil.stringValue(arguments, (String)"batchifier", (String)"stack");
            this.optBatchifier(Batchifier.fromString((String)batchifierStr));
        }

        public TokenClassificationTranslator build() throws IOException {
            return new TokenClassificationTranslator(this.tokenizer, this.batchifier);
        }
    }
}

