/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fubei.foundation.utils;

import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ThrowableSupplier;
import com.fshows.fubei.AppConfig;
import com.fshows.fubei.foundation.model.RequestParam;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import com.google.common.hash.Hashing;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(SignUtil.class);

    public static void sign(RequestParam requestParam, String appSecret) {
        String baseStr = SignUtil.baseString(requestParam, appSecret);
        if (AppConfig.getInstance().isDebug()) {
            LOGGER.warn("\u5f85\u7b7e\u540d\u5b57\u7b26\u4e32[BaseString]: {}", (Object)baseStr);
        }
        String sig = Hashing.md5().hashString((CharSequence)baseStr, Charset.forName("utf-8")).toString().toUpperCase();
        requestParam.setSign(sig);
    }

    @Nonnull
    private static String baseString(RequestParam requestParam, String appSecret) {
        StringBuilder sb = new StringBuilder();
        Map<String, String> dataMapper = SignUtil.mapper(requestParam);
        Joiner.on((String)"&").withKeyValueSeparator("=").appendTo(sb, dataMapper);
        sb.append(appSecret);
        return sb.toString();
    }

    @Nonnull
    private static Map<String, String> mapper(final RequestParam param) {
        return (Map)Supplier.Util.safe((ThrowableSupplier)new ThrowableSupplier<Map<String, String>, Throwable>(){

            public Map<String, String> get() {
                TreeMap mapper = Maps.newTreeMap();
                if (!Strings.isNullOrEmpty((String)param.getAppId())) {
                    mapper.put("app_id", param.getAppId());
                }
                if (!Strings.isNullOrEmpty((String)param.getVendorSn())) {
                    mapper.put("vendor_sn", param.getVendorSn());
                }
                mapper.put("method", param.getMethod());
                mapper.put("format", param.getFormat());
                mapper.put("sign_method", param.getSignMethod());
                mapper.put("nonce", param.getNonce());
                mapper.put("version", param.getVersion());
                mapper.put("biz_content", param.getBizContent());
                return mapper;
            }
        }, (Object)Maps.newTreeMap()).get();
    }
}

