/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fubei.foundation.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.fshows.fubei.foundation.exception.SdkBizException;
import com.fshows.fubei.foundation.model.CommonResultModel;
import com.fshows.fubei.foundation.support.FastJsonConfig;
import com.google.common.base.Strings;
import java.io.IOException;
import java.lang.reflect.Type;
import java.text.MessageFormat;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.ResponseBody;
import retrofit2.Converter;

public class FubeiOpenApiResponseBodyConverter<T>
implements Converter<ResponseBody, T> {
    private ParserConfig parserConfig = FastJsonConfig.DEFAULT_PARSER_CONFIG;
    private int featureValues = JSON.DEFAULT_PARSER_FEATURE;
    private Feature[] features;
    private Type type;

    FubeiOpenApiResponseBodyConverter(Type type) {
        this.type = type;
    }

    @Nullable
    public T convert(@Nonnull ResponseBody value) throws IOException {
        try {
            String body = value.string();
            CommonResultModel<String> commonResultModel = new CommonResultModel<String>();
            JSONObject jsonObject = JSON.parseObject((String)body);
            if (jsonObject == null) {
                throw new SdkBizException(-9999, MessageFormat.format("\u670d\u52a1\u5668\u6570\u636e\u8fd4\u56de\u5f02\u5e38\uff0c\u89e3\u6790\u5931\u8d25\u3002\u8fd4\u56de\u5185\u5bb9\uff1a{0}", Strings.isNullOrEmpty((String)body) ? "(\u7a7a\u6570\u636e)" : body));
            }
            int resultCode = jsonObject.getIntValue("result_code");
            commonResultModel.setResultCode(resultCode);
            if (resultCode == 200) {
                String dataContent = jsonObject.getString("data");
                if (Strings.isNullOrEmpty((String)dataContent)) {
                    T t = null;
                    return t;
                }
                Object object = JSON.parseObject((String)dataContent, (Type)this.type, (ParserConfig)this.parserConfig, (int)this.featureValues, (Feature[])this.features);
                return (T)object;
            }
            try {
                commonResultModel.setResultMessage(jsonObject.getString("result_message"));
                if (resultCode == 400) {
                    String subCode = jsonObject.getString("sub_code");
                    String data = jsonObject.getString("data");
                    commonResultModel.setSubCode(subCode);
                    commonResultModel.setData(data);
                }
                throw new SdkBizException(commonResultModel);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw e;
            }
        }
        finally {
            value.close();
        }
    }

    public ParserConfig getParserConfig() {
        return this.parserConfig;
    }

    public FubeiOpenApiResponseBodyConverter<T> setParserConfig(ParserConfig parserConfig) {
        this.parserConfig = parserConfig;
        return this;
    }

    public Feature[] getFeatures() {
        return this.features;
    }

    public FubeiOpenApiResponseBodyConverter<T> setFeatures(Feature[] features) {
        this.features = features;
        return this;
    }
}

