/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fubei.foundation.http;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.annimon.stream.Optional;
import com.fshows.fubei.AppConfig;
import com.fshows.fubei.foundation.annotation.FubeiOpenApi;
import com.fshows.fubei.foundation.model.BaseBizContentModel;
import com.fshows.fubei.foundation.model.RequestParam;
import com.fshows.fubei.foundation.support.FastJsonConfig;
import com.fshows.fubei.foundation.utils.RandomStringUtil;
import com.fshows.fubei.foundation.utils.SignUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import retrofit2.Converter;

public class FubeiOpenApiRequestBodyConverter<T>
implements Converter<T, RequestBody> {
    private static final int RANDOM_BIT = 32;
    private static final MediaType MEDIA_TYPE = MediaType.parse((String)"application/json; charset=UTF-8");
    private SerializeConfig serializeConfig = FastJsonConfig.DEFAULT_SERIALIZE_CONFIG;
    private SerializerFeature[] serializerFeatures = new SerializerFeature[]{SerializerFeature.WriteEnumUsingToString};
    private FubeiOpenApi fubeiOpenApi;

    FubeiOpenApiRequestBodyConverter(@Nullable FubeiOpenApi fubeiOpenApi) {
        if (fubeiOpenApi != null) {
            this.fubeiOpenApi = fubeiOpenApi;
        }
    }

    @Nullable
    public RequestBody convert(@Nonnull T value) {
        RequestParam param;
        if (value instanceof BaseBizContentModel) {
            BaseBizContentModel model = (BaseBizContentModel)value;
            param = RequestParam.create(model);
        } else {
            param = RequestParam.create(new BaseBizContentModel());
        }
        String secret = "";
        if (Optional.ofNullable((Object)this.fubeiOpenApi).isPresent()) {
            param.setMethod(this.fubeiOpenApi.method());
            param.setFormat(this.fubeiOpenApi.format());
            param.setVersion(this.fubeiOpenApi.version());
            switch (this.fubeiOpenApi.openApiType()) {
                case AGENT: {
                    param.setVendorSn(AppConfig.getInstance().getVendorSn());
                    param.setAppId(null);
                    secret = AppConfig.getInstance().getVendorSecret();
                    break;
                }
                default: {
                    param.setVendorSn(null);
                    param.setAppId(AppConfig.getInstance().getAppId());
                    secret = AppConfig.getInstance().getAppSecret();
                }
            }
        }
        param.setNonce(RandomStringUtil.randomAlphabet(32));
        SignUtil.sign(param, secret);
        byte[] content = JSON.toJSONBytes((Object)param, (SerializeConfig)this.serializeConfig, (SerializerFeature[])this.serializerFeatures);
        return RequestBody.create((MediaType)MEDIA_TYPE, (byte[])content);
    }

    public SerializeConfig getSerializeConfig() {
        return this.serializeConfig;
    }

    public FubeiOpenApiRequestBodyConverter<T> setSerializeConfig(SerializeConfig serializeConfig) {
        this.serializeConfig = serializeConfig;
        return this;
    }

    public SerializerFeature[] getSerializerFeatures() {
        return this.serializerFeatures;
    }

    public FubeiOpenApiRequestBodyConverter<T> setSerializerFeatures(SerializerFeature[] serializerFeatures) {
        this.serializerFeatures = serializerFeatures;
        return this;
    }
}

