/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fubei.foundation.exception;

import com.alibaba.fastjson.JSON;
import com.annimon.stream.function.Supplier;
import com.annimon.stream.function.ThrowableSupplier;
import com.fshows.fubei.foundation.exception.AbstractNetException;
import com.fshows.fubei.foundation.model.CommonResultModel;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Map;
import javax.annotation.Nonnull;

public class SdkBizException
extends AbstractNetException {
    private Integer resultCode;
    private String subCode;
    private String resultMessage;
    private Map payload;

    public SdkBizException(int resultCode, String resultMessage) {
        this.resultCode = resultCode;
        this.resultMessage = Strings.nullToEmpty((String)resultMessage);
    }

    public SdkBizException(@Nonnull CommonResultModel commonResultModel) {
        this.resultCode = commonResultModel.getResultCode();
        this.resultMessage = commonResultModel.getResultMessage();
        if (commonResultModel.getSubCode() != null) {
            this.subCode = commonResultModel.getSubCode();
        }
        if (commonResultModel.getData() != null) {
            this.payload = this.getPayload(commonResultModel.getData());
        }
    }

    public SdkBizException(int resultCode, String subCode, String resultMessage) {
        this.resultCode = resultCode;
        this.resultMessage = resultMessage;
        this.payload = null;
        this.subCode = subCode;
    }

    public SdkBizException(int resultCode, String subCode, String resultMessage, String payload) {
        this.resultCode = resultCode;
        this.resultMessage = resultMessage;
        this.subCode = subCode;
        this.payload = this.getPayload(payload);
    }

    private Map getPayload(final Object payload) {
        return (Map)Supplier.Util.safe((ThrowableSupplier)new ThrowableSupplier<Map, Throwable>(){

            public Map get() {
                return (Map)JSON.parseObject((String)payload.toString(), Map.class);
            }
        }, (Object)Maps.newHashMap()).get();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SdkBizException: ").append("resultCode:").append(this.resultCode).append(", resultMessage:").append(this.resultMessage);
        if (!Strings.isNullOrEmpty((String)this.subCode)) {
            sb.append(", subCode:").append(this.subCode);
        }
        if (this.payload != null) {
            sb.append(", payload:").append(this.payload.toString());
        }
        return sb.toString();
    }

    public Integer getResultCode() {
        return this.resultCode;
    }

    public void setResultCode(Integer resultCode) {
        this.resultCode = resultCode;
    }

    @Override
    public String getMessage() {
        return this.resultMessage;
    }

    public void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    public String getResultMessage() {
        return this.resultMessage;
    }

    public String getSubCode() {
        return this.subCode;
    }

    public void setSubCode(String subCode) {
        this.subCode = subCode;
    }

    public Map getPayload() {
        return this.payload;
    }

    public void setPayload(Map payload) {
        this.payload = payload;
    }
}

