/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fubei.foundation.apiproxy;

import com.fshows.fubei.AppConfig;
import com.fshows.fubei.foundation.apiproxy.AbstractApiProxy;
import com.fshows.fubei.foundation.http.FubeiOpenApiConverterFactory;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;

public class FubeiOpenApiProxy
extends AbstractApiProxy {
    private static final Logger LOGGER = LoggerFactory.getLogger(FubeiOpenApiProxy.class);
    private static final String SHQ_API = "https://shq-api.51fubei.com/";
    private static final String SHQ_API_TEST = "https://shq-api-test.51fubei.com/";
    private static FubeiOpenApiProxy API_PROXY = new FubeiOpenApiProxy();

    public static FubeiOpenApiProxy getInstance() {
        return API_PROXY;
    }

    @Override
    protected void initRetrofit(Retrofit.Builder builder) {
        LOGGER.info("init Retrofit.");
        builder.baseUrl(this.getBaseUrl()).addConverterFactory((Converter.Factory)new FubeiOpenApiConverterFactory());
        builder.client(this.getOkHttpClient());
    }

    protected OkHttpClient getOkHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout((long)AppConfig.getInstance().getHttpConnectTimeout(), TimeUnit.SECONDS);
        builder.readTimeout((long)AppConfig.getInstance().getHttpReadTimeout(), TimeUnit.SECONDS);
        builder.writeTimeout((long)AppConfig.getInstance().getHttpWriteTimeout(), TimeUnit.SECONDS);
        HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor(new HttpLoggingInterceptor.Logger(){

            public void log(String message) {
                LOGGER.info("{}", (Object)message);
            }
        });
        HttpLoggingInterceptor.Level level = AppConfig.getInstance().isDebug() ? HttpLoggingInterceptor.Level.BODY : HttpLoggingInterceptor.Level.BASIC;
        loggingInterceptor.setLevel(level);
        builder.addInterceptor((Interceptor)loggingInterceptor);
        return builder.build();
    }

    @Override
    protected String getBaseUrl() {
        return AppConfig.getInstance().getEnv() == 1 ? SHQ_API : SHQ_API_TEST;
    }
}

