/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.sdk.android.push;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;
import com.alibaba.sdk.android.ams.common.logger.AmsLogger;
import com.alibaba.sdk.android.ams.common.securitybox.SecurityBoxServiceFactory;
import com.alibaba.sdk.android.ams.common.util.StringUtil;
import com.alibaba.sdk.android.push.common.util.JSONUtils;
import com.alibaba.sdk.android.push.impl.j;
import com.alibaba.sdk.android.push.notification.CPushMessage;
import com.alibaba.sdk.android.push.notification.c;
import com.alibaba.sdk.android.push.notification.e;
import com.alibaba.sdk.android.push.notification.f;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class AliyunMessageIntentService
extends IntentService {
    private static final String TAG = "MPS:AliyunMessageIntentService";
    private static AmsLogger sLogger = AmsLogger.getLogger("MPS:AliyunMessageIntentService");
    private e mMessageNotification = new e();

    public AliyunMessageIntentService() {
        super(TAG);
    }

    private void handleReceiveAction(Intent object) {
        try {
            int n2;
            sLogger.d("handle message");
            Object object2 = object.getStringExtra("id");
            sLogger.d("messageId:" + (String)object2);
            if (StringUtil.isEmpty((String)object2)) {
                sLogger.e("Null messageId!");
                return;
            }
            String string = object.getStringExtra("body");
            String string2 = object.getStringExtra("task_id");
            object = object.getStringExtra("extData");
            sLogger.i("[AMS]msg receive:" + string);
            if (StringUtil.isEmpty(string)) {
                sLogger.e("json body is Empty!");
                return;
            }
            Map<String, String> map = null;
            try {
                map = JSONUtils.toMap(new JSONObject(string));
            }
            catch (JSONException jSONException) {
                sLogger.e("Parse json error:", jSONException);
            }
            try {
                n2 = Integer.parseInt(map.get("type"));
            }
            catch (Throwable throwable) {
                sLogger.e("Wrong message Type Define!", throwable);
                return;
            }
            if (j.a().b()) {
                sLogger.d("[AMS]Push received in DoNotDisturb time window, ignored.");
                return;
            }
            map.put("task_id", string2);
            map.put("extData", (String)object);
            object = SecurityBoxServiceFactory.getSecurityBoxService();
            switch (n2) {
                case 1: {
                    try {
                        String string3 = object.getAppKey();
                        object2 = e.a(this.getApplicationContext(), map, string3, (String)object2);
                        if (object2 != null) {
                            if (!((c)object2).u() && f.a(this.getApplicationContext())) {
                                sLogger.i("do not build notification when app in foreground");
                                this.onNotificationReceivedInApp(this.getApplicationContext(), ((c)object2).b(), ((c)object2).c(), ((c)object2).f(), ((c)object2).a(), ((c)object2).j(), ((c)object2).e());
                                return;
                            }
                            this.mMessageNotification.a(this.getApplicationContext(), (c)object2);
                            this.onNotification(this.getApplicationContext(), ((c)object2).b(), ((c)object2).c(), ((c)object2).f());
                            return;
                        }
                        sLogger.e("Notify title is null or server push data Error appId =  " + string3);
                        return;
                    }
                    catch (RuntimeException runtimeException) {
                        sLogger.e("Notify message error:", runtimeException);
                        return;
                    }
                }
                case 2: {
                    String string4 = object.getAppKey();
                    try {
                        this.getApplicationContext();
                        object2 = e.a(map, string4, (String)object2);
                        if (object2 != null) {
                            try {
                                object = object.getMpsDeviceId();
                                sLogger.i("messageId=" + ((CPushMessage)object2).getMessageId() + ";appId=" + ((CPushMessage)object2).getAppId() + ";deviceId=" + (String)object + ";messageType=msg", null, 1);
                            }
                            catch (Throwable throwable) {
                                sLogger.e("ut log error", throwable);
                            }
                            this.onMessage(this.getApplicationContext(), (CPushMessage)object2);
                        }
                        return;
                    }
                    catch (Throwable throwable) {
                        sLogger.e("Custom message parse error:", throwable);
                        return;
                    }
                }
            }
            sLogger.e("Wrong message Type Define!");
            return;
        }
        catch (Throwable throwable) {
            sLogger.e("handleReceiveActionException", throwable);
            return;
        }
    }

    private void handleNotificationOpenAction(Intent intent) {
        try {
            String string = intent.getStringExtra("title");
            String string2 = intent.getStringExtra("summary");
            String string3 = intent.getStringExtra("extraMap");
            int n2 = intent.getIntExtra("notificationOpenType", 1);
            if (4 == n2) {
                sLogger.d("notification opened without action");
                this.onNotificationClickedWithNoAction(this.getApplicationContext(), string, string2, string3);
                return;
            }
            sLogger.d("notification opened");
            this.onNotificationOpened(this.getApplicationContext(), string, string2, string3);
            return;
        }
        catch (Throwable throwable) {
            sLogger.e("Handle notification open action failed.", throwable);
            return;
        }
    }

    private void handleNotificationRemoveAction(Intent object) {
        try {
            object = object.getStringExtra("messageId");
            if (StringUtil.isEmpty((String)object)) {
                throw new Exception("msgId null");
            }
            this.onNotificationRemoved(this.getApplicationContext(), (String)object);
            sLogger.d("Delete message! --" + (String)object);
            return;
        }
        catch (Throwable throwable) {
            sLogger.e("Handle notification Remove action failed.", throwable);
            return;
        }
    }

    protected void onHandleIntent(Intent intent) {
        String string = intent.getAction();
        if (StringUtil.isEmpty(string)) {
            sLogger.e("Action is null, return.");
            return;
        }
        if ("com.alibaba.sdk.android.push.RECEIVE".equals(string)) {
            this.handleReceiveAction(intent);
            return;
        }
        if ("com.alibaba.push2.action.NOTIFICATION_OPENED".equals(string)) {
            this.handleNotificationOpenAction(intent);
            return;
        }
        if ("com.alibaba.push2.action.NOTIFICATION_REMOVED".equals(string)) {
            this.handleNotificationRemoveAction(intent);
            return;
        }
        sLogger.e("Invalid action");
    }

    protected abstract void onNotification(Context var1, String var2, String var3, Map<String, String> var4);

    protected abstract void onMessage(Context var1, CPushMessage var2);

    protected abstract void onNotificationOpened(Context var1, String var2, String var3, String var4);

    protected abstract void onNotificationClickedWithNoAction(Context var1, String var2, String var3, String var4);

    protected abstract void onNotificationRemoved(Context var1, String var2);

    protected abstract void onNotificationReceivedInApp(Context var1, String var2, String var3, Map<String, String> var4, int var5, String var6, String var7);
}

