/*
 * Decompiled with CFR 0.152.
 */
package com.shouzhan.szpush.receiver;

import android.content.Context;
import android.util.Log;
import com.shouzhan.szpush.manager.MiPushManager;
import com.shouzhan.szpush.manager.PushChannel;
import com.shouzhan.szpush.mix.MixPushMessage;
import com.shouzhan.szpush.push.IPushChannel;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.PushMessageReceiver;
import java.util.List;
import org.json.JSONObject;

public class MiPushMessageReceiver
extends PushMessageReceiver
implements IPushChannel {
    private static final String TAG = MiPushMessageReceiver.class.getSimpleName();

    @Override
    public String getPushName() {
        return PushChannel.xiaomi.name();
    }

    public void onReceivePassThroughMessage(Context context, MiPushMessage miPushMessage) {
        super.onReceivePassThroughMessage(context, miPushMessage);
        try {
            Log.e((String)TAG, (String)("onReceivePassThroughMessage: " + miPushMessage.getExtra()));
            MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
            mixPushMessage.setContent((String)miPushMessage.getExtra().get("extend_content"));
            MiPushManager.sMixMessageProvider.onReceivePassThroughMessage(context, mixPushMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onNotificationMessageClicked(Context context, MiPushMessage miPushMessage) {
        super.onNotificationMessageClicked(context, miPushMessage);
        try {
            Log.e((String)TAG, (String)("onNotificationMessageClicked: " + miPushMessage.getExtra()));
            String content = (String)miPushMessage.getExtra().get("extend_content");
            JSONObject object = new JSONObject(content);
            MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
            mixPushMessage.setMsgObject(object.getJSONObject("on_message").toString());
            MiPushManager.sMixMessageProvider.onNotificationMessageClicked(context, mixPushMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onNotificationMessageArrived(Context context, MiPushMessage miPushMessage) {
        super.onNotificationMessageArrived(context, miPushMessage);
        try {
            Log.e((String)TAG, (String)("onNotificationMessageArrived: " + miPushMessage.getExtra()));
            String content = (String)miPushMessage.getExtra().get("extend_content");
            JSONObject object = new JSONObject(content);
            JSONObject msgObject = object.getJSONObject("on_message");
            MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
            mixPushMessage.setMsgCode(msgObject.optString("code"));
            mixPushMessage.setOrderSn(msgObject.optString("order_sn"));
            mixPushMessage.setOrderId(msgObject.optString("order_id"));
            MiPushManager.sMixMessageProvider.onNotificationMessageArrived(context, mixPushMessage);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onCommandResult(Context context, MiPushCommandMessage miPushCommandMessage) {
        String cid;
        super.onCommandResult(context, miPushCommandMessage);
        Log.e((String)TAG, (String)"onCommandResult");
        String command = miPushCommandMessage.getCommand();
        List arguments = miPushCommandMessage.getCommandArguments();
        String string = cid = arguments != null && arguments.size() > 0 ? (String)arguments.get(0) : null;
        if ("register".equals(command)) {
            if (miPushCommandMessage.getResultCode() == 0L) {
                Log.d((String)TAG, (String)("register is success: " + cid));
                MixPushMessage mixPushMessage = new MixPushMessage(this.getPushName());
                mixPushMessage.setCid(cid);
                MiPushManager.sMixMessageProvider.onReceiveClientId(context, mixPushMessage);
            } else {
                Log.i((String)TAG, (String)"register is fail");
            }
        }
    }
}

