/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.download;

import android.content.Context;
import com.fshows.android.stark.utils.FileUtil;
import com.fshows.android.stark.utils.FilenameFilterByPrefix;
import java.io.File;

public class DownloadUtils {
    public static final String TEMP_FILE_SUFFIX = ".apk.tmp";
    public static final String FORMAL_FILE_SUFFIX = ".apk";
    static final int DOWNLOAD_RETRY_TIMES = 2;

    public static File createDownloadTempFile(Context context, String key) {
        String rootPath = FileUtil.getRootPath(context);
        File newFile = new File(rootPath, key + TEMP_FILE_SUFFIX);
        if (!newFile.getParentFile().exists()) {
            newFile.getParentFile().mkdirs();
        }
        return newFile;
    }

    public static File createDownloadFormalFile(Context context, String key) {
        String rootPath = FileUtil.getRootPath(context);
        File newFile = new File(rootPath, key + FORMAL_FILE_SUFFIX);
        if (!newFile.getParentFile().exists()) {
            newFile.getParentFile().mkdirs();
        }
        return newFile;
    }

    public static void renameFile(File tempFile, File newFile) {
        tempFile.renameTo(newFile);
    }

    public static File getDownloadFile(Context context, String key) {
        String rootPath = FileUtil.getRootPath(context);
        return DownloadUtils.getDownloadFile(context, key, rootPath);
    }

    public static File getDownloadFile(Context context, String key, String rootPath) {
        File rootDir = new File(rootPath);
        File[] files = rootDir.listFiles(new FilenameFilterByPrefix(key));
        if (files == null || files.length <= 0) {
            return null;
        }
        return files[0];
    }

    public static File getDownloadFileByUrl(Context context, String url) {
        String key = FileUtil.genKeyForUrl(url);
        return DownloadUtils.getDownloadFile(context, key);
    }

    public static long getDownloadRange(Context context, String key) {
        File file = DownloadUtils.getDownloadFile(context, key);
        if (file == null) {
            return 0L;
        }
        return file.length();
    }

    public static boolean isCompleteFile(String path) {
        return FileUtil.isCompleteFile(path, TEMP_FILE_SUFFIX);
    }
}

