/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.scheme;

import android.content.Context;
import android.net.Uri;
import com.annimon.stream.Stream;
import com.fshows.android.stark.scheme.ISchemeAction;
import com.fshows.android.stark.scheme.SchemeData;
import com.fshows.android.stark.scheme.SchemeParser;
import com.fshows.android.stark.utils.FsLogUtil;
import com.fshows.android.stark.utils.UiHandlerUtil;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class SchemeDispatcher {
    private static final String TAG = "STARK.scheme";
    private static SchemeDispatcher instance = null;
    private List<ISchemeAction> actions = Lists.newArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SchemeDispatcher getInstance() {
        if (instance != null) return instance;
        Class<SchemeDispatcher> clazz = SchemeDispatcher.class;
        synchronized (SchemeDispatcher.class) {
            if (instance != null) return instance;
            instance = new SchemeDispatcher();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private SchemeDispatcher() {
    }

    public boolean registerAction(ISchemeAction schemeAction) {
        if (schemeAction == null) {
            return false;
        }
        SchemeData signature = schemeAction.getSignature();
        boolean isContains = Stream.of(this.actions).anyMatch(p -> this.isMatchSignatureSchemeData(p.getSignature(), schemeAction.getSignature()));
        if (isContains) {
            return false;
        }
        this.actions.add(schemeAction);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAction(ISchemeAction schemeAction) {
        if (schemeAction == null) {
            return;
        }
        Class<SchemeDispatcher> clazz = SchemeDispatcher.class;
        synchronized (SchemeDispatcher.class) {
            SchemeData signature = schemeAction.getSignature();
            List matchedActions = Stream.of(this.actions).filter(p -> this.isMatchSignatureSchemeData(p.getSignature(), schemeAction.getSignature())).toList();
            this.actions.removeAll(matchedActions);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean onNewScheme(Context context, Uri uri) {
        return this.onNewScheme(context, uri == null ? null : uri.toString());
    }

    public boolean onNewScheme(Context context, String url) {
        return this.onNewScheme(context, url, "");
    }

    public boolean onNewScheme(Context context, String url, String extra) {
        if (StringUtils.isEmpty((CharSequence)url)) {
            return false;
        }
        FsLogUtil.debug(TAG, "dispatch url: {} extra: {}", url, extra);
        SchemeData schemeData = SchemeParser.parse(url);
        schemeData.setExtra(extra);
        return this.onNewScheme(context, schemeData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onNewScheme(Context context, SchemeData schemeData) {
        if (schemeData == null) {
            return false;
        }
        boolean handleScheme = false;
        Class<SchemeDispatcher> clazz = SchemeDispatcher.class;
        synchronized (SchemeDispatcher.class) {
            for (ISchemeAction action : this.actions) {
                if (!this.isMatchSignatureSchemeData(action.getSignature(), schemeData)) continue;
                handleScheme = true;
                UiHandlerUtil.runOnUiThread(() -> action.doAction(context, schemeData));
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return handleScheme;
        }
    }

    private boolean isMatchSignatureSchemeData(SchemeData signatureSchemeData, SchemeData schemeData) {
        Map<String, String> sigSd = signatureSchemeData.getData();
        Map<String, String> sd = schemeData.getData();
        for (Map.Entry<String, String> entry : sigSd.entrySet()) {
            String v2;
            String k1 = entry.getKey();
            String v1 = entry.getValue();
            if (!sd.containsKey(k1) || v1.equalsIgnoreCase(v2 = sd.get(k1))) continue;
            return false;
        }
        return true;
    }
}

