/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.newlog;

import android.content.Context;
import androidx.annotation.Nullable;
import com.aliyun.sls.android.sdk.ClientConfiguration;
import com.aliyun.sls.android.sdk.LOGClient;
import com.aliyun.sls.android.sdk.LogException;
import com.aliyun.sls.android.sdk.SLSLog;
import com.aliyun.sls.android.sdk.core.auth.CredentialProvider;
import com.aliyun.sls.android.sdk.core.auth.PlainTextAKSKCredentialProvider;
import com.aliyun.sls.android.sdk.core.auth.StsTokenCredentialProvider;
import com.aliyun.sls.android.sdk.core.callback.CompletedCallback;
import com.aliyun.sls.android.sdk.model.Log;
import com.aliyun.sls.android.sdk.model.LogGroup;
import com.aliyun.sls.android.sdk.request.PostLogRequest;
import com.aliyun.sls.android.sdk.result.PostLogResult;
import com.fshows.android.stark.FsFoundationInitializer;
import com.fshows.android.stark.newlog.AndroidLogAdapter;
import com.fshows.android.stark.newlog.FsLog;
import com.fshows.android.stark.newlog.FsLogPrinter;
import com.fshows.android.stark.newlog.SlsLogConfig;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractSlsLogServer {
    protected final Context context;
    private final SlsLogConfig slsLogConfig;
    private final FsLog mLogger;
    private LOGClient logClient;

    public AbstractSlsLogServer(Context context) {
        this.context = context;
        this.slsLogConfig = this.getSlsLogConfig();
        FsLogPrinter printer = new FsLogPrinter();
        printer.addLogAdapter(new AndroidLogAdapter(){

            @Override
            public boolean isLoggable(int priority, String tag) {
                return FsFoundationInitializer.isDebug() || priority > 3;
            }
        });
        this.mLogger = new FsLog(printer);
        this.initSlsLogConfig();
    }

    private void initSlsLogConfig() {
        String stsAk = this.slsLogConfig.getStsAk();
        String stsSk = this.slsLogConfig.getStsSk();
        String stsToken = this.slsLogConfig.getStsToken();
        Object credentialProvider = Strings.isNullOrEmpty((String)stsToken) ? new PlainTextAKSKCredentialProvider(stsAk, stsSk) : new StsTokenCredentialProvider(stsAk, stsSk, stsToken);
        ClientConfiguration conf = new ClientConfiguration();
        conf.setConnectionTimeout(15000);
        conf.setSocketTimeout(15000);
        conf.setMaxConcurrentRequest(5);
        conf.setMaxErrorRetry(2);
        conf.setCachable(Boolean.valueOf(false));
        conf.setConnectType(ClientConfiguration.NetworkPolicy.WWAN_OR_WIFI);
        SLSLog.enableLog();
        this.logClient = new LOGClient(this.context.getApplicationContext(), this.slsLogConfig.getEndpoint(), (CredentialProvider)credentialProvider, conf);
    }

    protected void uploadSlsLog(HashMap<String, String> params) {
        String key;
        Log log = new Log();
        HashMap<String, String> commonParams = this.getCommonParams();
        if (commonParams != null) {
            for (Map.Entry<Object, Object> entry : commonParams.entrySet()) {
                key = (String)entry.getKey();
                if (StringUtils.isEmpty((CharSequence)key)) continue;
                log.PutContent(key, (String)entry.getValue());
            }
        }
        if (params != null) {
            for (Map.Entry<Object, Object> entry : params.entrySet()) {
                key = (String)entry.getKey();
                if (StringUtils.isEmpty((CharSequence)key)) continue;
                log.PutContent(key, (String)entry.getValue());
            }
        }
        String paramStr = Joiner.on((String)"^").withKeyValueSeparator("=").join(log.GetContent());
        this.mLogger.i(paramStr, new Object[0]);
        this.asyncUploadSlsLog(log);
    }

    private void asyncUploadSlsLog(@Nullable Log log) {
        LogGroup logGroup = new LogGroup(this.getTopic(), null);
        logGroup.PutLog(log);
        try {
            PostLogRequest request = new PostLogRequest(this.slsLogConfig.getProject(), this.slsLogConfig.getLogStore(), logGroup);
            this.logClient.asyncPostLog(request, (CompletedCallback)new CompletedCallback<PostLogRequest, PostLogResult>(){

                public void onSuccess(PostLogRequest request, PostLogResult result) {
                    AbstractSlsLogServer.this.mLogger.i("\u5728\u7ebf\u4e1a\u52a1\u5199\u5165\u6210\u529f", new Object[0]);
                }

                public void onFailure(PostLogRequest request, LogException exception) {
                    AbstractSlsLogServer.this.mLogger.e("\u5728\u7ebf\u4e1a\u52a1\u5199\u5165\u5f02\u5e38", (Throwable)exception, new Object[0]);
                }
            });
        }
        catch (LogException e) {
            e.printStackTrace();
        }
    }

    public abstract String getTopic();

    public abstract SlsLogConfig getSlsLogConfig();

    public abstract HashMap<String, String> getCommonParams();
}

