/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.download;

import android.os.Handler;
import android.os.HandlerThread;
import android.os.Looper;
import android.os.Message;
import android.support.v4.util.ArrayMap;
import com.fshows.android.stark.download.DownloadObj;
import com.fshows.android.stark.download.DownloadTask;
import com.fshows.android.stark.download.DownloadThreadPoolExecutor;
import okhttp3.OkHttpClient;
import okhttp3.OkUrlFactory;

public class DownloadDispatcher {
    static final int THREAD_COUNT = 3;
    static final int REMOVE_DIRECTLY = 0;
    static final int REMOVE_WAIT = -1;
    static final int DELETE_DIRECTLY = 0;
    static final int DELETE_WAIT = 1;
    final DispatcherThread dispatcherThread;
    final Handler handler;
    private static DownloadDispatcher INSTANCE = null;
    protected OkUrlFactory urlFactory;
    protected DownloadThreadPoolExecutor threadPool;
    protected Object syncLock = new Object();
    private ArrayMap<String, DownloadTask> taskMap;
    private ArrayMap<String, DownloadTask> onGoningTaskMap;
    protected static final int MSG_DOWNLOAD_START = 1;
    protected static final int MSG_DOWNLOAD_PROGRESS = 2;
    protected static final int MSG_DOWNLOAD_SUCCESS = 3;
    protected static final int MSG_DOWNLOAD_FAIL = 4;
    protected static final int MSG_DOWNLOAD_PAUSE = 5;
    protected static final int MSG_DOWNLOAD_STOP = 6;
    protected static final int MSG_DOWNLOAD_DELETE = 7;
    protected static final int MSG_DOWNLOAD_PRE_START = 8;

    private DownloadDispatcher(int threadCount) {
        this.dispatcherThread = new DispatcherThread();
        this.dispatcherThread.start();
        this.handler = new DispatcherHandler(Looper.getMainLooper());
        OkHttpClient.Builder mBuilder = new OkHttpClient.Builder();
        this.urlFactory = new OkUrlFactory(mBuilder.build());
        this.threadPool = new DownloadThreadPoolExecutor(threadCount);
        this.taskMap = new ArrayMap();
        this.onGoningTaskMap = new ArrayMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DownloadDispatcher getInstance() {
        if (INSTANCE != null) return INSTANCE;
        Class<DownloadDispatcher> clazz = DownloadDispatcher.class;
        synchronized (DownloadDispatcher.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new DownloadDispatcher(3);
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public void dispatch(DownloadTask tsk) {
        this.taskReference(tsk);
        if (this.taskMap != null && this.taskMap.size() > 3) {
            this.reportTaskPreStart(tsk);
        }
        this.threadPool.execute(tsk);
    }

    void reportTaskPreStart(DownloadTask tsk) {
        Message msg = this.handler.obtainMessage();
        msg.what = 8;
        msg.obj = new DownloadObj(tsk, tsk.url, null);
        this.handler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int remove(DownloadTask tsk) {
        boolean taskOngoning = false;
        Object object = this.syncLock;
        synchronized (object) {
            taskOngoning = this.onGoningTaskMap.containsKey((Object)tsk.url);
        }
        if (taskOngoning) {
            return -1;
        }
        this.threadPool.remove(tsk);
        this.removeTaskReference(tsk);
        this.reportTaskDirectlyCanceled(tsk);
        return 0;
    }

    void reportTaskDirectlyCanceled(DownloadTask tsk) {
        Message msg = this.handler.obtainMessage();
        msg.what = 6;
        msg.obj = new DownloadObj(tsk, tsk.url, null);
        this.handler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int delete(DownloadTask tsk) {
        boolean taskOngoing = false;
        Object object = this.syncLock;
        synchronized (object) {
            taskOngoing = this.onGoningTaskMap.containsKey((Object)tsk.url);
        }
        if (taskOngoing) {
            return 1;
        }
        this.threadPool.remove(tsk);
        this.removeTaskReference(tsk);
        this.reportTaskDirectlyDeleted(tsk);
        return 0;
    }

    void reportTaskDirectlyDeleted(DownloadTask tsk) {
        Message msg = this.handler.obtainMessage();
        msg.what = 7;
        msg.obj = new DownloadObj(tsk, tsk.url, null);
        this.handler.sendMessage(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DownloadTask getTask(String url) {
        if (this.taskMap == null) {
            return null;
        }
        DownloadTask tsk = null;
        Object object = this.syncLock;
        synchronized (object) {
            tsk = (DownloadTask)this.taskMap.get((Object)url);
        }
        return tsk;
    }

    public void shutdown() {
        this.dispatcherThread.quit();
        this.threadPool.shutdown();
        this.taskMap.clear();
        this.onGoningTaskMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void taskReference(DownloadTask tsk) {
        if (this.taskMap == null) {
            return;
        }
        Object object = this.syncLock;
        synchronized (object) {
            this.taskMap.put((Object)tsk.url, (Object)tsk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void taskOngoingReference(DownloadTask tsk) {
        if (this.onGoningTaskMap == null) {
            return;
        }
        Object object = this.syncLock;
        synchronized (object) {
            this.onGoningTaskMap.put((Object)tsk.url, (Object)tsk);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTaskReference(DownloadTask tsk) {
        if (this.taskMap != null) {
            Object object = this.syncLock;
            synchronized (object) {
                this.taskMap.remove((Object)tsk.url);
            }
        }
        if (this.onGoningTaskMap != null) {
            this.onGoningTaskMap.remove((Object)tsk.url);
        }
    }

    class DispatcherHandler
    extends Handler {
        public DispatcherHandler(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            int what = msg.what;
            switch (what) {
                case 8: {
                    this.onDownloadPreStart(msg);
                    break;
                }
                case 1: {
                    this.onDownloadStart(msg);
                    break;
                }
                case 2: {
                    this.onDownloadProgress(msg);
                    break;
                }
                case 3: {
                    this.onDownloadSuccess(msg);
                    break;
                }
                case 4: {
                    this.onDownloadFail(msg);
                    break;
                }
                case 5: {
                    this.onDownloadPause(msg);
                    break;
                }
                case 6: {
                    this.onDownloadStop(msg);
                    break;
                }
                case 7: {
                    this.onDownloadDelete(msg);
                    break;
                }
            }
        }

        private void onDownloadPreStart(Message msg) {
            DownloadObj obj = (DownloadObj)msg.obj;
            obj.tsk.callback.onDownloadPreStart(obj.downloadUrl);
        }

        private void onDownloadStart(Message msg) {
            DownloadObj obj = (DownloadObj)msg.obj;
            DownloadDispatcher.this.taskOngoingReference(obj.tsk);
            obj.tsk.callback.onDownloadStart(obj.downloadUrl);
        }

        private void onDownloadProgress(Message msg) {
            DownloadObj obj = (DownloadObj)msg.obj;
            obj.tsk.callback.onDownloadProgress(obj.downloadUrl, obj.getDownloaded(), obj.getTotal());
        }

        private void onDownloadSuccess(Message msg) {
            DownloadObj obj = (DownloadObj)msg.obj;
            DownloadDispatcher.this.removeTaskReference(obj.tsk);
            obj.tsk.callback.onDownloadSuccess(obj.downloadUrl, obj.apkFile);
        }

        private void onDownloadFail(Message msg) {
            DownloadObj obj = (DownloadObj)msg.obj;
            DownloadDispatcher.this.removeTaskReference(obj.tsk);
            obj.tsk.callback.onDownloadFail(obj.downloadUrl);
        }

        private void onDownloadPause(Message msg) {
            DownloadObj obj = (DownloadObj)msg.obj;
            DownloadDispatcher.this.removeTaskReference(obj.tsk);
            obj.tsk.callback.onDownloadPause(obj.downloadUrl);
        }

        private void onDownloadStop(Message msg) {
            DownloadObj obj = (DownloadObj)msg.obj;
            DownloadDispatcher.this.removeTaskReference(obj.tsk);
            obj.tsk.callback.onDownloadStop(obj.downloadUrl);
        }

        private void onDownloadDelete(Message msg) {
            DownloadObj obj = (DownloadObj)msg.obj;
            DownloadDispatcher.this.removeTaskReference(obj.tsk);
            obj.tsk.callback.onDownloadDelete(obj.downloadUrl);
        }
    }

    static class DispatcherThread
    extends HandlerThread {
        private static final String THREAD_NAME = "download-callbackThread";

        public DispatcherThread() {
            super(THREAD_NAME, 10);
        }
    }
}

