/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.util.Log;
import com.fshows.android.stark.utils.GsonUtil;
import com.google.gson.reflect.TypeToken;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class Prefs {
    private static final String TAG = Prefs.class.getSimpleName();
    private static SharedPreferences sharedPreference;

    public static SharedPreferences getInstance() {
        return sharedPreference;
    }

    public static void init(Context context) {
        sharedPreference = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    private static void checkIfNull() {
        if (sharedPreference == null) {
            Log.e((String)TAG, (String)"Warning,PreferenceManager init ERROR.");
        }
    }

    public static void addBooleanPreference(String key, boolean b) {
        Prefs.checkIfNull();
        SharedPreferences.Editor editor = sharedPreference.edit();
        editor.putBoolean(key, b);
        editor.commit();
    }

    public static void addFloatPreference(String key, float f) {
        Prefs.checkIfNull();
        SharedPreferences.Editor editor = sharedPreference.edit();
        editor.putFloat(key, f);
        editor.commit();
    }

    public static void addIntPreference(String key, int i) {
        Prefs.checkIfNull();
        SharedPreferences.Editor editor = sharedPreference.edit();
        editor.putInt(key, i);
        editor.commit();
    }

    public static void addLongPreference(String key, long l) {
        Prefs.checkIfNull();
        SharedPreferences.Editor editor = sharedPreference.edit();
        editor.putLong(key, l);
        editor.commit();
    }

    public static void addStringPreference(String key, String s) {
        Prefs.checkIfNull();
        SharedPreferences.Editor editor = sharedPreference.edit();
        editor.putString(key, s);
        editor.commit();
    }

    public static void addStringSetPreference(String key, Set<String> stringSet) {
        Prefs.checkIfNull();
        SharedPreferences.Editor editor = sharedPreference.edit();
        editor.putStringSet(key, stringSet);
        editor.commit();
    }

    public static void addDoublePreference(String key, double d) {
        Prefs.checkIfNull();
        SharedPreferences.Editor editor = sharedPreference.edit();
        editor.putLong(key, Double.doubleToRawLongBits(d));
        editor.commit();
    }

    public static Object getPreference(String key, Object defaultValue) {
        Prefs.checkIfNull();
        Object res = sharedPreference.getAll().get(key);
        return res == null ? defaultValue : res;
    }

    public static boolean getBooleanPreference(String key, boolean defaultValue) {
        Prefs.checkIfNull();
        try {
            Object object = sharedPreference.getAll().get(key);
            if (object == null) {
                return defaultValue;
            }
            return (Boolean)object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static String getStringPreference(String key, String defaultValue) {
        Prefs.checkIfNull();
        String res = null;
        try {
            res = (String)sharedPreference.getAll().get(key);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (res != null) {
            return res.toString();
        }
        return defaultValue;
    }

    public static int getIntPreference(String key, int defaultValue) {
        Prefs.checkIfNull();
        try {
            Object object = sharedPreference.getAll().get(key);
            if (object == null) {
                return defaultValue;
            }
            return (Integer)object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static double getDoublePreference(String key) {
        return Double.longBitsToDouble(Prefs.getLongPreference(key, 0L));
    }

    public static long getLongPreference(String key, long defaultValue) {
        Prefs.checkIfNull();
        try {
            Object object = sharedPreference.getAll().get(key);
            if (object == null) {
                return defaultValue;
            }
            return (Long)object;
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    public static Map<String, ?> getAllPreference() {
        Prefs.checkIfNull();
        return sharedPreference.getAll();
    }

    public static <K, T> void addMapPreference(String key, Map<K, T> map) {
        Prefs.checkIfNull();
        try {
            String json = GsonUtil.getGson().toJson(map);
            Prefs.addStringPreference(key, json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <K, T> Map<K, T> getMapPreference(String key) {
        Map map = new HashMap();
        String strJson = Prefs.getStringPreference(key, null);
        if (strJson == null || strJson.length() == 0) {
            return map;
        }
        try {
            map = (Map)GsonUtil.getGson().fromJson(strJson, new TypeToken<Map<K, T>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }
}

