/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import android.content.Context;
import android.util.Log;
import com.fshows.android.stark.FsFoundationInitializer;
import com.fshows.android.stark.download.DownloadUtils;
import com.fshows.android.stark.utils.CommonUtil;
import com.fshows.android.stark.utils.FileCacheUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import okhttp3.OkHttpClient;
import okhttp3.OkUrlFactory;

public class FileCacheTask {
    private static final String TAG = "FileCacheTask";
    private static final String REQUEST_METHOD = "GET";
    private static final String HEADER_RANGE = "RANGE";
    private Context context;
    private String url;
    private String dirName;
    private OkUrlFactory urlFactory;
    private boolean supportBreakPointResume;
    private long downloadedSize;
    private long totalSize;
    private boolean alive;
    private int retryTimes;
    private File tempFile;
    private File cacheFile;

    public FileCacheTask(Context context, String url, String dirName) {
        this(context, url, dirName, false);
    }

    public FileCacheTask(Context context, String url, String dirName, boolean supportBreakPointResume) {
        this.context = context;
        this.url = url;
        this.dirName = dirName;
        this.supportBreakPointResume = supportBreakPointResume;
        OkHttpClient.Builder mBuilder = new OkHttpClient.Builder();
        this.urlFactory = new OkUrlFactory(mBuilder.build());
        this.downloadedSize = 0L;
        this.totalSize = 0L;
        this.retryTimes = 2;
        this.alive = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        HttpURLConnection connection = null;
        InputStream is = null;
        BufferedOutputStream bos = null;
        String retPath = null;
        if (this.url == null || this.url.trim().length() <= 0) {
            return retPath;
        }
        for (int i = 0; this.alive && is == null && i < this.retryTimes; ++i) {
            block20: {
                block19: {
                    block18: {
                        block17: {
                            if (!FileCacheUtil.isFileCached(this.context, this.dirName, this.url)) break block17;
                            String string = retPath = FileCacheUtil.getCacheFilePath(this.context, this.dirName, this.url);
                            CommonUtil.silentClose(bos);
                            CommonUtil.silentClose(is);
                            CommonUtil.closeConnection(connection);
                            if (retPath == null && !this.supportBreakPointResume) {
                                this.deleteCacheFileOnError();
                            }
                            return string;
                        }
                        connection = this.openDownloadConnection();
                        this.tempFile = new File(FileCacheUtil.getTempCacheFilePath(this.context, this.dirName, this.url));
                        if (!this.supportBreakPointResume && this.tempFile.exists()) {
                            this.tempFile.delete();
                        }
                        this.downloadedSize = this.tempFile.length();
                        bos = new BufferedOutputStream(new FileOutputStream(this.tempFile, this.downloadedSize > 0L));
                        this.attachFileRangeHeader(connection);
                        int statusCode = connection.getResponseCode();
                        if (FsFoundationInitializer.isDebug()) {
                            Log.d((String)TAG, (String)("statusCode : " + statusCode));
                        }
                        if (statusCode == 200 || statusCode == 206) break block18;
                        CommonUtil.silentClose(bos);
                        CommonUtil.silentClose(is);
                        CommonUtil.closeConnection(connection);
                        if (retPath != null || this.supportBreakPointResume) continue;
                        this.deleteCacheFileOnError();
                        continue;
                    }
                    if (this.alive) break block19;
                    String string = retPath = null;
                    CommonUtil.silentClose(bos);
                    CommonUtil.silentClose(is);
                    CommonUtil.closeConnection(connection);
                    if (retPath == null && !this.supportBreakPointResume) {
                        this.deleteCacheFileOnError();
                    }
                    return string;
                }
                this.totalSize = this.parseFileSize(connection);
                if (this.totalSize != this.downloadedSize) break block20;
                String string = retPath = FileCacheUtil.getCacheFilePath(this.context, this.dirName, this.url);
                CommonUtil.silentClose(bos);
                CommonUtil.silentClose(is);
                CommonUtil.closeConnection(connection);
                if (retPath == null && !this.supportBreakPointResume) {
                    this.deleteCacheFileOnError();
                }
                return string;
            }
            try {
                is = connection.getInputStream();
                retPath = this.save2File(is, bos);
            }
            catch (Exception e) {
                try {
                    if (FsFoundationInitializer.isDebug()) {
                        Log.e((String)TAG, (String)"Exception", (Throwable)e);
                    }
                    retPath = null;
                }
                catch (Throwable throwable) {
                    CommonUtil.silentClose(bos);
                    CommonUtil.silentClose(is);
                    CommonUtil.closeConnection(connection);
                    if (retPath == null && !this.supportBreakPointResume) {
                        this.deleteCacheFileOnError();
                    }
                    throw throwable;
                }
                CommonUtil.silentClose(bos);
                CommonUtil.silentClose(is);
                CommonUtil.closeConnection(connection);
                if (retPath != null || this.supportBreakPointResume) continue;
                this.deleteCacheFileOnError();
                continue;
            }
            CommonUtil.silentClose(bos);
            CommonUtil.silentClose(is);
            CommonUtil.closeConnection(connection);
            if (retPath != null || this.supportBreakPointResume) continue;
            this.deleteCacheFileOnError();
            continue;
        }
        return retPath;
    }

    public void cancel() {
        this.alive = false;
    }

    private HttpURLConnection openDownloadConnection() throws IOException {
        HttpURLConnection connection = this.urlFactory.open(new URL(this.url));
        connection.setDoInput(true);
        connection.setRequestMethod(REQUEST_METHOD);
        return connection;
    }

    private void attachFileRangeHeader(HttpURLConnection connection) {
        if (!this.supportBreakPointResume) {
            return;
        }
        connection.addRequestProperty(HEADER_RANGE, this.composeRangeValue(this.downloadedSize));
    }

    private String composeRangeValue(long range) {
        StringBuilder sb = new StringBuilder();
        sb.append("bytes=").append(range).append("-");
        return sb.toString();
    }

    private void deleteCacheFileOnError() {
        this.tempFile.delete();
    }

    private long parseFileSize(HttpURLConnection connection) throws Exception {
        if (this.downloadedSize == 0L) {
            String contentLength = connection.getHeaderField("Content-Length");
            if (contentLength == null) {
                throw new IllegalArgumentException("no content length exist");
            }
            if (contentLength.trim().length() == 0) {
                throw new IllegalAccessException("content length should be set");
            }
            return Long.valueOf(contentLength);
        }
        String contentRange = connection.getHeaderField("Content-Range");
        if (contentRange == null) {
            throw new IllegalArgumentException("no content Range exist");
        }
        if (contentRange.trim().length() == 0) {
            throw new IllegalAccessException("content Range should be set");
        }
        int startIndex = contentRange.indexOf("/");
        return Long.valueOf(contentRange.substring(startIndex + 1, contentRange.length()));
    }

    private String save2File(InputStream is, BufferedOutputStream bos) throws Exception {
        byte[] buffer = new byte[4096];
        int count = -1;
        while (this.alive && (count = is.read(buffer)) != -1) {
            bos.write(buffer, 0, count);
            this.downloadedSize += (long)count;
        }
        if (this.downloadedSize == this.totalSize) {
            this.cacheFile = new File(FileCacheUtil.getCacheFilePath(this.context, this.dirName, this.url));
            DownloadUtils.renameFile(this.tempFile, this.cacheFile);
            return this.cacheFile.getAbsolutePath();
        }
        if (!this.alive && !this.supportBreakPointResume) {
            return null;
        }
        return null;
    }
}

