/*
 * Decompiled with CFR 0.152.
 */
package anet.channel.statist;

import anet.channel.Session;
import anet.channel.statist.Dimension;
import anet.channel.statist.Measure;
import anet.channel.statist.Monitor;
import anet.channel.statist.SessionStatistic;
import anet.channel.statist.StatObject;
import anet.channel.status.NetworkStatusHelper;
import org.json.JSONException;
import org.json.JSONObject;

@Monitor(module="networkPrefer", monitorPoint="conn_stat")
public class SessionConnStat
extends StatObject {
    @Dimension
    public String netType = NetworkStatusHelper.getNetworkSubType();
    @Dimension
    public String ip;
    @Dimension
    public int port;
    @Dimension
    public int ipRefer = 0;
    @Dimension
    public int ipType = 1;
    @Dimension
    public String protocolType;
    @Dimension
    public String host;
    @Dimension
    public int ret;
    @Dimension
    public int retryTimes = -1;
    @Dimension
    public String errorCode;
    @Dimension
    public String errorMsg;
    @Dimension
    public double lng = 90000.0;
    @Dimension
    public double lat = 90000.0;
    @Dimension
    public float accuracy = -1.0f;
    @Dimension
    public int roaming;
    @Dimension
    public int isProxy = 0;
    @Dimension
    public String mnc;
    @Dimension
    public String bssid = NetworkStatusHelper.getWifiBSSID();
    @Dimension
    public String unit;
    @Dimension
    public StringBuilder errorTrace;
    @Dimension
    public JSONObject extra;
    @Measure(max=60000.0)
    public long totalTime = 0L;
    @Measure(max=60000.0)
    public long authTime = 0L;
    public volatile boolean isCommited = false;
    public volatile long start = 0L;
    public volatile long startConnect = 0L;

    public SessionConnStat() {
        this.roaming = NetworkStatusHelper.isRoaming() ? 1 : 0;
        this.mnc = NetworkStatusHelper.getSimOp();
    }

    public void syncValueFromSession(Session session) {
        SessionStatistic sessionStatistic = session.q;
        this.ip = sessionStatistic.ip;
        this.port = sessionStatistic.port;
        this.ipRefer = sessionStatistic.ipRefer;
        this.ipType = sessionStatistic.ipType;
        this.protocolType = sessionStatistic.conntype;
        this.host = sessionStatistic.host;
        this.isProxy = sessionStatistic.isProxy;
        this.authTime = sessionStatistic.authTime;
        this.unit = session.getUnit();
        if (this.unit == null && this.ipRefer == 1) {
            this.unit = "LocalDNS";
        }
    }

    @Override
    public boolean beforeCommit() {
        if (this.isCommited) {
            return false;
        }
        this.isCommited = true;
        return true;
    }

    public void appendErrorTrace(int n2) {
        if (this.errorTrace == null) {
            this.errorTrace = new StringBuilder();
        }
        if (this.errorTrace.length() > 0) {
            this.errorTrace.append(",");
        }
        this.errorTrace.append(n2).append("=").append(System.currentTimeMillis() - this.startConnect);
    }

    public void putExtra(String string, Object object) {
        try {
            if (this.extra == null) {
                this.extra = new JSONObject();
            }
            this.extra.put(string, object);
            return;
        }
        catch (JSONException jSONException) {
            return;
        }
    }
}

