/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.mtl.appmonitor;

import android.app.Application;
import android.content.Context;
import android.text.TextUtils;
import com.alibaba.mtl.appmonitor.Transaction;
import com.alibaba.mtl.appmonitor.a.e;
import com.alibaba.mtl.appmonitor.a.f;
import com.alibaba.mtl.appmonitor.b.a;
import com.alibaba.mtl.appmonitor.c;
import com.alibaba.mtl.appmonitor.d.j;
import com.alibaba.mtl.appmonitor.f.b;
import com.alibaba.mtl.appmonitor.model.DimensionSet;
import com.alibaba.mtl.appmonitor.model.DimensionValueSet;
import com.alibaba.mtl.appmonitor.model.Measure;
import com.alibaba.mtl.appmonitor.model.MeasureSet;
import com.alibaba.mtl.appmonitor.model.MeasureValueSet;
import com.alibaba.mtl.appmonitor.model.Metric;
import com.alibaba.mtl.appmonitor.model.MetricRepo;
import com.alibaba.mtl.log.d.i;
import com.alibaba.mtl.log.d.l;
import com.alibaba.mtl.log.sign.BaseRequestAuth;
import com.alibaba.mtl.log.sign.IRequestAuth;
import com.alibaba.mtl.log.sign.SecurityRequestAuth;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class AppMonitorDelegate {
    public static final String TAG = "AppMonitorDelegate";
    public static boolean IS_DEBUG = false;
    private static Application b;
    static volatile boolean i;
    public static final String DEFAULT_VALUE = "defaultValue";
    public static final String MAX_VALUE = "maxValue";
    public static final String MIN_VALUE = "minValue";

    public static synchronized void init(Application application) {
        com.alibaba.mtl.log.d.i.a(TAG, new Object[]{"start init"});
        try {
            if (!i) {
                b = application;
                com.alibaba.mtl.log.a.a(application.getApplicationContext());
                com.alibaba.mtl.appmonitor.b.init();
                c.init();
                com.alibaba.mtl.appmonitor.a.init(application);
                l.b(application.getApplicationContext());
                i = true;
            }
        }
        catch (Throwable throwable) {
            AppMonitorDelegate.destroy();
        }
    }

    public static synchronized void destroy() {
        try {
            com.alibaba.mtl.log.d.i.a(TAG, new Object[]{"start destory"});
            if (i) {
                c.d();
                c.destroy();
                com.alibaba.mtl.appmonitor.b.destroy();
                if (b != null) {
                    l.c(b.getApplicationContext());
                }
                i = false;
            }
        }
        catch (Throwable throwable) {
            com.alibaba.mtl.appmonitor.b.b.a(throwable);
        }
    }

    public static synchronized void triggerUpload() {
        try {
            com.alibaba.mtl.log.d.i.a(TAG, new Object[]{"triggerUpload"});
            if (i && com.alibaba.mtl.log.a.a.f()) {
                c.d();
            }
        }
        catch (Throwable throwable) {
            com.alibaba.mtl.appmonitor.b.b.a(throwable);
        }
    }

    public static void setStatisticsInterval(int statisticsInterval) {
        for (f f2 : f.values()) {
            f2.setStatisticsInterval(statisticsInterval);
            AppMonitorDelegate.setStatisticsInterval(f2, statisticsInterval);
        }
    }

    public static void setSampling(int sampling) {
        f[] fArray;
        com.alibaba.mtl.log.d.i.a(TAG, new Object[]{"[setSampling]"});
        for (f f2 : fArray = f.values()) {
            f2.c(sampling);
            j.a().a(f2, sampling);
        }
    }

    public static void enableLog(boolean open) {
        com.alibaba.mtl.log.d.i.a(TAG, new Object[]{"[enableLog]"});
        com.alibaba.mtl.log.d.i.d(open);
    }

    public static void register(String module, String monitorPoint, MeasureSet measures) {
        AppMonitorDelegate.register(module, monitorPoint, measures, null);
    }

    public static void register(String module, String monitorPoint, MeasureSet measures, boolean isCommitDetail) {
        AppMonitorDelegate.register(module, monitorPoint, measures, null, isCommitDetail);
    }

    public static void register(String module, String monitorPoint, MeasureSet measures, DimensionSet dimensions) {
        AppMonitorDelegate.register(module, monitorPoint, measures, dimensions, false);
    }

    public static void register(String module, String monitorPoint, MeasureSet measures, DimensionSet dimensions, boolean isCommitDetail) {
        try {
            if (i) {
                if (com.alibaba.mtl.appmonitor.f.b.d(module) || com.alibaba.mtl.appmonitor.f.b.d(monitorPoint)) {
                    com.alibaba.mtl.log.d.i.a(TAG, new Object[]{"register stat event. module: ", module, " monitorPoint: ", monitorPoint});
                    if (IS_DEBUG) {
                        throw new a("register error. module and monitorPoint can't be null");
                    }
                    return;
                }
                Metric metric = new Metric(module, monitorPoint, measures, dimensions, isCommitDetail);
                MetricRepo.getRepo().add(metric);
            }
        }
        catch (Throwable throwable) {
            com.alibaba.mtl.appmonitor.b.b.a(throwable);
        }
    }

    public static void updateMeasure(String module, String monitorPoint, String measureName, double min, double max, double defaultValue) {
        com.alibaba.mtl.log.d.i.a(TAG, new Object[]{"[updateMeasure]"});
        try {
            if (i) {
                if (com.alibaba.mtl.appmonitor.f.b.d(module) || com.alibaba.mtl.appmonitor.f.b.d(monitorPoint)) {
                    return;
                }
                Metric metric = MetricRepo.getRepo().getMetric(module, monitorPoint);
                if (metric != null && metric.getMeasureSet() != null) {
                    metric.getMeasureSet().upateMeasure(new Measure(measureName, defaultValue, min, max));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static void setStatisticsInterval(f eventType, int statisticsInterval) {
        try {
            if (i && eventType != null) {
                c.a(eventType.a(), statisticsInterval);
                if (statisticsInterval > 0) {
                    eventType.b(true);
                } else {
                    eventType.b(false);
                }
            }
        }
        catch (Throwable throwable) {
            com.alibaba.mtl.appmonitor.b.b.a(throwable);
        }
    }

    public static void setRequestAuthInfo(boolean isSecurity, String appkey, String secret, String authcode) {
        IRequestAuth iRequestAuth = null;
        if (isSecurity) {
            iRequestAuth = new SecurityRequestAuth(appkey, authcode);
        } else {
            boolean bl = false;
            if ("1".equalsIgnoreCase(authcode)) {
                bl = true;
            }
            iRequestAuth = new BaseRequestAuth(appkey, secret, bl);
        }
        com.alibaba.mtl.log.a.a(iRequestAuth);
        com.alibaba.mtl.log.a.a.a((Context)b);
    }

    public static void setChannel(String channel) {
        com.alibaba.mtl.log.a.setChannel(channel);
    }

    public static void turnOnRealTimeDebug(Map<String, String> params) {
        com.alibaba.mtl.log.a.a.turnOnRealTimeDebug(params);
    }

    public static void turnOffRealTimeDebug() {
        com.alibaba.mtl.log.d.i.a(TAG, new Object[]{"[turnOffRealTimeDebug]"});
    }

    static {
        i = false;
    }

    public static class Stat {
        public static void setStatisticsInterval(int statisticsInterval) {
            f.d.setStatisticsInterval(statisticsInterval);
            AppMonitorDelegate.setStatisticsInterval(f.d, statisticsInterval);
        }

        public static void setSampling(int sampling) {
            j.a().a(f.d, sampling);
        }

        @Deprecated
        public static boolean checkSampled(String module, String monitorPoint) {
            return j.a(f.d, module, monitorPoint);
        }

        public static void begin(String module, String monitorPoint, String measureName) {
            try {
                if (i && com.alibaba.mtl.log.a.a.f() && f.d.isOpen() && (IS_DEBUG || j.a(f.d, module, monitorPoint))) {
                    com.alibaba.mtl.log.d.i.a(AppMonitorDelegate.TAG, new Object[]{"statEvent begin. module: ", module, " monitorPoint: ", monitorPoint, " measureName: ", measureName});
                    e.a().a(f.d.a(), module, monitorPoint, measureName);
                }
            }
            catch (Throwable throwable) {
                com.alibaba.mtl.appmonitor.b.b.a(throwable);
            }
        }

        public static void end(String module, String monitorPoint, String measureName) {
            try {
                if (i && com.alibaba.mtl.log.a.a.f() && f.d.isOpen() && (IS_DEBUG || j.a(f.d, module, monitorPoint))) {
                    com.alibaba.mtl.log.d.i.a(AppMonitorDelegate.TAG, new Object[]{"statEvent end. module: ", module, " monitorPoint: ", monitorPoint, " measureName: ", measureName});
                    e.a().a(module, monitorPoint, measureName);
                }
            }
            catch (Throwable throwable) {
                com.alibaba.mtl.appmonitor.b.b.a(throwable);
            }
        }

        public static Transaction createTransaction(String module, String monitorPoint) {
            return Stat.createTransaction(module, monitorPoint, null);
        }

        public static Transaction createTransaction(String module, String monitorPoint, DimensionValueSet dimensionValues) {
            return new Transaction(f.d.a(), module, monitorPoint, dimensionValues);
        }

        public static void commit(String module, String monitorPoint, double value, Map<String, String> exta) {
            Stat.commit(module, monitorPoint, null, value, exta);
        }

        public static void commit(String module, String monitorPoint, DimensionValueSet dimensionValues, double value, Map<String, String> exta) {
            try {
                if (TextUtils.isEmpty((CharSequence)module) || TextUtils.isEmpty((CharSequence)monitorPoint)) {
                    com.alibaba.mtl.log.d.i.a(AppMonitorDelegate.TAG, (Object)"module & monitorPoint must not null");
                    return;
                }
                com.alibaba.mtl.log.b.a.u();
                if (i && com.alibaba.mtl.log.a.a.f() && f.d.isOpen() && (IS_DEBUG || j.a(f.d, module, monitorPoint))) {
                    List<Measure> list;
                    com.alibaba.mtl.log.d.i.a(AppMonitorDelegate.TAG, new Object[]{"statEvent commit. module: ", module, " monitorPoint: ", monitorPoint});
                    Metric metric = MetricRepo.getRepo().getMetric(module, monitorPoint);
                    com.alibaba.mtl.log.b.a.v();
                    if (metric != null && (list = metric.getMeasureSet().getMeasures()).size() == 1) {
                        String string = list.get(0).getName();
                        MeasureValueSet measureValueSet = com.alibaba.mtl.appmonitor.c.a.a().a(MeasureValueSet.class, new Object[0]).setValue(string, value);
                        Stat.commit(module, monitorPoint, dimensionValues, measureValueSet, exta);
                    }
                }
            }
            catch (Throwable throwable) {
                com.alibaba.mtl.appmonitor.b.b.a(throwable);
            }
        }

        public static void commit(String module, String monitorPoint, DimensionValueSet dimensionValues, MeasureValueSet measureValues, Map<String, String> exta) {
            try {
                if (TextUtils.isEmpty((CharSequence)module) || TextUtils.isEmpty((CharSequence)monitorPoint)) {
                    com.alibaba.mtl.log.d.i.a(AppMonitorDelegate.TAG, (Object)"module & monitorPoint must not null");
                    return;
                }
                com.alibaba.mtl.log.b.a.u();
                if (i && com.alibaba.mtl.log.a.a.f() && f.d.isOpen() && (IS_DEBUG || j.a(f.d, module, monitorPoint, dimensionValues != null ? dimensionValues.getMap() : null))) {
                    com.alibaba.mtl.log.d.i.a("statEvent commit success", new Object[]{"statEvent commit. module: ", module, " monitorPoint: ", monitorPoint});
                    com.alibaba.mtl.log.b.a.v();
                    e.a().a(f.d.a(), module, monitorPoint, measureValues, dimensionValues, exta);
                } else {
                    com.alibaba.mtl.log.d.i.a("statEvent commit failed,log discard", new Object[]{" ,. module: ", module, " monitorPoint: ", monitorPoint});
                }
            }
            catch (Throwable throwable) {
                com.alibaba.mtl.appmonitor.b.b.a(throwable);
            }
        }
    }

    public static class OffLineCounter {
        public static void setStatisticsInterval(int statisticsInterval) {
            f.c.setStatisticsInterval(statisticsInterval);
            AppMonitorDelegate.setStatisticsInterval(f.c, statisticsInterval);
        }

        public static void setSampling(int sampling) {
            j.a().a(f.c, sampling);
        }

        @Deprecated
        public static boolean checkSampled(String module, String monitorPoint) {
            return j.a(f.c, module, monitorPoint);
        }

        public static void commit(String module, String monitorPoint, double value) {
            try {
                if (TextUtils.isEmpty((CharSequence)module) || TextUtils.isEmpty((CharSequence)monitorPoint)) {
                    com.alibaba.mtl.log.d.i.a(AppMonitorDelegate.TAG, (Object)"module & monitorPoint must not null");
                    return;
                }
                com.alibaba.mtl.log.b.a.w();
                if (i && com.alibaba.mtl.log.a.a.f() && f.c.isOpen() && (IS_DEBUG || j.a(f.c, module, monitorPoint))) {
                    com.alibaba.mtl.log.d.i.a(AppMonitorDelegate.TAG, "commitOffLineCount module: ", module, " monitorPoint: ", monitorPoint, " value: ", value);
                    com.alibaba.mtl.log.b.a.x();
                    e.a().a(f.c.a(), module, monitorPoint, null, value, null);
                }
            }
            catch (Throwable throwable) {
                com.alibaba.mtl.appmonitor.b.b.a(throwable);
            }
        }
    }

    public static class Counter {
        public static void setStatisticsInterval(int statisticsInterval) {
            f.b.setStatisticsInterval(statisticsInterval);
            AppMonitorDelegate.setStatisticsInterval(f.b, statisticsInterval);
        }

        public static void setSampling(int sampling) {
            j.a().a(f.b, sampling);
        }

        @Deprecated
        public static boolean checkSampled(String module, String monitorPoint) {
            return j.a(f.b, module, monitorPoint);
        }

        public static void commit(String module, String monitorPoint, double value, Map<String, String> exta) {
            Counter.commit(module, monitorPoint, null, value, exta);
        }

        public static void commit(String module, String monitorPoint, String arg, double value, Map<String, String> exta) {
            try {
                if (TextUtils.isEmpty((CharSequence)module) || TextUtils.isEmpty((CharSequence)monitorPoint)) {
                    com.alibaba.mtl.log.d.i.a(AppMonitorDelegate.TAG, (Object)"module & monitorPoint must not null");
                    return;
                }
                com.alibaba.mtl.log.b.a.y();
                if (i && com.alibaba.mtl.log.a.a.f() && f.b.isOpen() && (IS_DEBUG || j.a(f.b, module, monitorPoint))) {
                    com.alibaba.mtl.log.d.i.a(AppMonitorDelegate.TAG, "commitCount module: ", module, " monitorPoint: ", monitorPoint, " value: ", value);
                    com.alibaba.mtl.log.b.a.z();
                    e.a().a(f.b.a(), module, monitorPoint, arg, value, exta);
                }
            }
            catch (Throwable throwable) {
                com.alibaba.mtl.appmonitor.b.b.a(throwable);
            }
        }
    }

    public static class Alarm {
        public static void setStatisticsInterval(int statisticsInterval) {
            f.a.setStatisticsInterval(statisticsInterval);
            AppMonitorDelegate.setStatisticsInterval(f.a, statisticsInterval);
        }

        public static void setSampling(int sampling) {
            j.a().a(f.a, sampling);
        }

        @Deprecated
        public static boolean checkSampled(String module, String monitorPoint) {
            return j.a(f.a, module, monitorPoint);
        }

        public static void commitSuccess(String module, String monitorPoint, Map<String, String> exta) {
            Alarm.commitSuccess(module, monitorPoint, null, exta);
        }

        public static void commitSuccess(String module, String monitorPoint, String arg, Map<String, String> exta) {
            try {
                if (TextUtils.isEmpty((CharSequence)module) || TextUtils.isEmpty((CharSequence)monitorPoint)) {
                    com.alibaba.mtl.log.d.i.a(AppMonitorDelegate.TAG, (Object)"module & monitorPoint must not null");
                    return;
                }
                com.alibaba.mtl.log.b.a.A();
                if (i && com.alibaba.mtl.log.a.a.f() && f.a.isOpen() && (IS_DEBUG || j.a(module, monitorPoint, true, null))) {
                    com.alibaba.mtl.log.d.i.a(AppMonitorDelegate.TAG, new Object[]{"commitSuccess module:", module, " monitorPoint:", monitorPoint});
                    com.alibaba.mtl.log.b.a.B();
                    e.a().a(f.a.a(), module, monitorPoint, arg, exta);
                } else {
                    com.alibaba.mtl.log.d.i.a("log discard !", (Object)"");
                }
            }
            catch (Throwable throwable) {
                com.alibaba.mtl.appmonitor.b.b.a(throwable);
            }
        }

        public static void commitFail(String module, String monitorPoint, String errorCode, String errorMsg, Map<String, String> exta) {
            Alarm.commitFail(module, monitorPoint, null, errorCode, errorMsg, exta);
        }

        public static void commitFail(String module, String monitorPoint, String arg, String errorCode, String errorMsg, Map<String, String> exta) {
            try {
                if (TextUtils.isEmpty((CharSequence)module) || TextUtils.isEmpty((CharSequence)monitorPoint)) {
                    com.alibaba.mtl.log.d.i.a(AppMonitorDelegate.TAG, (Object)"module & monitorPoint must not null");
                    return;
                }
                com.alibaba.mtl.log.b.a.A();
                HashMap<String, String> hashMap = new HashMap<String, String>();
                hashMap.put("_status", "0");
                if (i && com.alibaba.mtl.log.a.a.f() && f.a.isOpen() && (IS_DEBUG || j.a(module, monitorPoint, false, hashMap))) {
                    com.alibaba.mtl.log.d.i.a(AppMonitorDelegate.TAG, new Object[]{"commitFail module:", module, " monitorPoint:", monitorPoint, " errorCode:", errorCode, "errorMsg:", errorMsg});
                    com.alibaba.mtl.log.b.a.B();
                    e.a().a(f.a.a(), module, monitorPoint, arg, errorCode, errorMsg, exta);
                } else {
                    com.alibaba.mtl.log.d.i.a("log discard !", (Object)"");
                }
            }
            catch (Throwable throwable) {
                com.alibaba.mtl.appmonitor.b.b.a(throwable);
            }
        }
    }
}

