/*
 * Decompiled with CFR 0.152.
 */
package com.bigkoo.pickerview.utils;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;

public class ChinaDate {
    private static final long[] lunarInfo = new long[]{19416L, 19168L, 42352L, 21717L, 53856L, 55632L, 91476L, 22176L, 39632L, 21970L, 19168L, 42422L, 42192L, 53840L, 119381L, 46400L, 54944L, 44450L, 38320L, 84343L, 18800L, 42160L, 46261L, 27216L, 27968L, 109396L, 11104L, 38256L, 21234L, 18800L, 25958L, 54432L, 59984L, 28309L, 23248L, 11104L, 100067L, 37600L, 116951L, 51536L, 54432L, 120998L, 46416L, 22176L, 107956L, 9680L, 37584L, 53938L, 43344L, 46423L, 27808L, 46416L, 86869L, 19872L, 42416L, 83315L, 21168L, 43432L, 59728L, 27296L, 44710L, 43856L, 19296L, 43748L, 42352L, 21088L, 62051L, 55632L, 23383L, 22176L, 38608L, 19925L, 19152L, 42192L, 54484L, 53840L, 54616L, 46400L, 46752L, 103846L, 38320L, 18864L, 43380L, 42160L, 45690L, 27216L, 27968L, 44870L, 43872L, 38256L, 19189L, 18800L, 25776L, 29859L, 59984L, 27480L, 21952L, 43872L, 38613L, 37600L, 51552L, 55636L, 54432L, 55888L, 30034L, 22176L, 43959L, 9680L, 37584L, 51893L, 43344L, 46240L, 47780L, 44368L, 21977L, 19360L, 42416L, 86390L, 21168L, 43312L, 31060L, 27296L, 44368L, 23378L, 19296L, 42726L, 42208L, 53856L, 60005L, 54576L, 23200L, 30371L, 38608L, 19195L, 19152L, 42192L, 118966L, 53840L, 54560L, 56645L, 46496L, 22224L, 21938L, 18864L, 42359L, 42160L, 43600L, 111189L, 27936L, 44448L, 84835L, 37744L, 18936L, 18800L, 25776L, 92326L, 59984L, 27424L, 108228L, 43744L, 41696L, 53987L, 51552L, 54615L, 54432L, 55888L, 23893L, 22176L, 42704L, 21972L, 21200L, 43448L, 43344L, 46240L, 46758L, 44368L, 21920L, 43940L, 42416L, 21168L, 45683L, 26928L, 29495L, 27296L, 44368L, 84821L, 19296L, 42352L, 21732L, 53600L, 59752L, 54560L, 55968L, 92838L, 22224L, 19168L, 43476L, 41680L, 53584L, 62034L, 54560L};
    private static final String[] nStr1 = new String[]{"", "\u6b63", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u51ac", "\u814a"};
    private static final String[] Gan = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    private static final String[] Zhi = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static final String[] Animals = new String[]{"\u9f20", "\u725b", "\u864e", "\u5154", "\u9f99", "\u86c7", "\u9a6c", "\u7f8a", "\u7334", "\u9e21", "\u72d7", "\u732a"};
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyy\u5e74M\u6708d\u65e5 EEEEE");

    private static final int lYearDays(int y) {
        int sum = 348;
        for (int i = 32768; i > 8; i >>= 1) {
            if ((lunarInfo[y - 1900] & (long)i) == 0L) continue;
            ++sum;
        }
        return sum + ChinaDate.leapDays(y);
    }

    public static final int leapDays(int y) {
        if (ChinaDate.leapMonth(y) != 0) {
            if ((lunarInfo[y - 1900] & 0x10000L) != 0L) {
                return 30;
            }
            return 29;
        }
        return 0;
    }

    public static final int leapMonth(int y) {
        return (int)(lunarInfo[y - 1900] & 0xFL);
    }

    public static final int monthDays(int y, int m) {
        if ((lunarInfo[y - 1900] & (long)(65536 >> m)) == 0L) {
            return 29;
        }
        return 30;
    }

    public static final String AnimalsYear(int y) {
        return Animals[(y - 4) % 12];
    }

    private static final String cyclicalm(int num) {
        return Gan[num % 10] + Zhi[num % 12];
    }

    public static final String cyclical(int y) {
        int num = y - 1900 + 36;
        return ChinaDate.cyclicalm(num);
    }

    public static final long[] calElement(int y, int m, int d) {
        long[] nongDate = new long[7];
        int i = 0;
        int temp = 0;
        int leap = 0;
        Date baseDate = new GregorianCalendar(1900, 0, 31).getTime();
        Date objDate = new GregorianCalendar(y, m - 1, d).getTime();
        long offset = (objDate.getTime() - baseDate.getTime()) / 86400000L;
        nongDate[5] = offset + 40L;
        nongDate[4] = 14L;
        for (i = 1900; i < 2100 && offset > 0L; offset -= (long)temp, ++i) {
            temp = ChinaDate.lYearDays(i);
            nongDate[4] = nongDate[4] + 12L;
        }
        if (offset < 0L) {
            offset += (long)temp;
            --i;
            nongDate[4] = nongDate[4] - 12L;
        }
        nongDate[0] = i;
        nongDate[3] = i - 1864;
        leap = ChinaDate.leapMonth(i);
        nongDate[6] = 0L;
        for (i = 1; i < 13 && offset > 0L; ++i) {
            if (leap > 0 && i == leap + 1 && nongDate[6] == 0L) {
                --i;
                nongDate[6] = 1L;
                temp = ChinaDate.leapDays((int)nongDate[0]);
            } else {
                temp = ChinaDate.monthDays((int)nongDate[0], i);
            }
            if (nongDate[6] == 1L && i == leap + 1) {
                nongDate[6] = 0L;
            }
            offset -= (long)temp;
            if (nongDate[6] != 0L) continue;
            nongDate[4] = nongDate[4] + 1L;
        }
        if (offset == 0L && leap > 0 && i == leap + 1) {
            if (nongDate[6] == 1L) {
                nongDate[6] = 0L;
            } else {
                nongDate[6] = 1L;
                --i;
                nongDate[4] = nongDate[4] - 1L;
            }
        }
        if (offset < 0L) {
            offset += (long)temp;
            --i;
            nongDate[4] = nongDate[4] - 1L;
        }
        nongDate[1] = i;
        nongDate[2] = offset + 1L;
        return nongDate;
    }

    public static final String getChinaDate(int day) {
        String a = "";
        if (day == 10) {
            return "\u521d\u5341";
        }
        if (day == 20) {
            return "\u4e8c\u5341";
        }
        if (day == 30) {
            return "\u4e09\u5341";
        }
        int two = day / 10;
        if (two == 0) {
            a = "\u521d";
        }
        if (two == 1) {
            a = "\u5341";
        }
        if (two == 2) {
            a = "\u5eff";
        }
        if (two == 3) {
            a = "\u4e09";
        }
        int one = day % 10;
        switch (one) {
            case 1: {
                a = a + "\u4e00";
                break;
            }
            case 2: {
                a = a + "\u4e8c";
                break;
            }
            case 3: {
                a = a + "\u4e09";
                break;
            }
            case 4: {
                a = a + "\u56db";
                break;
            }
            case 5: {
                a = a + "\u4e94";
                break;
            }
            case 6: {
                a = a + "\u516d";
                break;
            }
            case 7: {
                a = a + "\u4e03";
                break;
            }
            case 8: {
                a = a + "\u516b";
                break;
            }
            case 9: {
                a = a + "\u4e5d";
            }
        }
        return a;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getCurrentLunarDate() {
        Calendar today = Calendar.getInstance(Locale.SIMPLIFIED_CHINESE);
        int year = today.get(1);
        int month = today.get(2) + 1;
        int date = today.get(5);
        long[] l = ChinaDate.calElement(year, month, date);
        StringBuffer sToday = new StringBuffer();
        try {
            sToday.append(sdf.format(today.getTime()));
            sToday.append(" \u519c\u5386");
            sToday.append(ChinaDate.cyclical(year));
            sToday.append('(');
            sToday.append(ChinaDate.AnimalsYear(year));
            sToday.append(")\u5e74");
            sToday.append(nStr1[(int)l[1]]);
            sToday.append("\u6708");
            sToday.append(ChinaDate.getChinaDate((int)l[2]));
            String string2 = sToday.toString();
            return string2;
        }
        finally {
            sToday = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String oneDay(int year, int month, int day) {
        long[] l = ChinaDate.calElement(year, month, day);
        StringBuffer sToday = new StringBuffer();
        try {
            sToday.append(" \u519c\u5386");
            sToday.append(ChinaDate.cyclical(year));
            sToday.append('(');
            sToday.append(ChinaDate.AnimalsYear(year));
            sToday.append(")\u5e74");
            sToday.append(nStr1[(int)l[1]]);
            sToday.append("\u6708");
            sToday.append(ChinaDate.getChinaDate((int)l[2]));
            String string2 = sToday.toString();
            return string2;
        }
        finally {
            sToday = null;
        }
    }

    public static String getLunarYearText(int lunarYear) {
        return Gan[(lunarYear - 4) % 10] + Zhi[(lunarYear - 4) % 12] + "\u5e74";
    }

    public static ArrayList<String> getYears(int startYear, int endYear) {
        ArrayList<String> years = new ArrayList<String>();
        for (int i = startYear; i < endYear; ++i) {
            years.add(String.format("%s(%d)", ChinaDate.getLunarYearText(i), i));
        }
        return years;
    }

    public static ArrayList<String> getMonths(int year) {
        ArrayList<String> baseMonths = new ArrayList<String>();
        for (int i = 1; i < nStr1.length; ++i) {
            baseMonths.add(nStr1[i] + "\u6708");
        }
        if (ChinaDate.leapMonth(year) != 0) {
            baseMonths.add(ChinaDate.leapMonth(year), "\u95f0" + nStr1[ChinaDate.leapMonth(year)] + "\u6708");
        }
        return baseMonths;
    }

    public static ArrayList<String> getLunarDays(int maxDay) {
        ArrayList<String> days = new ArrayList<String>();
        for (int i = 1; i <= maxDay; ++i) {
            days.add(ChinaDate.getChinaDate(i));
        }
        return days;
    }
}

