/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.tablayout;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;

public class DividerDrawable
extends Drawable {
    private Paint paint;
    private RectF rectF;
    private int color = -16777216;
    private int height = 0;
    private int width;
    public static final int TOP = 0;
    public static final int CENTER = 1;
    public static final int BOTTOM = 2;
    private int gravity = 1;

    public DividerDrawable(Context context) {
        this.width = this.dip2px(context, 2.0f);
        this.paint = new Paint();
        this.paint.setColor(this.color);
        this.paint.setAntiAlias(true);
    }

    public void setColor(int color2) {
        this.paint.setColor(color2);
    }

    public void setGravity(int gravity) {
        if (gravity != 0 && gravity != 1 && gravity != 2) {
            throw new IllegalArgumentException("Gravity must be one of 0(DividerDrawable.TOP)\u30011(DividerDrawable.CENTER) and 2(DividerDrawable.BOTTOM)");
        }
        this.gravity = gravity;
    }

    public void draw(Canvas canvas) {
        canvas.drawColor(0);
        if (this.height == 0 || (float)this.height >= this.rectF.bottom) {
            canvas.drawRect(this.rectF, this.paint);
        } else {
            int margin = (int)((this.rectF.bottom - (float)this.height) / 2.0f);
            switch (this.gravity) {
                case 0: {
                    canvas.drawRect(this.rectF.left, this.rectF.top, this.rectF.right, this.rectF.bottom - (float)(margin * 2), this.paint);
                    break;
                }
                case 1: {
                    canvas.drawRect(this.rectF.left, this.rectF.top + (float)margin, this.rectF.right, this.rectF.bottom - (float)margin, this.paint);
                    break;
                }
                case 2: {
                    canvas.drawRect(this.rectF.left, this.rectF.top + (float)(margin * 2), this.rectF.right, this.rectF.bottom, this.paint);
                }
            }
        }
    }

    public void setBounds(int left, int top, int right, int bottom) {
        super.setBounds(left, top, right, bottom);
        this.rectF = new RectF((float)left, (float)top, (float)right, (float)bottom);
    }

    public void setDividerSize(int width, int height) {
        this.width = width;
        this.height = height;
        this.invalidateSelf();
    }

    public int getIntrinsicHeight() {
        return super.getIntrinsicHeight();
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public void setAlpha(int alpha) {
        this.paint.setAlpha(alpha);
    }

    public void setColorFilter(ColorFilter colorFilter) {
        this.paint.setColorFilter(colorFilter);
    }

    public int getOpacity() {
        return -3;
    }

    public int dip2px(Context context, float dpValue) {
        float scale = context.getResources().getDisplayMetrics().density;
        return (int)(dpValue * scale + 0.5f);
    }
}

