/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.navigation;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.fshows.android.parker.R;
import com.fshows.android.stark.utils.CommonUtil;
import java.util.Locale;

public class BottomBarItem
extends ConstraintLayout {
    private Context context;
    private Drawable normalIcon;
    private Drawable selectedIcon;
    private String title;
    private int titleTextSize = 12;
    private int titleNormalColor;
    private int titleSelectedColor;
    private int marginTop = 0;
    private int iconWidth;
    private int iconHeight;
    private int unreadTextSize = 10;
    private int unreadNumThreshold = 99;
    private int unreadTextColor;
    private Drawable unreadTextBg;
    private ImageView mImageView;
    private TextView mTvUnread;
    private TextView mTextView;

    public BottomBarItem(Context context) {
        super(context);
    }

    public BottomBarItem(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BottomBarItem(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        TypedArray ta = context.obtainStyledAttributes(attrs, R.styleable.BottomBarItem);
        this.initAttrs(ta);
        ta.recycle();
        this.checkValues();
        this.initView();
    }

    private void initAttrs(TypedArray ta) {
        this.normalIcon = ta.getDrawable(R.styleable.BottomBarItem_iconNormal);
        this.selectedIcon = ta.getDrawable(R.styleable.BottomBarItem_iconSelected);
        this.title = ta.getString(R.styleable.BottomBarItem_itemText);
        this.titleTextSize = ta.getDimensionPixelSize(R.styleable.BottomBarItem_itemTextSize, CommonUtil.sp2px((float)this.titleTextSize));
        this.titleNormalColor = ta.getColor(R.styleable.BottomBarItem_textColorNormal, ContextCompat.getColor((Context)this.context, (int)R.color.color_bottom_bar_normal));
        this.titleSelectedColor = ta.getColor(R.styleable.BottomBarItem_textColorSelected, ContextCompat.getColor((Context)this.context, (int)R.color.color_bottom_bar_selected));
        this.marginTop = ta.getDimensionPixelSize(R.styleable.BottomBarItem_itemMarginTop, CommonUtil.dp2px((Context)this.context, (float)this.marginTop));
        this.iconWidth = ta.getDimensionPixelSize(R.styleable.BottomBarItem_iconWidth, 0);
        this.iconHeight = ta.getDimensionPixelSize(R.styleable.BottomBarItem_iconHeight, 0);
        this.unreadTextSize = ta.getDimensionPixelSize(R.styleable.BottomBarItem_unreadTextSize, CommonUtil.sp2px((float)this.unreadTextSize));
        this.unreadTextColor = ta.getColor(R.styleable.BottomBarItem_unreadTextColor, ContextCompat.getColor((Context)this.context, (int)R.color.common_white));
        this.unreadTextBg = ta.getDrawable(R.styleable.BottomBarItem_unreadTextBg);
        this.unreadNumThreshold = ta.getInteger(R.styleable.BottomBarItem_unreadThreshold, this.unreadNumThreshold);
    }

    private void checkValues() {
        if (this.normalIcon == null) {
            throw new IllegalStateException("You have not set the normal icon");
        }
        if (this.selectedIcon == null) {
            throw new IllegalStateException("You have not set the selected icon");
        }
        if (this.unreadTextBg == null) {
            this.unreadTextBg = ContextCompat.getDrawable((Context)this.context, (int)R.drawable.shape_unread);
        }
    }

    private void initView() {
        LayoutInflater.from((Context)this.context).inflate(R.layout.item_bottom_bar, (ViewGroup)this, true);
        this.mImageView = (ImageView)this.findViewById(R.id.bottom_bar_iv);
        this.mTvUnread = (TextView)this.findViewById(R.id.bottom_bar_unread_tv);
        this.mTextView = (TextView)this.findViewById(R.id.bottom_bar_tv);
        this.mImageView.setImageDrawable(this.normalIcon);
        if (this.iconWidth != 0 && this.iconHeight != 0) {
            FrameLayout.LayoutParams imageLayoutParams = (FrameLayout.LayoutParams)this.mImageView.getLayoutParams();
            imageLayoutParams.width = this.iconWidth;
            imageLayoutParams.height = this.iconHeight;
            this.mImageView.setLayoutParams((ViewGroup.LayoutParams)imageLayoutParams);
        }
        this.mTextView.setTextSize(0, (float)this.titleTextSize);
        this.mTvUnread.setTextSize(0, (float)this.unreadTextSize);
        this.mTvUnread.setTextColor(this.unreadTextColor);
        this.mTvUnread.setBackground(this.unreadTextBg);
        this.mTextView.setTextColor(this.titleNormalColor);
        this.mTextView.setText((CharSequence)this.title);
        ConstraintLayout.LayoutParams textLayoutParams = (ConstraintLayout.LayoutParams)this.mTextView.getLayoutParams();
        textLayoutParams.topMargin = this.marginTop;
        this.mTextView.setLayoutParams((ViewGroup.LayoutParams)textLayoutParams);
    }

    public ImageView getImageView() {
        return this.mImageView;
    }

    public TextView getTextView() {
        return this.mTextView;
    }

    public void setNormalIcon(Drawable normalIcon) {
        this.normalIcon = normalIcon;
        this.refreshTab();
    }

    public void setNormalIcon(int resId) {
        this.setNormalIcon(ContextCompat.getDrawable((Context)this.context, (int)resId));
    }

    public void setSelectedIcon(Drawable selectedIcon) {
        this.selectedIcon = selectedIcon;
        this.refreshTab();
    }

    public void setSelectedIcon(int resId) {
        this.setSelectedIcon(ContextCompat.getDrawable((Context)this.context, (int)resId));
    }

    public void refreshTab(boolean isSelected) {
        this.setSelected(isSelected);
        this.refreshTab();
    }

    public void refreshTab() {
        this.mImageView.setImageDrawable(this.isSelected() ? this.selectedIcon : this.normalIcon);
        this.mTextView.setTextColor(this.isSelected() ? this.titleSelectedColor : this.titleNormalColor);
    }

    public void setUnreadNumThreshold(int unreadNumThreshold) {
        this.unreadNumThreshold = unreadNumThreshold;
    }

    public void setUnreadNum(int unreadNum) {
        if (unreadNum <= 0) {
            this.mTvUnread.setVisibility(8);
        } else if (unreadNum <= this.unreadNumThreshold) {
            this.setUnreadTv(String.valueOf(unreadNum));
        } else {
            this.setUnreadTv(String.format(Locale.CHINA, "%d+", this.unreadNumThreshold));
        }
    }

    private void setUnreadTv(String unreadNum) {
        this.mTvUnread.setVisibility(0);
        this.mTvUnread.setText((CharSequence)unreadNum);
    }

    public void setRedDotVis(boolean showFlag) {
        if (showFlag) {
            ViewGroup.LayoutParams layoutParams = this.mTvUnread.getLayoutParams();
            layoutParams.height = CommonUtil.dp2px((float)10.0f);
            layoutParams.width = CommonUtil.dp2px((float)10.0f);
            this.mTvUnread.setLayoutParams(layoutParams);
            this.mTvUnread.setTextSize(1.0f);
            this.mTvUnread.setVisibility(0);
        } else {
            this.mTvUnread.setVisibility(8);
        }
    }

    public BottomBarItem create(Builder builder) {
        this.context = builder.context;
        this.normalIcon = builder.normalIcon;
        this.selectedIcon = builder.selectedIcon;
        this.title = builder.title;
        this.titleTextSize = builder.titleTextSize;
        this.titleNormalColor = builder.titleNormalColor;
        this.titleSelectedColor = builder.titleSelectedColor;
        this.marginTop = builder.marginTop;
        this.iconWidth = builder.iconWidth;
        this.iconHeight = builder.iconHeight;
        this.unreadTextSize = builder.unreadTextSize;
        this.unreadTextColor = builder.unreadTextColor;
        this.unreadTextBg = builder.unreadTextBg;
        this.unreadNumThreshold = builder.unreadNumThreshold;
        this.checkValues();
        this.initView();
        return this;
    }

    public static final class Builder {
        private Context context;
        private Drawable normalIcon;
        private Drawable selectedIcon;
        private String title;
        private int titleTextSize;
        private int titleNormalColor;
        private int titleSelectedColor;
        private int marginTop;
        private int iconWidth;
        private int iconHeight;
        private boolean unreadTextVisible;
        private int unreadTextSize;
        private int unreadNumThreshold;
        private int unreadTextColor;
        private Drawable unreadTextBg;

        public Builder(Context context) {
            this.context = context;
            this.titleTextSize = CommonUtil.sp2px((float)12.0f);
            this.titleNormalColor = this.getColor(R.color.color_bottom_bar_normal);
            this.titleSelectedColor = this.getColor(R.color.color_bottom_bar_selected);
            this.unreadTextSize = CommonUtil.sp2px((float)10.0f);
            this.unreadTextColor = this.getColor(R.color.common_white);
            this.unreadNumThreshold = 99;
            this.unreadTextVisible = false;
        }

        public Builder normalIcon(Drawable normalIcon) {
            this.normalIcon = normalIcon;
            return this;
        }

        public Builder selectedIcon(Drawable selectedIcon) {
            this.selectedIcon = selectedIcon;
            return this;
        }

        public Builder title(int titleId) {
            this.title = this.context.getString(titleId);
            return this;
        }

        public Builder title(String title) {
            this.title = title;
            return this;
        }

        public Builder titleTextSize(int titleTextSize) {
            this.titleTextSize = CommonUtil.sp2px((float)titleTextSize);
            return this;
        }

        public Builder titleNormalColor(int titleNormalColor) {
            this.titleNormalColor = this.getColor(titleNormalColor);
            return this;
        }

        public Builder titleSelectedColor(int titleSelectedColor) {
            this.titleSelectedColor = this.getColor(titleSelectedColor);
            return this;
        }

        public Builder marginTop(int marginTop) {
            this.marginTop = marginTop;
            return this;
        }

        public Builder iconWidth(int iconWidth) {
            this.iconWidth = iconWidth;
            return this;
        }

        public Builder iconHeight(int iconHeight) {
            this.iconHeight = iconHeight;
            return this;
        }

        public Builder unreadTextVisible(boolean unreadTextVisible) {
            this.unreadTextVisible = unreadTextVisible;
            return this;
        }

        public Builder unreadTextSize(int unreadTextSize) {
            this.unreadTextSize = CommonUtil.sp2px((float)unreadTextSize);
            return this;
        }

        public Builder unreadNumThreshold(int unreadNumThreshold) {
            this.unreadNumThreshold = unreadNumThreshold;
            return this;
        }

        public Builder unreadTextBg(Drawable unreadTextBg) {
            this.unreadTextBg = unreadTextBg;
            return this;
        }

        public Builder unreadTextColor(int unreadTextColor) {
            this.unreadTextColor = this.getColor(unreadTextColor);
            return this;
        }

        public BottomBarItem create(Drawable normalIcon, Drawable selectedIcon, String text) {
            this.normalIcon = normalIcon;
            this.selectedIcon = selectedIcon;
            this.title = text;
            BottomBarItem bottomBarItem = new BottomBarItem(this.context);
            return bottomBarItem.create(this);
        }

        public BottomBarItem create(int normalIconId, int selectedIconId, String text) {
            return this.create(ContextCompat.getDrawable((Context)this.context, (int)normalIconId), ContextCompat.getDrawable((Context)this.context, (int)selectedIconId), text);
        }

        private int getColor(int colorId) {
            return ContextCompat.getColor((Context)this.context, (int)colorId);
        }
    }
}

