/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.transformers;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewTreeObserver;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.recyclerview.widget.RecyclerView;
import com.fshows.android.parker.transformers.OnTransformersScrollListener;

public class RecyclerViewScrollBar
extends View {
    private static final String TAG = RecyclerViewScrollBar.class.getSimpleName();
    private static final int SCROLL_LOCATION_START = 1;
    private static final int SCROLL_LOCATION_MIDDLE = 2;
    private static final int SCROLL_LOCATION_END = 3;
    private RecyclerView mRecyclerView;
    private OnTransformersScrollListener onTransformersScrollListener;
    private int mWidth;
    private int mHeight;
    private Paint mPaint = new Paint();
    private RectF mTrackRectF = new RectF();
    private RectF mThumbRectF = new RectF();
    private float radius;
    private int mTrackColor;
    private int mThumbColor;
    private float mThumbScale = 0.0f;
    private float mScrollScale = 0.0f;
    private int mScrollLocation = 1;
    private boolean scrollBySelf;
    private final RecyclerView.OnScrollListener mScrollListener = new RecyclerView.OnScrollListener(){

        public void onScrollStateChanged(@NonNull RecyclerView recyclerView, int newState) {
            if (RecyclerViewScrollBar.this.onTransformersScrollListener != null) {
                RecyclerViewScrollBar.this.onTransformersScrollListener.onScrollStateChanged(recyclerView, newState);
            }
        }

        public void onScrolled(@NonNull RecyclerView recyclerView, int dx, int dy) {
            RecyclerViewScrollBar.this.computeScrollScale();
            if (RecyclerViewScrollBar.this.scrollBySelf && RecyclerViewScrollBar.this.mRecyclerView.getScrollState() == 0) {
                this.onScrollStateChanged(recyclerView, 0);
                RecyclerViewScrollBar.this.scrollBySelf = false;
            }
            if (RecyclerViewScrollBar.this.onTransformersScrollListener != null) {
                RecyclerViewScrollBar.this.onTransformersScrollListener.onScrolled(recyclerView, dx, dy);
            }
        }
    };

    public void setScrollBySelf(boolean bySelf) {
        this.scrollBySelf = bySelf;
    }

    public void setOnTransformersScrollListener(OnTransformersScrollListener listener) {
        this.onTransformersScrollListener = listener;
    }

    public RecyclerViewScrollBar(Context context) {
        this(context, null);
    }

    public RecyclerViewScrollBar(Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public RecyclerViewScrollBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    @RequiresApi(api=21)
    public RecyclerViewScrollBar(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init();
    }

    private void init() {
        this.initPaint();
    }

    private void initPaint() {
        this.mPaint.setAntiAlias(true);
        this.mPaint.setDither(true);
        this.mPaint.setStyle(Paint.Style.FILL);
    }

    public void attachRecyclerView(RecyclerView recyclerView) {
        if (this.mRecyclerView == recyclerView) {
            return;
        }
        this.mRecyclerView = recyclerView;
        if (this.mRecyclerView != null) {
            this.mRecyclerView.removeOnScrollListener(this.mScrollListener);
            this.mRecyclerView.addOnScrollListener(this.mScrollListener);
            this.mRecyclerView.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                public boolean onPreDraw() {
                    RecyclerViewScrollBar.this.mRecyclerView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                    RecyclerViewScrollBar.this.computeScrollScale();
                    return true;
                }
            });
        }
    }

    public RecyclerViewScrollBar setRadius(float radius) {
        this.radius = radius;
        return this;
    }

    public RecyclerViewScrollBar setTrackColor(@ColorInt int color2) {
        this.mTrackColor = color2;
        return this;
    }

    public RecyclerViewScrollBar setThumbColor(@ColorInt int color2) {
        this.mThumbColor = color2;
        return this;
    }

    public void applyChange() {
        this.postInvalidate();
    }

    public void computeScrollScale() {
        if (this.mRecyclerView == null) {
            return;
        }
        float mScrollExtent = this.mRecyclerView.computeHorizontalScrollExtent();
        float mScrollRange = this.mRecyclerView.computeHorizontalScrollRange();
        if (mScrollRange != 0.0f) {
            this.mThumbScale = mScrollExtent / mScrollRange;
        }
        float mScrollOffset = this.mRecyclerView.computeHorizontalScrollOffset();
        if (mScrollRange != 0.0f) {
            this.mScrollScale = mScrollOffset / mScrollRange;
        }
        float canScrollDistance = mScrollRange - mScrollExtent;
        this.mScrollLocation = mScrollOffset == 0.0f ? 1 : (canScrollDistance == mScrollOffset ? 3 : 2);
        this.postInvalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        this.mHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawTrack(canvas);
        this.drawThumb(canvas);
    }

    private void drawThumb(Canvas canvas) {
        this.initPaint();
        this.mPaint.setColor(this.mThumbColor);
        float left = this.mScrollScale * (float)this.mWidth;
        float right = left + (float)this.mWidth * this.mThumbScale;
        switch (this.mScrollLocation) {
            case 1: {
                this.mThumbRectF.set(0.0f, 0.0f, right, (float)this.mHeight);
                break;
            }
            case 2: {
                this.mThumbRectF.set(left, 0.0f, right, (float)this.mHeight);
                break;
            }
            case 3: {
                this.mThumbRectF.set(left, 0.0f, (float)this.mWidth, (float)this.mHeight);
                break;
            }
        }
        canvas.drawRoundRect(this.mThumbRectF, this.radius, this.radius, this.mPaint);
    }

    private void drawTrack(Canvas canvas) {
        this.initPaint();
        this.mPaint.setColor(this.mTrackColor);
        this.mTrackRectF.set(0.0f, 0.0f, (float)this.mWidth, (float)this.mHeight);
        canvas.drawRoundRect(this.mTrackRectF, this.radius, this.radius, this.mPaint);
    }
}

