/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.loopview;

import android.annotation.SuppressLint;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TimeUtil {
    public static long getTimeLong() {
        return System.currentTimeMillis();
    }

    public static int getTimeInt(String filter) {
        SimpleDateFormat format = new SimpleDateFormat(filter);
        String time = format.format(new Date());
        return Integer.parseInt(time);
    }

    public static int getTimeInt(String stringTime, String filter) {
        SimpleDateFormat format = new SimpleDateFormat(filter);
        String time = format.format(new Date(TimeUtil.getTimeLong("yyyy-MM-dd HH:mm:ss", stringTime)));
        return Integer.parseInt(time);
    }

    public static final String getTimeString() {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date(TimeUtil.getTimeLong()));
    }

    public static final String getTimeString(long time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return format.format(new Date(time));
    }

    public static final String getTimeString(long time, String filter) {
        SimpleDateFormat format = new SimpleDateFormat(filter);
        return format.format(new Date(time));
    }

    public static final String getTimeString(String filter) {
        SimpleDateFormat format = new SimpleDateFormat(filter);
        return format.format(new Date(TimeUtil.getTimeLong()));
    }

    public static Long getTimeLong(String filter, String date) {
        try {
            SimpleDateFormat format = new SimpleDateFormat(filter);
            Date dateTime = format.parse(date);
            return dateTime.getTime();
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    public static String getTimeLocalString(String filter, String data, String filterInside) {
        Long timeLong = TimeUtil.getTimeLong(filter, data);
        return TimeUtil.getTimeString(timeLong, filterInside);
    }

    @SuppressLint(value={"SimpleDateFormat"})
    public static int getDateToString() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat format = new SimpleDateFormat("yyyy");
        return Integer.parseInt(format.format(date));
    }

    public static boolean isLeapYear(int year) {
        if (year % 400 == 0) {
            return true;
        }
        return year % 100 != 0 && year % 4 == 0;
    }
}

