/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.recyclerview.adapter;

import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;

public class WrapAdapter
extends RecyclerView.Adapter<RecyclerView.ViewHolder> {
    private static final int TYPE_REFRESH_HEADER = -5;
    public static final int TYPE_HEADER = -4;
    private static final int TYPE_NORMAL = 0;
    private static final int TYPE_FOOTER = -3;
    private RecyclerView.Adapter adapter;
    private SparseArray<View> mHeaderViews;
    private SparseArray<View> mFootViews;
    private int headerPosition = 1;

    public WrapAdapter(SparseArray<View> headerViews, SparseArray<View> footViews, RecyclerView.Adapter adapter) {
        this.adapter = adapter;
        this.mHeaderViews = headerViews;
        this.mFootViews = footViews;
    }

    public void onAttachedToRecyclerView(RecyclerView recyclerView) {
        super.onAttachedToRecyclerView(recyclerView);
        RecyclerView.LayoutManager manager = recyclerView.getLayoutManager();
        if (manager instanceof GridLayoutManager) {
            final GridLayoutManager gridManager = (GridLayoutManager)manager;
            gridManager.setSpanSizeLookup(new GridLayoutManager.SpanSizeLookup(){

                public int getSpanSize(int position) {
                    return WrapAdapter.this.isHeader(position) || WrapAdapter.this.isFooter(position) ? gridManager.getSpanCount() : 1;
                }
            });
        }
    }

    public void onViewAttachedToWindow(RecyclerView.ViewHolder holder) {
        super.onViewAttachedToWindow(holder);
        ViewGroup.LayoutParams lp = holder.itemView.getLayoutParams();
        if (lp != null && lp instanceof StaggeredGridLayoutManager.LayoutParams && (this.isHeader(holder.getLayoutPosition()) || this.isFooter(holder.getLayoutPosition()))) {
            StaggeredGridLayoutManager.LayoutParams p = (StaggeredGridLayoutManager.LayoutParams)lp;
            p.setFullSpan(true);
        }
    }

    public boolean isHeader(int position) {
        return position >= 0 && position < this.mHeaderViews.size();
    }

    public RecyclerView.Adapter getAdapter() {
        return this.adapter;
    }

    public boolean isFooter(int position) {
        return this.mFootViews.size() > 0 && position < this.getItemCount() && position >= this.getItemCount() - this.mFootViews.size();
    }

    public boolean isRefreshHeader(int position) {
        return this.mHeaderViews.size() > 0 && position == 0;
    }

    public int getHeadersCount() {
        return this.mHeaderViews.size();
    }

    public int getFootersCount() {
        return this.mFootViews.size();
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        if (viewType == -5) {
            this.headerPosition = 1;
            return new SimpleViewHolder((View)this.mHeaderViews.get(0));
        }
        if (viewType == -4) {
            return new SimpleViewHolder((View)this.mHeaderViews.get(this.headerPosition++));
        }
        if (viewType == -3) {
            return new SimpleViewHolder((View)this.mFootViews.get(0));
        }
        return this.adapter.onCreateViewHolder(parent, viewType);
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        int adapterCount;
        if (this.isHeader(position)) {
            return;
        }
        int adjPosition = position - this.getHeadersCount();
        if (this.adapter != null && adjPosition < (adapterCount = this.adapter.getItemCount())) {
            this.adapter.onBindViewHolder(holder, adjPosition);
            return;
        }
    }

    public int getItemCount() {
        if (this.adapter != null) {
            return this.getHeadersCount() + this.getFootersCount() + this.adapter.getItemCount();
        }
        return this.getHeadersCount() + this.getFootersCount();
    }

    public int getItemViewType(int position) {
        int adapterCount;
        if (this.isRefreshHeader(position)) {
            return -5;
        }
        if (this.isHeader(position)) {
            return -4;
        }
        if (this.isFooter(position)) {
            return -3;
        }
        int adjPosition = position - this.getHeadersCount();
        if (this.adapter != null && adjPosition < (adapterCount = this.adapter.getItemCount())) {
            return this.adapter.getItemViewType(adjPosition);
        }
        return 0;
    }

    public long getItemId(int position) {
        int adapterCount;
        int adjPosition;
        if (this.adapter != null && position >= this.getHeadersCount() && (adjPosition = position - this.getHeadersCount()) < (adapterCount = this.adapter.getItemCount())) {
            return this.adapter.getItemId(adjPosition);
        }
        return -1L;
    }

    public void unregisterAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
        if (this.adapter != null) {
            this.adapter.unregisterAdapterDataObserver(observer);
        }
    }

    public void registerAdapterDataObserver(RecyclerView.AdapterDataObserver observer) {
        if (this.adapter != null) {
            this.adapter.registerAdapterDataObserver(observer);
        }
    }

    private class SimpleViewHolder
    extends RecyclerView.ViewHolder {
        public SimpleViewHolder(View itemView) {
            super(itemView);
        }
    }
}

