/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.recyclerview;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.SparseArray;
import android.view.MotionEvent;
import android.view.View;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.SimpleItemAnimator;
import com.fshows.android.parker.R;
import com.fshows.android.parker.recyclerview.IEmptyView;
import com.fshows.android.parker.recyclerview.ILoadMoreView;
import com.fshows.android.parker.recyclerview.IRefreshHeader;
import com.fshows.android.parker.recyclerview.LoadingMoreFooter;
import com.fshows.android.parker.recyclerview.YunRefreshHeader;
import com.fshows.android.parker.recyclerview.adapter.BaseRecyclerViewAdapter;
import com.fshows.android.parker.recyclerview.adapter.WrapAdapter;

public class FsRecyclerView
extends RecyclerView {
    private LoadingListener mLoadingListener;
    private WrapAdapter mWrapAdapter;
    private SparseArray<View> mHeaderViews = new SparseArray();
    private SparseArray<View> mFootViews = new SparseArray();
    private boolean pullRefreshEnabled = true;
    private boolean loadingMoreEnabled = true;
    private IRefreshHeader mRefreshHeader;
    private boolean isLoadingData;
    public int previousTotal;
    public boolean isNomore;
    private float mLastY = -1.0f;
    private static final float DRAG_RATE = 1.75f;
    private boolean isOther = false;
    private int dy = 0;
    private UpDownListener upDownListener;
    private int mMaxHeight;
    private final RecyclerView.AdapterDataObserver mDataObserver = new RecyclerView.AdapterDataObserver(){

        public void onChanged() {
            FsRecyclerView.this.mWrapAdapter.notifyDataSetChanged();
        }

        public void onItemRangeInserted(int positionStart, int itemCount) {
            FsRecyclerView.this.mWrapAdapter.notifyItemRangeInserted(positionStart, itemCount);
        }

        public void onItemRangeChanged(int positionStart, int itemCount) {
            FsRecyclerView.this.mWrapAdapter.notifyItemRangeChanged(positionStart, itemCount);
        }

        public void onItemRangeChanged(int positionStart, int itemCount, Object payload) {
            FsRecyclerView.this.mWrapAdapter.notifyItemRangeChanged(positionStart, itemCount, payload);
        }

        public void onItemRangeRemoved(int positionStart, int itemCount) {
            FsRecyclerView.this.mWrapAdapter.notifyItemRangeRemoved(positionStart, itemCount);
        }

        public void onItemRangeMoved(int fromPosition, int toPosition, int itemCount) {
            FsRecyclerView.this.mWrapAdapter.notifyItemMoved(fromPosition, toPosition);
        }
    };

    public FsRecyclerView(Context context) {
        this(context, null);
    }

    public FsRecyclerView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
        this.init(context, attrs);
    }

    public FsRecyclerView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(context, attrs);
    }

    private void init(Context context, AttributeSet attrs) {
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.FsRecyclerView);
        this.pullRefreshEnabled = a.getBoolean(R.styleable.FsRecyclerView_pull_refresh_enabled, true);
        this.loadingMoreEnabled = a.getBoolean(R.styleable.FsRecyclerView_loading_more_enabled, true);
        this.mMaxHeight = a.getLayoutDimension(R.styleable.FsRecyclerView_maxHeight, this.mMaxHeight);
        a.recycle();
        YunRefreshHeader refreshHeader = new YunRefreshHeader(context);
        this.addHeaderView((View)refreshHeader);
        this.mRefreshHeader = refreshHeader;
        LoadingMoreFooter footView = new LoadingMoreFooter(context);
        this.addFootView((View)footView, false);
    }

    public LoadingListener getLoadingListener() {
        return this.mLoadingListener;
    }

    public WrapAdapter getWrapAdapter() {
        return this.mWrapAdapter;
    }

    public SparseArray<View> getHeaderViews() {
        return this.mHeaderViews;
    }

    protected void onMeasure(int widthSpec, int heightSpec) {
        if (this.mMaxHeight > 0) {
            heightSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxHeight, (int)Integer.MIN_VALUE);
        }
        super.onMeasure(widthSpec, heightSpec);
    }

    public void addHeaderView(View view) {
        this.mHeaderViews.clear();
        this.mHeaderViews.put(0, (Object)view);
    }

    public void addFootView(View view, boolean isOther) {
        this.mFootViews.clear();
        this.mFootViews.put(0, (Object)view);
        this.isOther = isOther;
    }

    public void setNoMoreFootView(View view) {
        View footView;
        if (this.mFootViews.size() > 0 && view != null && (footView = (View)this.mFootViews.get(0)) instanceof ILoadMoreView) {
            ((ILoadMoreView)footView).setNoMoreView(view);
            ((ILoadMoreView)footView).hideView();
        }
    }

    private void loadMoreComplete() {
        this.isLoadingData = false;
        View footView = (View)this.mFootViews.get(0);
        if (this.previousTotal <= this.getLayoutManager().getItemCount()) {
            if (footView instanceof ILoadMoreView) {
                ((ILoadMoreView)footView).setState(3);
            } else {
                footView.setVisibility(8);
            }
        } else {
            if (footView instanceof ILoadMoreView) {
                ((ILoadMoreView)footView).setState(4);
            } else {
                footView.setVisibility(8);
            }
            this.isNomore = true;
        }
        this.previousTotal = this.getLayoutManager().getItemCount();
    }

    public void noMoreLoading() {
        this.isLoadingData = false;
        this.isNomore = true;
        View footView = (View)this.mFootViews.get(0);
        if (footView == null) {
            return;
        }
        this.postDelayed(() -> {
            if (footView instanceof ILoadMoreView) {
                if (this.isOnTop() && this.isOnBottom()) {
                    ((ILoadMoreView)footView).setState(5);
                } else {
                    footView.setVisibility(0);
                    ((ILoadMoreView)footView).setState(4);
                }
            } else {
                footView.setVisibility(8);
            }
            if (this.isOther) {
                footView.setVisibility(0);
            }
        }, 300L);
    }

    public void refreshComplete() {
        this.removeEmptyView();
        if (this.isLoadingData) {
            this.loadMoreComplete();
            SystemClock.sleep((long)500L);
        } else {
            View footView = (View)this.mFootViews.get(0);
            if (footView instanceof ILoadMoreView) {
                ((ILoadMoreView)footView).hideView();
            } else {
                footView.setVisibility(8);
            }
        }
        this.mRefreshHeader.refreshComplete();
    }

    public void hideFootView() {
        if (this.mFootViews.size() > 0) {
            this.postDelayed(() -> {
                View footView = (View)this.mFootViews.get(0);
                if (footView instanceof ILoadMoreView) {
                    ((ILoadMoreView)footView).hideView();
                } else {
                    footView.setVisibility(8);
                }
            }, 400L);
        }
    }

    public void setAdapter(RecyclerView.Adapter adapter) {
        if (adapter instanceof BaseRecyclerViewAdapter) {
            ((BaseRecyclerViewAdapter)adapter).setNotifyItemRangeOff(this.mHeaderViews.size());
        }
        this.mWrapAdapter = new WrapAdapter(this.mHeaderViews, this.mFootViews, adapter);
        super.setAdapter((RecyclerView.Adapter)this.mWrapAdapter);
        adapter.registerAdapterDataObserver(this.mDataObserver);
        RecyclerView.ItemAnimator animator = this.getItemAnimator();
        if (animator instanceof SimpleItemAnimator) {
            ((SimpleItemAnimator)animator).setSupportsChangeAnimations(false);
        }
    }

    public boolean isHeadView(int position) {
        return this.mWrapAdapter.isHeader(position);
    }

    public int getHeadSize() {
        return this.mHeaderViews.size();
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mLastY == -1.0f) {
            this.mLastY = ev.getRawY();
        }
        switch (ev.getAction()) {
            case 0: {
                this.mLastY = ev.getRawY();
                break;
            }
            case 2: {
                View footView;
                float deltaY = ev.getRawY() - this.mLastY;
                this.mLastY = ev.getRawY();
                if (this.isOnTop() && this.pullRefreshEnabled) {
                    this.mRefreshHeader.onMove(deltaY / 1.75f);
                    if (this.mRefreshHeader.getVisibleHeight() > 0 && this.mRefreshHeader.getState() < 2) {
                        return false;
                    }
                }
                if (!this.isOnBottom() || !this.loadingMoreEnabled || this.isNomore || this.mFootViews.size() <= 0 || this.isLoadingData || !((footView = (View)this.mFootViews.get(0)) instanceof ILoadMoreView)) break;
                ((ILoadMoreView)footView).onMove(deltaY / 1.75f);
                break;
            }
            default: {
                View footView;
                if (ev.getAction() == 1) {
                    if (this.dy > 0) {
                        if (this.upDownListener != null) {
                            this.upDownListener.onUpScroll();
                        }
                    } else if (this.upDownListener != null) {
                        this.upDownListener.onDownScroll();
                    }
                }
                this.mLastY = -1.0f;
                if (this.isOnTop() && this.pullRefreshEnabled && this.mRefreshHeader.releaseAction() && this.mLoadingListener != null) {
                    this.mLoadingListener.onRefresh();
                    this.isNomore = false;
                    this.previousTotal = 0;
                    footView = (View)this.mFootViews.get(0);
                    if (footView instanceof ILoadMoreView) {
                        ((ILoadMoreView)footView).setState(0);
                        if (footView.getVisibility() != 8) {
                            footView.setVisibility(8);
                        }
                    }
                }
                if (!this.isOnBottom() || !this.loadingMoreEnabled || this.isLoadingData || this.isNomore || !((footView = (View)this.mFootViews.get(0)) instanceof ILoadMoreView)) break;
                ILoadMoreView foot = (ILoadMoreView)footView;
                if (foot.getVisibleHeight() > 0 && foot.getState() == 1) {
                    foot.setState(2);
                    this.isLoadingData = true;
                    if (this.mLoadingListener == null) break;
                    this.postDelayed(() -> this.mLoadingListener.onLoadMore(), 500L);
                    break;
                }
                if (foot.getVisibleHeight() <= 0 || foot.getState() != 0) break;
                foot.smoothScrollTo(0);
            }
        }
        return super.onTouchEvent(ev);
    }

    private int findMax(int[] lastPositions) {
        int max = lastPositions[0];
        for (int value : lastPositions) {
            if (value <= max) continue;
            max = value;
        }
        return max;
    }

    private int findMin(int[] firstPositions) {
        int min = firstPositions[0];
        for (int value : firstPositions) {
            if (value >= min) continue;
            min = value;
        }
        return min;
    }

    public void addEmptyView(View view) {
        this.removeEmptyView();
        this.mHeaderViews.put(this.mHeaderViews.size(), (Object)view);
        this.mWrapAdapter.notifyDataSetChanged();
        this.noMoreLoading();
        this.hideFootView();
    }

    public void removeEmptyView() {
        for (int i = 0; i < this.mHeaderViews.size(); ++i) {
            if (!(this.mHeaderViews.get(i) instanceof IEmptyView)) continue;
            this.getLayoutManager().removeAllViews();
            this.mHeaderViews.removeAt(i);
            --i;
        }
        this.mWrapAdapter.notifyDataSetChanged();
    }

    public boolean isOnTop() {
        if (this.mHeaderViews == null || this.mHeaderViews.size() == 0) {
            return false;
        }
        View view = (View)this.mHeaderViews.get(0);
        return view.getParent() != null;
    }

    public boolean isOnBottom() {
        LinearLayoutManager layoutManager;
        View lastChild = null;
        if (this.getLayoutManager() instanceof LinearLayoutManager) {
            layoutManager = (LinearLayoutManager)this.getLayoutManager();
            int lastPos = layoutManager.findLastCompletelyVisibleItemPosition();
            lastChild = layoutManager.findViewByPosition(lastPos);
        } else if (this.getLayoutManager() instanceof GridLayoutManager) {
            layoutManager = (GridLayoutManager)this.getLayoutManager();
            int lastPos = layoutManager.findLastCompletelyVisibleItemPosition();
            lastChild = layoutManager.findViewByPosition(lastPos);
        }
        if (lastChild != null && lastChild.getBottom() + this.getPaddingBottom() == this.getBottom() - this.getTop()) {
            return true;
        }
        if (this.mFootViews == null || this.mFootViews.size() == 0) {
            return false;
        }
        View view = (View)this.mFootViews.get(0);
        return view.getParent() != null;
    }

    public void setLoadingListener(LoadingListener listener) {
        this.mLoadingListener = listener;
    }

    public void setPullRefreshEnabled(boolean pullRefreshEnabled) {
        this.pullRefreshEnabled = pullRefreshEnabled;
    }

    public void setLoadingMoreEnabled(boolean loadingMoreEnabled) {
        this.loadingMoreEnabled = loadingMoreEnabled;
    }

    public void setUpDownListener(UpDownListener listener) {
        this.upDownListener = listener;
    }

    public void setSpanCount(int num) {
        RecyclerView.LayoutManager manager = this.getLayoutManager();
        if (manager instanceof GridLayoutManager) {
            ((GridLayoutManager)manager).setSpanCount(num);
        }
    }

    public void reset() {
        this.isNomore = false;
        this.previousTotal = 0;
        View footView = (View)this.mFootViews.get(0);
        if (footView instanceof ILoadMoreView) {
            ((ILoadMoreView)footView).reset();
        }
    }

    public void onScrolled(int dx, int dy) {
        super.onScrolled(dx, dy);
        this.dy = dy;
    }

    public static interface UpDownListener {
        public void onUpScroll();

        public void onDownScroll();
    }

    public static interface LoadingListener {
        public void onRefresh();

        public void onLoadMore();
    }
}

