/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.recyclerview;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.drawable.AnimationDrawable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.fshows.android.parker.R;
import com.fshows.android.parker.recyclerview.ILoadMoreView;

public class LoadingMoreFooter
extends LinearLayout
implements ILoadMoreView {
    private int mState = 0;
    private TextView mText;
    private AnimationDrawable mAnimationDrawable;
    private ImageView mIvProgress;
    private LinearLayout llHave;
    private View llNomore;
    private int mMaxHeight = 132;

    public LoadingMoreFooter(Context context) {
        super(context);
        this.initView(context);
    }

    public LoadingMoreFooter(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView(context);
    }

    @Override
    public void onMove(float delta) {
        int setH;
        Log.e((String)"onMove", (String)("onMove:" + delta));
        if (delta > 0.0f) {
            delta *= 3.0f;
        }
        if ((setH = (int)(-delta) + this.getVisibleHeight()) > this.mMaxHeight * 2) {
            setH = this.mMaxHeight * 2;
        }
        Log.e((String)"onMove", (String)("Height:" + setH));
        this.setVisibleHeight(setH);
        if (this.mState <= 2) {
            if (setH > this.mMaxHeight) {
                this.setState(1);
            } else {
                this.setState(0);
            }
        }
    }

    public void initView(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.yun_refresh_footer, (ViewGroup)this);
        this.mText = (TextView)this.findViewById(R.id.msg);
        this.mIvProgress = (ImageView)this.findViewById(R.id.iv_progress);
        this.llHave = (LinearLayout)this.findViewById(R.id.ll_have);
        this.llNomore = this.findViewById(R.id.ll_no_more);
        this.llHave.setVisibility(8);
        this.llNomore.setVisibility(8);
        this.mAnimationDrawable = (AnimationDrawable)this.mIvProgress.getDrawable();
        if (this.mAnimationDrawable != null && !this.mAnimationDrawable.isRunning()) {
            this.mAnimationDrawable.start();
        }
        this.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
    }

    @Override
    public void setState(int state) {
        switch (state) {
            case 0: {
                if (this.mAnimationDrawable != null && !this.mAnimationDrawable.isRunning()) {
                    this.mAnimationDrawable.stop();
                }
                this.mIvProgress.setVisibility(0);
                this.mText.setText((CharSequence)"\u4e0a\u62c9\u52a0\u8f7d\u66f4\u591a");
                this.llHave.setVisibility(0);
                this.setVisibility(0);
                this.llNomore.setVisibility(8);
                break;
            }
            case 1: {
                if (this.mAnimationDrawable != null && !this.mAnimationDrawable.isRunning()) {
                    this.mAnimationDrawable.start();
                }
                this.mIvProgress.setVisibility(0);
                this.mText.setText((CharSequence)"\u677e\u5f00\u7acb\u5373\u52a0\u8f7d");
                this.llHave.setVisibility(0);
                this.setVisibility(0);
                this.llNomore.setVisibility(8);
                break;
            }
            case 2: {
                if (this.mAnimationDrawable != null && !this.mAnimationDrawable.isRunning()) {
                    this.mAnimationDrawable.start();
                }
                this.mIvProgress.setVisibility(0);
                this.mText.setText((CharSequence)"\u52a0\u8f7d\u4e2d...");
                this.llHave.setVisibility(0);
                this.setVisibility(0);
                this.llNomore.setVisibility(8);
                this.smoothScrollTo(this.mMaxHeight);
                break;
            }
            case 3: {
                if (this.mAnimationDrawable != null && this.mAnimationDrawable.isRunning()) {
                    this.mAnimationDrawable.stop();
                }
                this.mText.setText((CharSequence)"\u52a0\u8f7d\u5b8c\u6210");
                this.postDelayed(() -> this.reSet(), 500L);
                this.llHave.setVisibility(8);
                break;
            }
            case 4: {
                if (this.mAnimationDrawable != null && this.mAnimationDrawable.isRunning()) {
                    this.mAnimationDrawable.stop();
                }
                this.setVisibility(0);
                this.llHave.setVisibility(8);
                this.llNomore.setVisibility(0);
                this.mIvProgress.setVisibility(8);
                break;
            }
            default: {
                this.setVisibility(8);
            }
        }
        this.mState = state;
    }

    @Override
    public void reSet() {
        this.mState = 0;
        this.smoothScrollTo(0);
    }

    @Override
    public void setVisibleHeight(int height) {
        if (height < 0) {
            height = 0;
        }
        LinearLayout.LayoutParams lp = new LinearLayout.LayoutParams(-1, 0);
        lp.height = height;
        this.llHave.setLayoutParams((ViewGroup.LayoutParams)lp);
    }

    @Override
    public int getVisibleHeight() {
        return this.llHave.getHeight();
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public void smoothScrollTo(int destHeight) {
        ValueAnimator animator = ValueAnimator.ofInt((int[])new int[]{this.getVisibleHeight(), destHeight});
        animator.setDuration(300L).start();
        animator.addUpdateListener(animation -> this.setVisibleHeight((Integer)animation.getAnimatedValue()));
        animator.start();
    }

    @Override
    public void hideView() {
        this.llHave.setVisibility(8);
        this.llNomore.setVisibility(8);
    }

    @Override
    public void setNoMoreView(View view) {
        try {
            LinearLayout rootView = (LinearLayout)this.getChildAt(0);
            rootView.removeViewAt(rootView.getChildCount() - 1);
            this.llNomore = view;
            rootView.addView(this.llNomore);
        }
        catch (Exception e) {
            Log.e((String)this.getClass().getSimpleName(), (String)e.getMessage());
        }
    }
}

