/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.recyclerview;

import android.graphics.Canvas;
import android.graphics.Rect;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.view.ViewGroup;
import com.fshows.android.parker.recyclerview.FsRecyclerView;
import com.fshows.android.parker.recyclerview.adapter.BaseRecyclerViewAdapter;
import com.fshows.android.parker.recyclerview.adapter.BaseRecyclerViewHolder;
import com.fshows.android.parker.recyclerview.adapter.WrapAdapter;

public class FsPinnedHeaderItemDecoration
extends RecyclerView.ItemDecoration {
    private Rect mPinnedHeaderRect = null;
    private int mPinnedHeaderPosition = -1;

    public void onDrawOver(Canvas c, RecyclerView parent, RecyclerView.State state) {
        WrapAdapter wrapAdapter;
        RecyclerView.Adapter mAdapter;
        super.onDrawOver(c, parent, state);
        if (parent instanceof FsRecyclerView && (mAdapter = (wrapAdapter = (WrapAdapter)parent.getAdapter()).getAdapter()) instanceof BaseRecyclerViewAdapter && parent.getChildCount() > 0) {
            int pinnedHeaderPosition;
            BaseRecyclerViewAdapter adapter = (BaseRecyclerViewAdapter)mAdapter;
            View firstView = parent.getChildAt(0);
            int firstAdapterPosition = parent.getChildAdapterPosition(firstView) - wrapAdapter.getHeadersCount();
            this.mPinnedHeaderPosition = pinnedHeaderPosition = this.getPinnedHeaderViewPosition(firstAdapterPosition, adapter);
            if (pinnedHeaderPosition != -1) {
                RecyclerView.ViewHolder pinnedHeaderViewHolder = adapter.onCreateViewHolder((ViewGroup)parent, adapter.getItemViewType(pinnedHeaderPosition));
                adapter.onBindViewHolder((BaseRecyclerViewHolder)pinnedHeaderViewHolder, pinnedHeaderPosition);
                View pinnedHeaderView = ((BaseRecyclerViewHolder)pinnedHeaderViewHolder).itemView;
                this.ensurePinnedHeaderViewLayout(pinnedHeaderView, parent);
                int sectionPinOffset = 0;
                for (int index = wrapAdapter.getHeadersCount(); index < parent.getChildCount() - wrapAdapter.getFootersCount(); ++index) {
                    int pinViewHeight;
                    View sectionView;
                    int sectionTop;
                    if (!adapter.isPinnedPosition(parent.getChildAdapterPosition(parent.getChildAt(index)) - wrapAdapter.getHeadersCount()) || (sectionTop = (sectionView = parent.getChildAt(index)).getTop()) >= (pinViewHeight = pinnedHeaderView.getHeight()) || sectionTop <= 0) continue;
                    sectionPinOffset = sectionTop - pinViewHeight;
                }
                int saveCount = c.save();
                RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)pinnedHeaderView.getLayoutParams();
                if (layoutParams == null) {
                    throw new NullPointerException("PinnedHeaderItemDecoration");
                }
                c.translate((float)layoutParams.leftMargin, (float)sectionPinOffset);
                c.clipRect(0, 0, parent.getWidth(), pinnedHeaderView.getMeasuredHeight());
                pinnedHeaderView.draw(c);
                c.restoreToCount(saveCount);
                if (this.mPinnedHeaderRect == null) {
                    this.mPinnedHeaderRect = new Rect();
                }
                this.mPinnedHeaderRect.set(0, 0, parent.getWidth(), pinnedHeaderView.getMeasuredHeight() + sectionPinOffset);
            } else {
                this.mPinnedHeaderRect = null;
            }
        }
    }

    public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
    }

    private int getPinnedHeaderViewPosition(int adapterFirstVisible, BaseRecyclerViewAdapter adapter) {
        for (int index = adapterFirstVisible; index >= 0; --index) {
            if (!adapter.isPinnedPosition(index)) continue;
            return index;
        }
        return -1;
    }

    private void ensurePinnedHeaderViewLayout(View pinView, RecyclerView recyclerView) {
        if (pinView.isLayoutRequested()) {
            RecyclerView.LayoutParams layoutParams = (RecyclerView.LayoutParams)pinView.getLayoutParams();
            if (layoutParams == null) {
                throw new NullPointerException("PinnedHeaderItemDecoration");
            }
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)(recyclerView.getMeasuredWidth() - layoutParams.leftMargin - layoutParams.rightMargin), (int)0x40000000);
            int heightSpec = layoutParams.height > 0 ? View.MeasureSpec.makeMeasureSpec((int)layoutParams.height, (int)0x40000000) : View.MeasureSpec.makeMeasureSpec((int)0, (int)0);
            pinView.measure(widthSpec, heightSpec);
            pinView.layout(0, 0, pinView.getMeasuredWidth(), pinView.getMeasuredHeight());
        }
    }
}

