/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.parker.loopview;

import com.fshows.android.parker.loopview.WheelView;
import java.util.TimerTask;

public final class InertiaTimerTask
extends TimerTask {
    private float mCurrentVelocityY;
    private final float mFirstVelocityY;
    private final WheelView mWheelView;

    public InertiaTimerTask(WheelView wheelView, float velocityY) {
        this.mWheelView = wheelView;
        this.mFirstVelocityY = velocityY;
        this.mCurrentVelocityY = 2.1474836E9f;
    }

    @Override
    public final void run() {
        if (this.mCurrentVelocityY == 2.1474836E9f) {
            this.mCurrentVelocityY = Math.abs(this.mFirstVelocityY) > 2000.0f ? (this.mFirstVelocityY > 0.0f ? 2000.0f : -2000.0f) : this.mFirstVelocityY;
        }
        if (Math.abs(this.mCurrentVelocityY) >= 0.0f && Math.abs(this.mCurrentVelocityY) <= 20.0f) {
            this.mWheelView.cancelFuture();
            this.mWheelView.getHandler().sendEmptyMessage(2000);
            return;
        }
        int dy = (int)(this.mCurrentVelocityY / 100.0f);
        this.mWheelView.setTotalScrollY(this.mWheelView.getTotalScrollY() - (float)dy);
        if (!this.mWheelView.isCyclic()) {
            float itemHeight = this.mWheelView.getItemHeight();
            float top = (float)(-this.mWheelView.getInitPosition()) * itemHeight;
            float bottom = (float)(this.mWheelView.getItemsCount() - 1 - this.mWheelView.getInitPosition()) * itemHeight;
            if ((double)this.mWheelView.getTotalScrollY() - (double)itemHeight * 0.25 < (double)top) {
                top = this.mWheelView.getTotalScrollY() + (float)dy;
            } else if ((double)this.mWheelView.getTotalScrollY() + (double)itemHeight * 0.25 > (double)bottom) {
                bottom = this.mWheelView.getTotalScrollY() + (float)dy;
            }
            if (this.mWheelView.getTotalScrollY() <= top) {
                this.mCurrentVelocityY = 40.0f;
                this.mWheelView.setTotalScrollY((int)top);
            } else if (this.mWheelView.getTotalScrollY() >= bottom) {
                this.mWheelView.setTotalScrollY((int)bottom);
                this.mCurrentVelocityY = -40.0f;
            }
        }
        this.mCurrentVelocityY = this.mCurrentVelocityY < 0.0f ? (this.mCurrentVelocityY += 20.0f) : (this.mCurrentVelocityY -= 20.0f);
        this.mWheelView.getHandler().sendEmptyMessage(1000);
    }
}

