/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.fsvideo;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.view.ContextThemeWrapper;
import androidx.appcompat.app.ActionBar;
import androidx.appcompat.app.AppCompatActivity;

public class FsVideoUtils {
    public static Activity scanForActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof Activity) {
            return (Activity)context;
        }
        if (context instanceof ContextWrapper) {
            return FsVideoUtils.scanForActivity(((ContextWrapper)context).getBaseContext());
        }
        return null;
    }

    private static AppCompatActivity getAppCompActivity(Context context) {
        if (context == null) {
            return null;
        }
        if (context instanceof AppCompatActivity) {
            return (AppCompatActivity)context;
        }
        if (context instanceof ContextThemeWrapper) {
            return FsVideoUtils.getAppCompActivity(((ContextThemeWrapper)context).getBaseContext());
        }
        return null;
    }

    public static void showActionBar(Context context) {
        ActionBar ab = FsVideoUtils.getAppCompActivity(context).getSupportActionBar();
        if (ab != null) {
            ab.setShowHideAnimationEnabled(false);
            ab.show();
        }
        FsVideoUtils.scanForActivity(context).getWindow().clearFlags(1024);
    }

    public static void hideActionBar(Context context) {
        ActionBar ab = FsVideoUtils.getAppCompActivity(context).getSupportActionBar();
        if (ab != null) {
            ab.setShowHideAnimationEnabled(false);
            ab.hide();
        }
        FsVideoUtils.scanForActivity(context).getWindow().setFlags(1024, 1024);
    }

    public static void savePlayPosition(Context context, String url, long position) {
        context.getSharedPreferences("NICE_VIDEO_PALYER_PLAY_POSITION", 0).edit().putLong(url, position).apply();
    }

    public static long getSavedPlayPosition(Context context, String url) {
        return context.getSharedPreferences("NICE_VIDEO_PALYER_PLAY_POSITION", 0).getLong(url, 0L);
    }
}

