/*
 * Decompiled with CFR 0.152.
 */
package com.mob.mobapm.apm.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Streams {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    public static int copy(InputStream input, OutputStream output) throws IOException {
        return Streams.copy(input, output, 8192, false);
    }

    public static int copy(InputStream input, OutputStream output, boolean closeStreams) throws IOException {
        return Streams.copy(input, output, 8192, closeStreams);
    }

    public static int copy(InputStream input, OutputStream output, int bufferSize) throws IOException {
        return Streams.copy(input, output, bufferSize, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int copy(InputStream input, OutputStream output, int bufferSize, boolean closeStreams) throws IOException {
        try {
            byte[] buffer = new byte[bufferSize];
            int count = 0;
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
                count += n;
            }
            int n2 = count;
            return n2;
        }
        finally {
            if (closeStreams) {
                input.close();
                output.close();
            }
        }
    }

    public static byte[] slurpBytes(InputStream in) throws IOException {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Streams.copy(in, out);
            out.flush();
            byte[] byArray = out.toByteArray();
            return byArray;
        }
    }

    public static String slurp(InputStream in, String encoding) throws IOException {
        byte[] bytes = Streams.slurpBytes(in);
        return new String(bytes, encoding);
    }

    public static void copyBytesToFile(File file, byte[] newBytes) throws IOException {
        try (FileOutputStream oStream = new FileOutputStream(file);){
            Streams.copy((InputStream)new ByteArrayInputStream(newBytes), (OutputStream)oStream, true);
        }
    }
}

