/*
 * Decompiled with CFR 0.152.
 */
package com.mob.mobapm.apm;

import com.mob.mobapm.apm.ClassData;
import com.mob.mobapm.apm.InstrumentationContext;
import com.mob.mobapm.apm.utils.FileUtils;
import com.mob.mobapm.apm.utils.Log;
import com.mob.mobapm.apm.utils.SkipException;
import com.mob.mobapm.apm.utils.Streams;
import com.mob.mobapm.apm.visitor.AnnotatingClassVisitor;
import com.mob.mobapm.apm.visitor.ContextInitializationClassVisitor;
import com.mob.mobapm.apm.visitor.PrefilterClassVisitor;
import com.mob.mobapm.apm.visitor.WrapMethodClassVisitor;
import com.mob.mobapm.org.objectweb.asm.ClassReader;
import com.mob.mobapm.org.objectweb.asm.ClassWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Pattern;

public class MobClassTransformer {
    private static final String NR_PACKAGE_NAME = "Lcom/mob/mobapm";
    private List<File> classes;
    private File inputFile;
    private File outputFile;
    private ClassData classData;
    private InstrumentationContext context;
    private boolean fullApk = false;
    private Pattern androidPackagePattern = Pattern.compile("^android[x]{0,1}/.*");
    private Pattern kotlinPackagePattern = Pattern.compile("^kotlin[x]{0,1}/.*");
    public static final Set<String> DX_COMMAND_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("dx", "dx.bat")));
    public static final Set<String> JAVA_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("java", "java.exe")));
    private static final Set<String> AGENT_JAR_NAMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("obfuscated.jar")));
    public static final Set<String> EXCLUDED_PACKAGES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList(new String[0])));
    public static final Set<String> INCLUDED_PACKAGES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("androidx/appcompat/app/AppCompatActivity", "androidx/core/app/ActivityCompat", "androidx/fragment/app/", "androidx/fragment/app/Fragment", "androidx/fragment/app/FragmentActivity", "androidx/leanback/app/Fragment", "androidx/legacy/app/ActivityCompat", "androidx/legacy/app/FragmentCompat", "androidx/preference/Fragment", "androidx/sqlite/", "org.json")));

    public MobClassTransformer() {
        this.classes = new ArrayList<File>();
        this.inputFile = new File(".");
        this.outputFile = new File(".");
        this.context = new InstrumentationContext();
    }

    public MobClassTransformer(File classPath, File outputDir) {
        this();
        this.classes.add(classPath);
        this.inputFile = classPath;
        this.outputFile = outputDir;
        if (classPath.isDirectory()) {
            this.inputFile = classPath;
        }
    }

    public MobClassTransformer(File classPath, File outputDir, boolean fullApk) {
        this();
        this.classes.add(classPath);
        this.inputFile = classPath;
        this.outputFile = outputDir;
        this.fullApk = fullApk;
        if (classPath.isDirectory()) {
            this.inputFile = classPath;
        }
    }

    public MobClassTransformer(JarFile jarFile, File outputJar) {
        this();
        File jar = new File(jarFile.getName());
        this.inputFile = jar.getParentFile();
        this.outputFile = outputJar;
    }

    public MobClassTransformer(JarFile jarFile, File outputJar, boolean fullApk) {
        this();
        File jar = new File(jarFile.getName());
        this.inputFile = jar.getParentFile();
        this.outputFile = outputJar;
        this.fullApk = fullApk;
    }

    public void doTransform() {
        long tStart = System.currentTimeMillis();
        for (File classFile : this.classes) {
            this.inputFile = FileUtils.isClass(classFile) ? classFile.getParentFile() : classFile;
            this.transformClassFile(classFile);
        }
    }

    public void setInputFile(File inputFile) {
        this.inputFile = inputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public byte[] transformClassBytes(String classPathname, byte[] bytes) {
        if (FileUtils.isClass(classPathname)) {
            try {
                if (bytes != null) {
                    this.classData = this.visitClassBytesWithOptions(bytes, 2);
                    if (this.classData != null && this.classData.getMainClassBytes() != null && this.classData.isModified()) {
                        return this.classData.getMainClassBytes();
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bytes;
    }

    private ByteArrayInputStream processClassBytes(File classFile, InputStream classFileInputStream) throws IOException {
        ByteArrayInputStream processedClassBytesStream = null;
        byte[] classBytes = Streams.slurpBytes(classFileInputStream);
        byte[] transformedClassBytes = this.transformClassBytes(classFile.getPath(), classBytes);
        if (transformedClassBytes == null) {
            Log.e("transformedClassBytes is null ");
            processedClassBytesStream = new ByteArrayInputStream(classBytes);
        } else {
            if (classBytes.length != transformedClassBytes.length && this.classData != null && this.classData.isModified()) {
                Log.e("[ClassTransformer] Rewrote class[" + classFile.getPath() + "] bytes[" + classBytes.length + "] rewritten[" + transformedClassBytes.length + "]");
            }
            processedClassBytesStream = new ByteArrayInputStream(transformedClassBytes);
        }
        return processedClassBytesStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transformClassFile(File classFile) {
        boolean didProcessClass;
        block12: {
            didProcessClass = false;
            try {
                if (FileUtils.isArchive(classFile)) {
                    didProcessClass = this.transformAndExplodeArchive(classFile);
                    break block12;
                }
                if (classFile.isDirectory()) {
                    didProcessClass = this.transformDirectory(classFile);
                    break block12;
                }
                String classpath = classFile.getAbsolutePath();
                if (classpath.startsWith(this.inputFile.getAbsolutePath())) {
                    classpath = classpath.substring(this.inputFile.getAbsolutePath().length() + 1);
                }
                File transformedClassFile = new File(this.outputFile, classpath);
                FileInputStream classBytesInputStream = null;
                ByteArrayInputStream classBytesOutputStream = null;
                try {
                    classBytesInputStream = new FileInputStream(classFile);
                    if (FileUtils.isClass(classFile)) {
                        classBytesOutputStream = this.processClassBytes(new File(classpath), classBytesInputStream);
                        didProcessClass = this.writeClassFile(classBytesOutputStream, transformedClassFile);
                    } else {
                        didProcessClass = this.writeClassFile(classBytesInputStream, transformedClassFile);
                    }
                    this.closeQuietly(classBytesInputStream);
                    this.closeQuietly(classBytesOutputStream);
                }
                catch (Exception e) {
                    didProcessClass = this.writeClassFile(classBytesInputStream, transformedClassFile);
                }
                finally {
                    this.closeQuietly(classBytesInputStream);
                    this.closeQuietly(classBytesOutputStream);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return didProcessClass;
    }

    public boolean transformDirectory(File directory) {
        boolean didProcessDirectory = false;
        if (directory.isDirectory()) {
            for (File f : directory.listFiles()) {
                didProcessDirectory |= this.transformClassFile(f);
            }
        }
        return didProcessDirectory;
    }

    public boolean transformAndExplodeArchive(File archiveFile) throws IOException {
        return this.transformArchive(archiveFile, true);
    }

    public boolean transformArchive(File archiveFile) throws IOException {
        return this.transformArchive(archiveFile, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean transformArchive(File archiveFile, boolean explodeJar) throws IOException {
        JarFile jarFile;
        JarOutputStream jarOutputStream;
        JarInputStream jarInputStream;
        ByteArrayOutputStream byteArrayOutputStream;
        FileInputStream archiveFileInputStream;
        boolean didProcessArchive;
        block36: {
            boolean rewrittenJar3;
            didProcessArchive = false;
            if (FileUtils.isSupportJar(archiveFile)) {
                Log.e("[ClassTransformer] Skipping support jar [" + archiveFile.getPath() + "]");
                return false;
            }
            Log.e("[ClassTransformer] Transforming archive[" + archiveFile.getCanonicalPath() + "]");
            archiveFileInputStream = null;
            byteArrayOutputStream = null;
            jarInputStream = null;
            jarOutputStream = null;
            jarFile = null;
            JarEntry e = new JarEntry("META-INF/MANIFEST.MF");
            boolean doTransform = true;
            jarFile = new JarFile(archiveFile);
            byteArrayOutputStream = new ByteArrayOutputStream();
            archiveFileInputStream = new FileInputStream(archiveFile);
            jarInputStream = new JarInputStream(archiveFileInputStream);
            jarOutputStream = new JarOutputStream(byteArrayOutputStream);
            jarOutputStream.putNextEntry(e);
            Manifest realManifest = jarFile.getManifest();
            if (realManifest != null) {
                Map<String, Attributes> rewrittenJar = realManifest.getEntries();
                for (String jarEntry : rewrittenJar.keySet()) {
                    Attributes archiveClassFile = realManifest.getAttributes(jarEntry);
                    for (Object classBytesOutputStream : archiveClassFile.keySet()) {
                        String e2 = classBytesOutputStream.toString();
                        if (!"SHA1-Digest".equals(e2) && !"SHA-256-Digest".equals(e2)) continue;
                        doTransform = false;
                    }
                }
                realManifest.write(jarOutputStream);
            }
            jarOutputStream.flush();
            jarOutputStream.closeEntry();
            if (doTransform) break block36;
            Log.e("[ClassTransformer] Skipping instrumentation of signed jar [" + archiveFile.getPath() + "]");
            boolean e1 = rewrittenJar3 = Streams.copy(new FileInputStream(archiveFile), new FileOutputStream(this.outputFile)) > 0;
            this.closeQuietly(jarFile);
            this.closeQuietly(archiveFileInputStream);
            this.closeQuietly(byteArrayOutputStream);
            this.closeQuietly(jarInputStream);
            this.closeQuietly(jarOutputStream);
            return e1;
        }
        try {
            JarEntry rewrittenJar1 = jarInputStream.getNextJarEntry();
            while (rewrittenJar1 != null) {
                String e3 = rewrittenJar1.getName();
                if (!rewrittenJar1.isDirectory() && FileUtils.isClass(e3)) {
                    JarEntry jarEntry1 = new JarEntry(e3);
                    File archiveClassFile1 = new File(this.outputFile, e3);
                    InputStream classBytesInputStream1 = null;
                    ByteArrayInputStream classBytesOutputStream1 = null;
                    jarEntry1.setTime(rewrittenJar1.getTime());
                    jarOutputStream.putNextEntry(jarEntry1);
                    try {
                        classBytesInputStream1 = jarFile.getInputStream(rewrittenJar1);
                        classBytesOutputStream1 = this.processClassBytes(archiveClassFile1, classBytesInputStream1);
                        if (explodeJar) {
                            didProcessArchive |= this.writeClassFile(classBytesOutputStream1, archiveClassFile1);
                        } else {
                            this.writeClassStream(classBytesOutputStream1, jarOutputStream);
                            didProcessArchive = true;
                        }
                        jarOutputStream.flush();
                        jarOutputStream.closeEntry();
                        this.closeQuietly(classBytesInputStream1);
                        this.closeQuietly(classBytesOutputStream1);
                    }
                    catch (Exception var53) {
                        try {
                            Log.e("[ClassTransformer] transformArchive: " + var53);
                            Log.e("[ClassTransformer] transformArchive: " + var53.toString());
                            if (explodeJar) {
                                didProcessArchive |= this.writeClassFile(classBytesInputStream1, archiveClassFile1);
                            } else {
                                this.writeClassStream(classBytesInputStream1, jarOutputStream);
                                didProcessArchive = true;
                            }
                            this.closeQuietly(classBytesInputStream1);
                            this.closeQuietly(classBytesOutputStream1);
                        }
                        catch (Throwable throwable) {
                            this.closeQuietly(classBytesInputStream1);
                            this.closeQuietly(classBytesOutputStream1);
                            throw throwable;
                        }
                    }
                }
                rewrittenJar1 = jarInputStream.getNextJarEntry();
            }
            if (didProcessArchive) {
                File rewrittenJar2 = new File(this.outputFile.getAbsolutePath());
                if (archiveFile.getAbsolutePath() != rewrittenJar2.getAbsolutePath()) {
                    Log.e("[ClassTransformer] Rewriting archive to [" + rewrittenJar2.getAbsolutePath() + "]");
                    this.closeQuietly(jarOutputStream);
                    try (ByteArrayInputStream e4 = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());){
                        this.writeClassFile(e4, rewrittenJar2);
                    }
                    catch (Exception var52) {
                        Log.e("ClassTransformer] transformArchive: " + var52);
                    }
                } else {
                    Log.e("[ClassTransformer] Refusing to overwrite archive [" + rewrittenJar2.getAbsolutePath() + "]");
                }
            }
            this.closeQuietly(jarFile);
            this.closeQuietly(archiveFileInputStream);
            this.closeQuietly(byteArrayOutputStream);
            this.closeQuietly(jarInputStream);
            this.closeQuietly(jarOutputStream);
        }
        catch (Exception var55) {
            try {
                Log.e("[ClassTransformer] transformArchive: " + var55);
                this.closeQuietly(jarFile);
                this.closeQuietly(archiveFileInputStream);
                this.closeQuietly(byteArrayOutputStream);
                this.closeQuietly(jarInputStream);
                this.closeQuietly(jarOutputStream);
            }
            catch (Throwable throwable) {
                this.closeQuietly(jarFile);
                this.closeQuietly(archiveFileInputStream);
                this.closeQuietly(byteArrayOutputStream);
                this.closeQuietly(jarInputStream);
                this.closeQuietly(jarOutputStream);
                throw throwable;
            }
        }
        return didProcessArchive;
    }

    protected boolean writeClassStream(InputStream inStream, OutputStream outStrm) throws IOException {
        if (inStream != null) {
            return 0 < Streams.copy(inStream, outStrm);
        }
        return false;
    }

    protected boolean writeClassFile(InputStream inStream, File className) throws IOException {
        boolean writeResult = false;
        if (inStream != null && className != null) {
            Log.e("mkDirs" + className);
            className.getParentFile().mkdirs();
            try (FileOutputStream modifiedClassBytesStream = new FileOutputStream(className);){
                writeResult = this.writeClassStream(inStream, modifiedClassBytesStream);
                this.closeQuietly(modifiedClassBytesStream);
            }
            catch (FileNotFoundException e) {
                Log.e("writeClassFile: " + e);
            }
            catch (IOException e) {
                Log.e("writeClassFile: " + e);
            }
        } else {
            Log.e("writeClassFile: input stream or class name is missing!");
        }
        return writeResult;
    }

    private void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClassData visitClassBytesWithOptions(byte[] bytes, int classWriterFlags) {
        WrapMethodClassVisitor cv = null;
        String className = "an unknown class";
        try {
            ClassReader cr = new ClassReader(bytes);
            ClassWriter cw = new ClassWriter(cr, classWriterFlags);
            this.context.reset();
            cr.accept(new PrefilterClassVisitor(this.context), 7);
            className = this.context.getClassName();
            if (this.context.hasTag("Lcom/mob/mobapm/proxy/MobInstrumented;")) return null;
            if (this.shouldVisit(className)) {
                ClassWriter cv2 = cw;
                Log.e("start transform and class name is " + className);
                if (!className.startsWith(NR_PACKAGE_NAME) && !this.isAndroidSDKPackage(className)) {
                    if (this.isExcludedPackage(className)) {
                        return null;
                    }
                    cv = new WrapMethodClassVisitor(new AnnotatingClassVisitor(cv2, this.context), this.context);
                }
                try {
                    cr.accept(new ContextInitializationClassVisitor(cv, this.context), 12);
                    if (!this.context.isClassModified() || bytes.length == cw.toByteArray().length) return this.context.newClassData(cw.toByteArray());
                    Log.e("[InvocationDispatcher] class[" + className + "] bytes[" + bytes.length + "] transformed[" + cw.toByteArray().length + "]");
                    return this.context.newClassData(cw.toByteArray());
                }
                catch (Exception e) {
                    if (classWriterFlags == 1) return new ClassData(bytes, false);
                    Log.e("[InvocationDispatcher] [" + className + "] " + e.toString());
                    Log.e("[InvocationDispatcher] Retry with ClassWriter.COMPUTE_MAXS");
                    return this.visitClassBytesWithOptions(bytes, 1);
                }
            } else {
                Log.e(MessageFormat.format("[{0}] class is already instrumented! skipping ...", this.context.getFriendlyClassName()));
            }
            return this.context.newClassData(cw.toByteArray());
        }
        catch (SkipException e2) {
            Log.e("[InvocationDispatcher] " + e2.getLocalizedMessage());
            return new ClassData(bytes, false);
        }
        catch (Throwable t) {
            Log.e(t.getMessage() + t);
            return new ClassData(bytes, false);
        }
    }

    private boolean shouldVisit(String className) {
        Log.e("need transform all ?" + this.fullApk);
        if (this.fullApk) {
            return (className.startsWith("com/mob/mobapm/demo") || !className.startsWith("com/mob/mobapm")) && !this.context.hasTag("Lcom/mob/mobapm/proxy/MobInstrumented;");
        }
        return className.startsWith("com/mob/tools") && !this.context.hasTag("Lcom/mob/mobapm/proxy/MobInstrumented;");
    }

    private boolean isExcludedPackage(String packageName) {
        if (this.isIncludedPackage(packageName)) {
            return false;
        }
        String lowercasePackageName = packageName.toLowerCase();
        for (String name : EXCLUDED_PACKAGES) {
            if (!lowercasePackageName.startsWith(name)) continue;
            return true;
        }
        return false;
    }

    boolean isKotlinSDKPackage(String className) {
        return this.kotlinPackagePattern.matcher(className.toLowerCase()).matches();
    }

    boolean isAndroidSDKPackage(String className) {
        return this.androidPackagePattern.matcher(className.toLowerCase()).matches() || this.isKotlinSDKPackage(className);
    }

    private boolean isIncludedPackage(String packageName) {
        String lowercasePackageName = packageName.toLowerCase();
        for (String name : INCLUDED_PACKAGES) {
            if (!lowercasePackageName.startsWith(name)) continue;
            return true;
        }
        return false;
    }
}

