/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.annotation.SuppressLint;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothClass;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanCallback;
import android.bluetooth.le.ScanRecord;
import android.bluetooth.le.ScanResult;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelUuid;
import com.mob.tools.MobHandlerThread;
import com.mob.tools.MobLog;
import com.mob.tools.utils.DeviceHelper;
import com.mob.tools.utils.ReflectHelper;
import com.mob.tools.utils.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BHelper {
    private static final String TAG = "BHelper";
    private static BHelper instance;
    private Context context;
    private boolean mScanning = false;
    private BroadcastReceiver bOperationReceiver;
    private boolean bOperationRegistered = false;
    private BroadcastReceiver bScanReceiver;
    private boolean bScanRegistered = false;
    private Map<String, BOperationCallback> bOperationCallbackMap;

    private BHelper(Context context) {
        this.context = context.getApplicationContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static BHelper getInstance(Context context) {
        if (instance != null) return instance;
        Class<BHelper> clazz = BHelper.class;
        synchronized (BHelper.class) {
            if (instance != null) return instance;
            instance = new BHelper(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public void unRegisterBOperationReceiver(String id) {
        try {
            if (this.bOperationCallbackMap != null && !this.bOperationCallbackMap.containsKey(id)) {
                this.bOperationCallbackMap.remove(id);
            }
            if (this.bOperationCallbackMap.isEmpty() && this.bOperationReceiver != null && this.bOperationRegistered) {
                ReflectHelper.invokeInstanceMethod((Object)this.context, "unregisterReceiver", new Object[]{this.bOperationReceiver}, new Class[]{BroadcastReceiver.class});
                this.bOperationRegistered = false;
                this.bOperationReceiver = null;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
        }
    }

    public void registerBOperationReceiver(String id, BOperationCallback bOperationCallback) {
        if (bOperationCallback != null) {
            if (this.bOperationCallbackMap == null) {
                this.bOperationCallbackMap = new HashMap<String, BOperationCallback>();
            }
            this.bOperationCallbackMap.put(id, bOperationCallback);
            if (this.bOperationReceiver == null) {
                try {
                    this.bOperationReceiver = new BroadcastReceiver(){

                        public void onReceive(Context context, Intent intent) {
                            block27: {
                                try {
                                    String action = intent.getAction();
                                    if (action.equals("android.bluetooth.adapter.action.STATE_CHANGED")) {
                                        int bNewState = intent.getIntExtra("android.bluetooth.adapter.extra.STATE", 0);
                                        int bOldState = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_STATE", 0);
                                        switch (bNewState) {
                                            case 11: {
                                                break;
                                            }
                                            case 12: {
                                                if (BHelper.this.bOperationCallbackMap == null || BHelper.this.bOperationCallbackMap.isEmpty()) break;
                                                for (Map.Entry entry : BHelper.this.bOperationCallbackMap.entrySet()) {
                                                    BOperationCallback callback = (BOperationCallback)entry.getValue();
                                                    if (callback == null) continue;
                                                    callback.onEnabled();
                                                }
                                                break block27;
                                            }
                                            case 13: {
                                                break;
                                            }
                                            case 10: {
                                                if (BHelper.this.bOperationCallbackMap == null || BHelper.this.bOperationCallbackMap.isEmpty()) break;
                                                for (Map.Entry entry : BHelper.this.bOperationCallbackMap.entrySet()) {
                                                    BOperationCallback callback = (BOperationCallback)entry.getValue();
                                                    if (callback == null) continue;
                                                    callback.onDisabled();
                                                }
                                                break;
                                            }
                                        }
                                        break block27;
                                    }
                                    if (action.equals("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED")) {
                                        int newConnState = intent.getIntExtra("android.bluetooth.adapter.extra.CONNECTION_STATE", 0);
                                        int oldConnState = intent.getIntExtra("android.bluetooth.adapter.extra.PREVIOUS_CONNECTION_STATE", 0);
                                        BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                                        HashMap map = BHelper.this.parseDevice2Map(device);
                                        switch (newConnState) {
                                            case 1: {
                                                break;
                                            }
                                            case 2: {
                                                if (BHelper.this.bOperationCallbackMap == null || BHelper.this.bOperationCallbackMap.isEmpty()) break;
                                                for (Map.Entry entry : BHelper.this.bOperationCallbackMap.entrySet()) {
                                                    BOperationCallback callback = (BOperationCallback)entry.getValue();
                                                    if (callback == null) continue;
                                                    callback.onConnectionChanged(true, map);
                                                }
                                                break block27;
                                            }
                                            case 3: {
                                                break;
                                            }
                                            case 0: {
                                                if (BHelper.this.bOperationCallbackMap == null || BHelper.this.bOperationCallbackMap.isEmpty()) break;
                                                for (Map.Entry entry : BHelper.this.bOperationCallbackMap.entrySet()) {
                                                    BOperationCallback callback = (BOperationCallback)entry.getValue();
                                                    if (callback == null) continue;
                                                    callback.onConnectionChanged(false, map);
                                                }
                                                break;
                                            }
                                        }
                                        break block27;
                                    }
                                    if (action.equals("android.bluetooth.device.action.ACL_CONNECTED")) {
                                        BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                                        HashMap map = BHelper.this.parseDevice2Map(device);
                                        if (BHelper.this.bOperationCallbackMap != null && !BHelper.this.bOperationCallbackMap.isEmpty()) {
                                            for (Map.Entry entry : BHelper.this.bOperationCallbackMap.entrySet()) {
                                                BOperationCallback callback = (BOperationCallback)entry.getValue();
                                                if (callback == null) continue;
                                                callback.onDeviceConnected(map);
                                            }
                                        }
                                    } else if (action.equals("android.bluetooth.device.action.ACL_DISCONNECTED")) {
                                        BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                                        HashMap map = BHelper.this.parseDevice2Map(device);
                                        if (BHelper.this.bOperationCallbackMap != null && !BHelper.this.bOperationCallbackMap.isEmpty()) {
                                            for (Map.Entry entry : BHelper.this.bOperationCallbackMap.entrySet()) {
                                                BOperationCallback callback = (BOperationCallback)entry.getValue();
                                                if (callback == null) continue;
                                                callback.onDeviceDisconnected(map);
                                            }
                                        }
                                    }
                                }
                                catch (Throwable t) {
                                    MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
                                }
                            }
                        }
                    };
                    IntentFilter filter = new IntentFilter();
                    filter.addAction("android.bluetooth.adapter.action.STATE_CHANGED");
                    filter.addAction("android.bluetooth.adapter.action.CONNECTION_STATE_CHANGED");
                    filter.addAction("android.bluetooth.device.action.ACL_CONNECTED");
                    filter.addAction("android.bluetooth.device.action.ACL_DISCONNECTED");
                    ReflectHelper.invokeInstanceMethod((Object)this.context, "registerReceiver", new Object[]{this.bOperationReceiver, filter}, new Class[]{BroadcastReceiver.class, IntentFilter.class});
                    this.bOperationRegistered = true;
                }
                catch (Throwable t) {
                    MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
                }
            }
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void open() {
        try {
            if (DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH") && DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH_ADMIN")) {
                BluetoothAdapter adapter = this.getBAdapter();
                adapter.enable();
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public boolean isEnabled() {
        boolean enabled = false;
        try {
            BluetoothAdapter adapter;
            if (DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH") && (adapter = this.getBAdapter()) != null && adapter.isEnabled()) {
                enabled = true;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
        }
        return enabled;
    }

    @SuppressLint(value={"MissingPermission"})
    public ArrayList<HashMap<String, Object>> getBondedDevice() {
        ArrayList<HashMap<String, Object>> result = new ArrayList<HashMap<String, Object>>();
        try {
            BluetoothAdapter adapter;
            Set pairedDevices;
            if (DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH") && (pairedDevices = (adapter = this.getBAdapter()).getBondedDevices()).size() > 0) {
                for (BluetoothDevice device : pairedDevices) {
                    HashMap<String, Object> deviceInfo = this.parseDevice2Map(device);
                    deviceInfo.put("__currConnected", this.isConnectedDevice(device) ? 1 : 0);
                    result.add(deviceInfo);
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
        }
        return result;
    }

    public boolean isConnectedDevice(BluetoothDevice device) {
        boolean isConnected = false;
        if (device != null) {
            try {
                Boolean result;
                if (DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH") && (result = (Boolean)ReflectHelper.invokeInstanceMethod((Object)device, Strings.getString(115), new Object[0])) != null) {
                    isConnected = result;
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
        }
        return isConnected;
    }

    @SuppressLint(value={"MissingPermission"})
    public void findLEAndClassic(int scanInterval, final BScanCallback bScanCallback) {
        try {
            if (DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH") && DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH_ADMIN")) {
                final BluetoothAdapter adapter = this.getBAdapter();
                if (!adapter.isEnabled()) {
                    bScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
                    return;
                }
                if (this.mScanning) {
                    bScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
                    return;
                }
                int defaultInterval = 6;
                if (scanInterval <= 0) {
                    scanInterval = 6;
                }
                final Handler handler = MobHandlerThread.newHandler(new Handler.Callback(){

                    public boolean handleMessage(Message msg) {
                        adapter.cancelDiscovery();
                        return false;
                    }
                });
                handler.sendEmptyMessageDelayed(0, (long)(scanInterval * 1000));
                final ArrayList scanResult = new ArrayList();
                this.bScanReceiver = new BroadcastReceiver(){

                    public void onReceive(Context context, Intent intent) {
                        try {
                            String action = intent.getAction();
                            if (action.equals("android.bluetooth.device.action.FOUND")) {
                                BluetoothDevice device = (BluetoothDevice)intent.getParcelableExtra("android.bluetooth.device.extra.DEVICE");
                                HashMap map = BHelper.this.parseDevice2Map(device);
                                short defaultValue = 0;
                                short rssi = intent.getShortExtra("android.bluetooth.device.extra.RSSI", defaultValue);
                                map.put("rssi", rssi);
                                scanResult.add(map);
                            } else if (action.equals("android.bluetooth.adapter.action.DISCOVERY_STARTED")) {
                                MobLog.getInstance().d("started", new Object[0]);
                            } else if (action.equals("android.bluetooth.adapter.action.DISCOVERY_FINISHED")) {
                                MobLog.getInstance().d("done", new Object[0]);
                                BHelper.this.mScanning = false;
                                bScanCallback.onScan(scanResult);
                                handler.removeMessages(0);
                                BHelper.this.unRegisterBScanReceiver();
                            }
                        }
                        catch (Throwable t) {
                            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
                        }
                    }
                };
                IntentFilter filter = new IntentFilter();
                filter.addAction("android.bluetooth.device.action.FOUND");
                filter.addAction("android.bluetooth.adapter.action.DISCOVERY_STARTED");
                filter.addAction("android.bluetooth.adapter.action.DISCOVERY_FINISHED");
                ReflectHelper.invokeInstanceMethod((Object)this.context, "registerReceiver", new Object[]{this.bScanReceiver, filter}, new Class[]{BroadcastReceiver.class, IntentFilter.class});
                this.bScanRegistered = true;
                this.mScanning = true;
                adapter.startDiscovery();
            } else {
                bScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
            bScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
        }
    }

    public void unRegisterBScanReceiver() {
        try {
            if (this.bScanReceiver != null && this.bScanRegistered) {
                ReflectHelper.invokeInstanceMethod((Object)this.context, "unregisterReceiver", new Object[]{this.bScanReceiver}, new Class[]{BroadcastReceiver.class});
                this.bScanRegistered = false;
                this.bScanReceiver = null;
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
        }
    }

    @SuppressLint(value={"MissingPermission"})
    public void findLE(int scanInterval, final BluetoothAdapter adapter, final BScanCallback bScanCallback) {
        try {
            if (DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH") && DeviceHelper.getInstance(this.context).checkPermission("android.permission.BLUETOOTH_ADMIN")) {
                if (!adapter.isEnabled()) {
                    bScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
                    return;
                }
                if (this.mScanning) {
                    bScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
                    return;
                }
                int defaultInterval = 6;
                if (scanInterval <= 0) {
                    scanInterval = 6;
                }
                if (Build.VERSION.SDK_INT >= 18) {
                    final ArrayList scanResult = new ArrayList();
                    if (Build.VERSION.SDK_INT < 21) {
                        final BluetoothAdapter.LeScanCallback leScanCallback = new BluetoothAdapter.LeScanCallback(){

                            public void onLeScan(BluetoothDevice device, int rssi, byte[] scanRecord) {
                                try {
                                    HashMap map = BHelper.this.parseDevice2Map(device);
                                    map.put("rssi", rssi);
                                    scanResult.add(map);
                                }
                                catch (Throwable t) {
                                    MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
                                }
                            }
                        };
                        this.mScanning = true;
                        adapter.startLeScan(leScanCallback);
                        Handler handler = MobHandlerThread.newHandler(new Handler.Callback(){

                            public boolean handleMessage(Message msg) {
                                BHelper.this.mScanning = false;
                                adapter.stopLeScan(leScanCallback);
                                bScanCallback.onScan(scanResult);
                                return false;
                            }
                        });
                        handler.sendEmptyMessageDelayed(0, (long)(scanInterval * 1000));
                    } else {
                        final ScanCallback mScanCallback = new ScanCallback(){

                            public void onScanResult(int callbackType, ScanResult result) {
                                super.onScanResult(callbackType, result);
                                if (result != null) {
                                    HashMap map = new HashMap();
                                    BluetoothDevice device = result.getDevice();
                                    if (device != null) {
                                        map = BHelper.this.parseDevice2Map(device);
                                    }
                                    map.put("rssi", result.getRssi());
                                    ScanRecord scanRecord = result.getScanRecord();
                                    scanResult.add(map);
                                }
                            }

                            public void onBatchScanResults(List<ScanResult> results) {
                                super.onBatchScanResults(results);
                            }

                            public void onScanFailed(int errorCode) {
                                super.onScanFailed(errorCode);
                            }
                        };
                        final BluetoothLeScanner mBLEScanner = adapter.getBluetoothLeScanner();
                        this.mScanning = true;
                        mBLEScanner.startScan(mScanCallback);
                        Handler handler = MobHandlerThread.newHandler(new Handler.Callback(){

                            public boolean handleMessage(Message msg) {
                                BHelper.this.mScanning = false;
                                mBLEScanner.stopScan(mScanCallback);
                                bScanCallback.onScan(scanResult);
                                return false;
                            }
                        });
                        handler.sendEmptyMessageDelayed(0, (long)(scanInterval * 1000));
                    }
                } else {
                    this.findLEAndClassic(scanInterval, bScanCallback);
                }
            } else {
                bScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
            bScanCallback.onScan(new ArrayList<HashMap<String, Object>>());
        }
    }

    private BluetoothAdapter getBAdapter() {
        BluetoothAdapter adapter = null;
        try {
            if (Build.VERSION.SDK_INT >= 18) {
                BluetoothManager manager = (BluetoothManager)DeviceHelper.getInstance(this.context).getSystemServiceSafe("bluetooth");
                adapter = manager.getAdapter();
            } else {
                adapter = BluetoothAdapter.getDefaultAdapter();
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t, (Object)(t.getMessage() + ""), new Object[0]);
        }
        return adapter;
    }

    @SuppressLint(value={"MissingPermission"})
    private HashMap<String, Object> parseDevice2Map(BluetoothDevice device) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (device != null) {
            try {
                map.put("name", device.getName());
                map.put("address", device.getAddress());
                map.put("bondState", device.getBondState());
                BluetoothClass btClass = device.getBluetoothClass();
                int majorClass = btClass.getMajorDeviceClass();
                int deviceClass = btClass.getDeviceClass();
                map.put("majorClass", majorClass);
                map.put("deviceClass", deviceClass);
                if (Build.VERSION.SDK_INT >= 18) {
                    map.put("type", device.getType());
                }
                if (Build.VERSION.SDK_INT >= 15 && device.getBondState() == 12) {
                    ArrayList<String> uuids = new ArrayList<String>();
                    ParcelUuid[] parcelUuids = device.getUuids();
                    if (parcelUuids != null && parcelUuids.length > 0) {
                        for (ParcelUuid parcelUuid : parcelUuids) {
                            if (parcelUuid == null || parcelUuid.getUuid() == null) continue;
                            uuids.add(parcelUuid.getUuid().toString());
                        }
                    }
                    map.put("uuids", uuids);
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().d(t);
            }
        }
        return map;
    }

    public static interface BScanCallback {
        public void onScan(ArrayList<HashMap<String, Object>> var1);
    }

    public static class BOperationCallback {
        protected void onEnabled() {
        }

        protected void onDisabled() {
        }

        protected void onConnectionChanged(boolean connect, HashMap<String, Object> btDevice) {
        }

        protected void onDeviceConnected(HashMap<String, Object> btDevice) {
        }

        protected void onDeviceDisconnected(HashMap<String, Object> btDevice) {
        }
    }
}

