/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import android.content.Context;
import android.media.AudioManager;
import com.mob.tools.MobLog;

public class AudioHelper {
    public static final int SYSTEM_RING = 1;
    public static final int CALL_RING = 2;
    public static final int MEDIA_RING = 3;
    public static final int ALARM_RING = 4;
    private static AudioHelper audioHelper;
    private AudioManager audioManager;
    private Context context;
    private int currentCommonVoice;
    private int currentMediaVoice;
    private int currentRingVoice;
    private int currentAlarmVoice;

    public static AudioHelper getInstance(Context context) {
        if (audioHelper == null) {
            audioHelper = new AudioHelper(context);
        }
        return audioHelper;
    }

    private AudioHelper(Context context) {
        this.context = context.getApplicationContext();
        this.audioManager = (AudioManager)this.context.getSystemService("audio");
    }

    public int getAudioMode() {
        try {
            int mode = this.audioManager.getRingerMode();
            switch (mode) {
                case 0: {
                    return 0;
                }
                case 1: {
                    return 1;
                }
                case 2: {
                    return 2;
                }
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
        return 2;
    }

    private void getVioce() {
        int alarmVoice;
        int mediaVoice;
        int ringVoice;
        int systemVoice = this.audioManager.getStreamVolume(1);
        if (systemVoice > 0) {
            this.currentCommonVoice = systemVoice;
        }
        if ((ringVoice = this.audioManager.getStreamVolume(2)) > 0) {
            this.currentRingVoice = ringVoice;
        }
        if ((mediaVoice = this.audioManager.getStreamVolume(3)) > 0) {
            this.currentMediaVoice = mediaVoice;
        }
        if ((alarmVoice = this.audioManager.getStreamVolume(4)) > 0) {
            this.currentAlarmVoice = alarmVoice;
        }
        MobLog.getInstance().d("System Ring\uff1a" + systemVoice + " Call Ring\uff1a" + ringVoice + " Media Ring\uff1a" + mediaVoice + "Alarm Ring\uff1a" + alarmVoice, new Object[0]);
    }

    public void setQuietMode(int type) {
        try {
            this.getVioce();
            if (this.audioManager.getStreamVolume(type) == 0) {
                return;
            }
            this.audioManager.setStreamVolume(type, 0, 8);
        }
        catch (Throwable t) {
            MobLog.getInstance().w(t);
        }
    }

    public void setSilentMode() {
        this.audioManager.setStreamVolume(2, 0, 8);
        this.audioManager.setRingerMode(0);
    }

    public void recoveryVoice(int type) {
        this.audioManager.setStreamVolume(type, this.getLastVoice(type), 8);
    }

    public void addVoice(int type, int direction) {
        this.audioManager.adjustStreamVolume(type, direction, 8);
    }

    private int getLastVoice(int type) {
        int voice = 0;
        if (type == 1) {
            voice = this.currentCommonVoice;
        } else if (type == 3) {
            voice = this.currentMediaVoice;
        } else if (type == 2) {
            voice = this.currentRingVoice;
        } else if (type == 4) {
            voice = this.currentAlarmVoice;
        }
        MobLog.getInstance().d("Voice Type:" + type + "Last Count:" + voice, new Object[0]);
        return voice;
    }

    public boolean checkMusicActivity() {
        boolean isMusic = this.audioManager.isMusicActive();
        MobLog.getInstance().d("Music Action:" + isMusic, new Object[0]);
        return isMusic;
    }
}

