/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.network;

import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import com.mob.tools.MobLog;
import com.mob.tools.network.ByteArrayPart;
import com.mob.tools.network.FileDownloadListener;
import com.mob.tools.network.FilePart;
import com.mob.tools.network.HTTPPart;
import com.mob.tools.network.HttpConnection;
import com.mob.tools.network.HttpConnectionImpl;
import com.mob.tools.network.HttpConnectionImpl23;
import com.mob.tools.network.HttpResponseCallback;
import com.mob.tools.network.KVPair;
import com.mob.tools.network.MultiPart;
import com.mob.tools.network.OnReadListener;
import com.mob.tools.network.RawNetworkCallback;
import com.mob.tools.network.SSLSocketFactoryEx;
import com.mob.tools.network.StringPart;
import com.mob.tools.utils.Data;
import com.mob.tools.utils.Hashon;
import com.mob.tools.utils.ReflectHelper;
import com.mob.tools.utils.ResHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.conn.ssl.X509HostnameVerifier;

public class NetworkHelper {
    public static int connectionTimeout;
    public static int readTimout;
    protected boolean instanceFollowRedirects = followRedirects;
    private static boolean followRedirects;

    public String httpGet(String url, ArrayList<KVPair<String>> values, ArrayList<KVPair<String>> headers, NetworkTimeOut timeout) throws Throwable {
        BufferedReader br;
        StringBuilder sb;
        String param;
        long time = System.currentTimeMillis();
        MobLog.getInstance().i("httpGet: " + url, new Object[0]);
        if (values != null && (param = this.kvPairsToUrl(values)).length() > 0) {
            url = url + "?" + param;
        }
        HttpURLConnection conn = this.getConnection(url, timeout);
        if (headers != null) {
            for (KVPair<String> header : headers) {
                conn.setRequestProperty(header.name, (String)header.value);
            }
        }
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        conn.connect();
        String resp = null;
        int status = conn.getResponseCode();
        if (status == 200) {
            sb = new StringBuilder();
            InputStreamReader isr = new InputStreamReader(conn.getInputStream(), Charset.forName("utf-8"));
            br = new BufferedReader(isr);
            String txt = br.readLine();
            while (txt != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(txt);
                txt = br.readLine();
            }
        } else {
            StringBuilder sb2 = new StringBuilder();
            InputStreamReader isr = new InputStreamReader(conn.getErrorStream(), Charset.forName("utf-8"));
            BufferedReader br2 = new BufferedReader(isr);
            String txt = br2.readLine();
            while (txt != null) {
                if (sb2.length() > 0) {
                    sb2.append('\n');
                }
                sb2.append(txt);
                txt = br2.readLine();
            }
            br2.close();
            conn.disconnect();
            HashMap<String, Object> errMap = new HashMap<String, Object>();
            errMap.put("error", sb2.toString());
            errMap.put("status", status);
            throw new Throwable(new Hashon().fromHashMap(errMap));
        }
        br.close();
        conn.disconnect();
        resp = sb.toString();
        MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
        return resp;
    }

    public void download(String url, final OutputStream os, NetworkTimeOut timeout) throws Throwable {
        final byte[] buf = new byte[1024];
        this.rawGet(url, new RawNetworkCallback(){

            @Override
            public void onResponse(InputStream is) throws Throwable {
                int len = is.read(buf);
                while (len != -1) {
                    os.write(buf, 0, len);
                    len = is.read(buf);
                }
            }
        }, timeout);
        os.flush();
    }

    public String downloadCache(Context context, String url, String cacheFolder, boolean skipIfCached, NetworkTimeOut timeout) throws Throwable {
        return this.downloadCache(context, url, cacheFolder, skipIfCached, timeout, null);
    }

    public String downloadCache(Context context, String url, String cacheFolder, boolean skipIfCached, NetworkTimeOut timeout, FileDownloadListener downloadListener) throws Throwable {
        long time = System.currentTimeMillis();
        MobLog.getInstance().i("downloading: " + url, new Object[0]);
        if (skipIfCached) {
            String path = ResHelper.getCachePath(context, cacheFolder);
            String name = Data.MD5(url);
            File cache = new File(path, name);
            if (skipIfCached && cache.exists()) {
                MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
                if (downloadListener != null) {
                    downloadListener.onProgress(100, cache.length(), cache.length());
                }
                return cache.getAbsolutePath();
            }
        }
        HttpURLConnection conn = this.getConnection(url, timeout);
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        conn.connect();
        int status = conn.getResponseCode();
        if (status == 200) {
            String value;
            List<String> headers;
            String name = null;
            Map<String, List<String>> map = conn.getHeaderFields();
            if (map != null && (headers = map.get("Content-Disposition")) != null && headers.size() > 0) {
                String[] parts;
                value = headers.get(0);
                for (String part : parts = value.split(";")) {
                    if (!part.trim().startsWith("filename") || !(name = part.split("=")[1]).startsWith("\"") || !name.endsWith("\"")) continue;
                    name = name.substring(1, name.length() - 1);
                }
            }
            if (name == null) {
                name = Data.MD5(url);
                if (map != null && (headers = map.get("Content-Type")) != null && headers.size() > 0) {
                    value = headers.get(0);
                    String string = value = value == null ? "" : value.trim();
                    if (value.startsWith("image/")) {
                        String type = value.substring("image/".length());
                        name = name + "." + ("jpeg".equals(type) ? "jpg" : type);
                    } else {
                        int dot;
                        int index = url.lastIndexOf(47);
                        String lastPart = null;
                        if (index > 0) {
                            lastPart = url.substring(index + 1);
                        }
                        if (lastPart != null && lastPart.length() > 0 && (dot = lastPart.lastIndexOf(46)) > 0 && lastPart.length() - dot < 10) {
                            name = name + lastPart.substring(dot);
                        }
                    }
                }
            }
            String path = ResHelper.getCachePath(context, cacheFolder);
            File cache = new File(path, name);
            if (skipIfCached && cache.exists()) {
                conn.disconnect();
                MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
                if (downloadListener != null) {
                    downloadListener.onProgress(100, cache.length(), cache.length());
                }
                return cache.getAbsolutePath();
            }
            if (!cache.getParentFile().exists()) {
                cache.getParentFile().mkdirs();
            }
            if (cache.exists()) {
                cache.delete();
            }
            try {
                if (downloadListener != null && downloadListener.isCanceled()) {
                    if (cache.exists()) {
                        cache.delete();
                    }
                    return null;
                }
                InputStream is = conn.getInputStream();
                int contentLength = conn.getContentLength();
                FileOutputStream fos = new FileOutputStream(cache);
                byte[] buf = new byte[1024];
                int downloadLength = 0;
                int len = is.read(buf);
                while (len > 0) {
                    fos.write(buf, 0, len);
                    downloadLength += len;
                    if (downloadListener != null) {
                        downloadListener.onProgress(contentLength <= 0 ? 100 : downloadLength * 100 / contentLength, downloadLength, contentLength);
                        if (downloadListener.isCanceled()) break;
                    }
                    len = is.read(buf);
                }
                if (downloadListener != null) {
                    if (downloadListener.isCanceled()) {
                        if (cache.exists()) {
                            cache.delete();
                        }
                        fos.flush();
                        is.close();
                        fos.close();
                        return null;
                    }
                    downloadListener.onProgress(100, cache.length(), cache.length());
                }
                fos.flush();
                is.close();
                fos.close();
            }
            catch (Throwable t) {
                if (cache.exists()) {
                    cache.delete();
                }
                throw t;
            }
            conn.disconnect();
            MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
            return cache.getAbsolutePath();
        }
        StringBuilder sb = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(conn.getErrorStream(), Charset.forName("utf-8"));
        BufferedReader br = new BufferedReader(isr);
        String txt = br.readLine();
        while (txt != null) {
            if (sb.length() > 0) {
                sb.append('\n');
            }
            sb.append(txt);
            txt = br.readLine();
        }
        br.close();
        conn.disconnect();
        HashMap<String, Object> errMap = new HashMap<String, Object>();
        errMap.put("error", sb.toString());
        errMap.put("status", status);
        throw new Throwable(new Hashon().fromHashMap(errMap));
    }

    public void rawGet(String url, RawNetworkCallback callback, NetworkTimeOut timeout) throws Throwable {
        this.rawGet(url, null, callback, timeout);
    }

    public void rawGet(String url, ArrayList<KVPair<String>> headers, RawNetworkCallback callback, NetworkTimeOut timeout) throws Throwable {
        long time = System.currentTimeMillis();
        MobLog.getInstance().i("rawGet: " + url, new Object[0]);
        HttpURLConnection conn = this.getConnection(url, timeout);
        if (headers != null) {
            for (KVPair<String> header : headers) {
                conn.setRequestProperty(header.name, (String)header.value);
            }
        }
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        conn.connect();
        int status = conn.getResponseCode();
        if (status == 200) {
            if (callback != null) {
                callback.onResponse(conn.getInputStream());
            }
        } else {
            StringBuilder sb = new StringBuilder();
            InputStreamReader isr = new InputStreamReader(conn.getErrorStream(), Charset.forName("utf-8"));
            BufferedReader br = new BufferedReader(isr);
            String txt = br.readLine();
            while (txt != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(txt);
                txt = br.readLine();
            }
            br.close();
            conn.disconnect();
            HashMap<String, Object> errMap = new HashMap<String, Object>();
            errMap.put("error", sb.toString());
            errMap.put("status", status);
            throw new Throwable(new Hashon().fromHashMap(errMap));
        }
        conn.disconnect();
        MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
    }

    public void rawGet(String url, HttpResponseCallback callback, NetworkTimeOut timeout) throws Throwable {
        this.rawGet(url, null, callback, timeout);
    }

    public void rawGet(String url, ArrayList<KVPair<String>> headers, HttpResponseCallback callback, NetworkTimeOut timeout) throws Throwable {
        long time = System.currentTimeMillis();
        MobLog.getInstance().i("rawGet: " + url, new Object[0]);
        HttpURLConnection conn = this.getConnection(url, timeout);
        if (headers != null) {
            for (KVPair<String> header : headers) {
                conn.setRequestProperty(header.name, (String)header.value);
            }
        }
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        conn.connect();
        if (conn.getResponseCode() == 301) {
            String location = conn.getHeaderField("Location");
            this.rawGet(location, null, callback, timeout);
        } else if (callback != null) {
            try {
                callback.onResponse(new HttpConnectionImpl23(conn));
            }
            catch (Throwable t) {
                throw t;
            }
            finally {
                conn.disconnect();
            }
        } else {
            conn.disconnect();
        }
        MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
    }

    public String jsonPost(String url, ArrayList<KVPair<String>> values, ArrayList<KVPair<String>> headers, NetworkTimeOut timeout) throws Throwable {
        String resp = null;
        final HashMap map = new HashMap();
        this.jsonPost(url, values, headers, timeout, new HttpResponseCallback(){

            @Override
            public void onResponse(HttpConnection conn) throws Throwable {
                BufferedReader br;
                StringBuilder sb;
                int status = conn.getResponseCode();
                if (status == 200 || status == 201) {
                    sb = new StringBuilder();
                    InputStreamReader isr = new InputStreamReader(conn.getInputStream(), Charset.forName("utf-8"));
                    br = new BufferedReader(isr);
                    String txt = br.readLine();
                    while (txt != null) {
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append(txt);
                        txt = br.readLine();
                    }
                } else {
                    StringBuilder sb2 = new StringBuilder();
                    InputStreamReader isr = new InputStreamReader(conn.getErrorStream(), Charset.forName("utf-8"));
                    BufferedReader br2 = new BufferedReader(isr);
                    String txt = br2.readLine();
                    while (txt != null) {
                        if (sb2.length() > 0) {
                            sb2.append('\n');
                        }
                        sb2.append(txt);
                        txt = br2.readLine();
                    }
                    br2.close();
                    HashMap<String, Object> errMap = new HashMap<String, Object>();
                    errMap.put("error", sb2.toString());
                    errMap.put("status", status);
                    throw new Throwable(new Hashon().fromHashMap(errMap));
                }
                br.close();
                map.put("res", sb.toString());
            }
        });
        if (map.containsKey("res")) {
            resp = (String)map.get("res");
        }
        return resp;
    }

    public void jsonPost(String url, ArrayList<KVPair<String>> values, ArrayList<KVPair<String>> headers, NetworkTimeOut timeout, HttpResponseCallback callback) throws Throwable {
        HashMap<String, Object> valuesMap = new HashMap<String, Object>();
        for (KVPair<String> p : values) {
            valuesMap.put(p.name, p.value);
        }
        this.jsonPost(url, valuesMap, headers, timeout, callback);
    }

    public void jsonPost(String url, HashMap<String, Object> values, ArrayList<KVPair<String>> headers, NetworkTimeOut timeout, HttpResponseCallback callback) throws Throwable {
        long time = System.currentTimeMillis();
        MobLog.getInstance().i("jsonPost: " + url, new Object[0]);
        HttpURLConnection conn = this.getConnection(url, timeout);
        conn.setDoOutput(true);
        conn.setChunkedStreamingMode(0);
        conn.setRequestProperty("content-type", "application/json");
        if (headers != null) {
            for (KVPair<String> header : headers) {
                conn.setRequestProperty(header.name, (String)header.value);
            }
        }
        StringPart sp = new StringPart();
        if (values != null) {
            sp.append(new Hashon().fromHashMap(values));
        }
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        conn.connect();
        OutputStream os = conn.getOutputStream();
        InputStream is = sp.toInputStream();
        byte[] buf = new byte[65536];
        int len = is.read(buf);
        while (len > 0) {
            os.write(buf, 0, len);
            len = is.read(buf);
        }
        os.flush();
        is.close();
        os.close();
        if (callback != null) {
            try {
                callback.onResponse(new HttpConnectionImpl23(conn));
            }
            catch (Throwable t) {
                throw t;
            }
            finally {
                conn.disconnect();
            }
        } else {
            conn.disconnect();
        }
        MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
    }

    public String httpPost(String url, ArrayList<KVPair<String>> values, KVPair<String> file, ArrayList<KVPair<String>> headers, NetworkTimeOut timeout) throws Throwable {
        return this.httpPost(url, values, file, headers, 0, timeout);
    }

    public String httpPost(String url, ArrayList<KVPair<String>> values, KVPair<String> file, ArrayList<KVPair<String>> headers, int chunkLength, NetworkTimeOut timeout) throws Throwable {
        ArrayList<KVPair<String>> files = new ArrayList<KVPair<String>>();
        if (file != null && file.value != null && new File((String)file.value).exists()) {
            files.add(file);
        }
        return this.httpPostFiles(url, values, files, headers, chunkLength, timeout);
    }

    public String httpPostFiles(String url, ArrayList<KVPair<String>> values, ArrayList<KVPair<String>> files, ArrayList<KVPair<String>> headers, NetworkTimeOut timeout) throws Throwable {
        return this.httpPostFiles(url, values, files, headers, 0, timeout);
    }

    public String httpPostFiles(String url, ArrayList<KVPair<String>> values, ArrayList<KVPair<String>> files, ArrayList<KVPair<String>> headers, int chunkLength, NetworkTimeOut timeout) throws Throwable {
        final HashMap tmpMap = new HashMap();
        this.httpPost(url, values, files, headers, chunkLength, new HttpResponseCallback(){

            @Override
            public void onResponse(HttpConnection conn) throws Throwable {
                BufferedReader br;
                StringBuilder sb;
                int status = conn.getResponseCode();
                if (status == 200 || status < 300) {
                    sb = new StringBuilder();
                    InputStreamReader isr = new InputStreamReader(conn.getInputStream(), Charset.forName("utf-8"));
                    br = new BufferedReader(isr);
                    String txt = br.readLine();
                    while (txt != null) {
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append(txt);
                        txt = br.readLine();
                    }
                } else {
                    StringBuilder sb2 = new StringBuilder();
                    InputStreamReader isr = new InputStreamReader(conn.getErrorStream(), Charset.forName("utf-8"));
                    BufferedReader br2 = new BufferedReader(isr);
                    String txt = br2.readLine();
                    while (txt != null) {
                        if (sb2.length() > 0) {
                            sb2.append('\n');
                        }
                        sb2.append(txt);
                        txt = br2.readLine();
                    }
                    br2.close();
                    HashMap<String, Object> errMap = new HashMap<String, Object>();
                    errMap.put("error", sb2.toString());
                    errMap.put("status", status);
                    throw new Throwable(new Hashon().fromHashMap(errMap));
                }
                br.close();
                tmpMap.put("resp", sb.toString());
            }
        }, timeout);
        return (String)tmpMap.get("resp");
    }

    public String httpPostFilesChecked(String url, ArrayList<KVPair<String>> values, byte[] data, ArrayList<KVPair<String>> headers, int chunkLength, NetworkTimeOut timeout) throws Throwable {
        final HashMap tmpMap = new HashMap();
        this.httpPost(url, values, data, headers, chunkLength, new HttpResponseCallback(){

            @Override
            public void onResponse(HttpConnection conn) throws Throwable {
                BufferedReader br;
                StringBuilder sb;
                int status = conn.getResponseCode();
                if (status == 200 || status < 300) {
                    sb = new StringBuilder();
                    InputStreamReader isr = new InputStreamReader(conn.getInputStream(), Charset.forName("utf-8"));
                    br = new BufferedReader(isr);
                    String txt = br.readLine();
                    while (txt != null) {
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append(txt);
                        txt = br.readLine();
                    }
                } else {
                    StringBuilder sb2 = new StringBuilder();
                    InputStreamReader isr = new InputStreamReader(conn.getErrorStream(), Charset.forName("utf-8"));
                    BufferedReader br2 = new BufferedReader(isr);
                    String txt = br2.readLine();
                    while (txt != null) {
                        if (sb2.length() > 0) {
                            sb2.append('\n');
                        }
                        sb2.append(txt);
                        txt = br2.readLine();
                    }
                    br2.close();
                    HashMap<String, Object> errMap = new HashMap<String, Object>();
                    errMap.put("error", sb2.toString());
                    errMap.put("status", status);
                    throw new Throwable(new Hashon().fromHashMap(errMap));
                }
                br.close();
                tmpMap.put("resp", sb.toString());
            }
        }, timeout);
        return (String)tmpMap.get("resp");
    }

    public String httpPost(String url, ArrayList<KVPair<String>> headers, int chunkLength, NetworkTimeOut timeout) throws Throwable {
        final HashMap tmpMap = new HashMap();
        this.httpPost(url, headers, chunkLength, new HttpResponseCallback(){

            @Override
            public void onResponse(HttpConnection conn) throws Throwable {
                BufferedReader br;
                StringBuilder sb;
                int status = conn.getResponseCode();
                if (status == 200 || status < 300) {
                    sb = new StringBuilder();
                    InputStreamReader isr = new InputStreamReader(conn.getInputStream(), Charset.forName("utf-8"));
                    br = new BufferedReader(isr);
                    String txt = br.readLine();
                    while (txt != null) {
                        if (sb.length() > 0) {
                            sb.append('\n');
                        }
                        sb.append(txt);
                        txt = br.readLine();
                    }
                } else {
                    StringBuilder sb2 = new StringBuilder();
                    InputStreamReader isr = new InputStreamReader(conn.getErrorStream(), Charset.forName("utf-8"));
                    BufferedReader br2 = new BufferedReader(isr);
                    String txt = br2.readLine();
                    while (txt != null) {
                        if (sb2.length() > 0) {
                            sb2.append('\n');
                        }
                        sb2.append(txt);
                        txt = br2.readLine();
                    }
                    br2.close();
                    HashMap<String, Object> errMap = new HashMap<String, Object>();
                    errMap.put("error", sb2.toString());
                    errMap.put("status", status);
                    throw new Throwable(new Hashon().fromHashMap(errMap));
                }
                br.close();
                tmpMap.put("resp", sb.toString());
            }
        }, timeout);
        return (String)tmpMap.get("resp");
    }

    public void httpPost(String url, ArrayList<KVPair<String>> values, ArrayList<KVPair<String>> files, ArrayList<KVPair<String>> headers, HttpResponseCallback callback, NetworkTimeOut timeout) throws Throwable {
        this.httpPost(url, values, files, headers, 0, callback, timeout);
    }

    public void httpPost(String url, ArrayList<KVPair<String>> values, ArrayList<KVPair<String>> files, ArrayList<KVPair<String>> headers, int chunkLength, HttpResponseCallback callback, NetworkTimeOut timeout) throws Throwable {
        HTTPPart part;
        long time = System.currentTimeMillis();
        MobLog.getInstance().i("httpPost: " + url, new Object[0]);
        HttpURLConnection conn = this.getConnection(url, timeout);
        conn.setDoOutput(true);
        conn.setRequestProperty("Connection", "Keep-Alive");
        if (files != null && files.size() > 0) {
            part = this.getFilePostHTTPPart(conn, url, values, files);
            if (chunkLength >= 0) {
                conn.setChunkedStreamingMode(chunkLength);
            }
        } else {
            part = this.getTextPostHTTPPart(conn, url, values);
            conn.setFixedLengthStreamingMode((int)part.length());
        }
        if (headers != null) {
            for (KVPair<String> header : headers) {
                conn.setRequestProperty(header.name, (String)header.value);
            }
        }
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        conn.connect();
        OutputStream os = conn.getOutputStream();
        InputStream is = part.toInputStream();
        byte[] buf = new byte[65536];
        int len = is.read(buf);
        while (len > 0) {
            os.write(buf, 0, len);
            len = is.read(buf);
        }
        os.flush();
        is.close();
        os.close();
        if (callback != null) {
            try {
                callback.onResponse(new HttpConnectionImpl23(conn));
            }
            catch (Throwable t) {
                throw t;
            }
            finally {
                conn.disconnect();
            }
        } else {
            conn.disconnect();
        }
        MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
    }

    public void httpPost(String url, ArrayList<KVPair<String>> values, byte[] data, ArrayList<KVPair<String>> headers, int chunkLength, HttpResponseCallback callback, NetworkTimeOut timeout) throws Throwable {
        HTTPPart part;
        long time = System.currentTimeMillis();
        MobLog.getInstance().i("httpPost: " + url, new Object[0]);
        HttpURLConnection conn = this.getConnection(url, timeout);
        conn.setDoOutput(true);
        conn.setRequestProperty("Connection", "Keep-Alive");
        if (data != null && data.length > 0) {
            part = this.getDataPostHttpPart(conn, url, data);
            if (chunkLength >= 0) {
                conn.setChunkedStreamingMode(chunkLength);
            }
        } else {
            part = this.getTextPostHTTPPart(conn, url, values);
            conn.setFixedLengthStreamingMode((int)part.length());
        }
        if (headers != null) {
            for (KVPair<String> header : headers) {
                conn.setRequestProperty(header.name, (String)header.value);
            }
        }
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        conn.connect();
        OutputStream os = conn.getOutputStream();
        InputStream is = part.toInputStream();
        byte[] buf = new byte[65536];
        int len = is.read(buf);
        while (len > 0) {
            os.write(buf, 0, len);
            len = is.read(buf);
        }
        os.flush();
        is.close();
        os.close();
        if (callback != null) {
            try {
                callback.onResponse(new HttpConnectionImpl23(conn));
            }
            catch (Throwable t) {
                throw t;
            }
            finally {
                conn.disconnect();
            }
        } else {
            conn.disconnect();
        }
        MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
    }

    public void httpPost(String url, ArrayList<KVPair<String>> headers, int chunkLength, HttpResponseCallback callback, NetworkTimeOut timeout) throws Throwable {
        long time = System.currentTimeMillis();
        MobLog.getInstance().i("httpPost: " + url, new Object[0]);
        HttpURLConnection conn = this.getConnection(url, timeout);
        conn.setDoOutput(true);
        conn.setRequestProperty("Connection", "Keep-Alive");
        if (headers != null) {
            for (KVPair<String> header : headers) {
                conn.setRequestProperty(header.name, (String)header.value);
            }
        }
        StringPart part = new StringPart();
        part.append(null);
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        conn.connect();
        OutputStream os = conn.getOutputStream();
        InputStream is = part.toInputStream();
        byte[] buf = new byte[65536];
        int len = is.read(buf);
        while (len > 0) {
            os.write(buf, 0, len);
            len = is.read(buf);
        }
        os.flush();
        is.close();
        os.close();
        if (callback != null) {
            try {
                callback.onResponse(new HttpConnectionImpl23(conn));
            }
            catch (Throwable t) {
                throw t;
            }
            finally {
                conn.disconnect();
            }
        } else {
            conn.disconnect();
        }
        MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
    }

    private HTTPPart getDataPostHttpPart(HttpURLConnection conn, String url, byte[] data) throws Throwable {
        ByteArrayPart bytePart = new ByteArrayPart();
        bytePart.append(data);
        return bytePart;
    }

    private HTTPPart getFilePostHTTPPart(HttpURLConnection conn, String url, ArrayList<KVPair<String>> values, ArrayList<KVPair<String>> files) throws Throwable {
        String boundary = UUID.randomUUID().toString();
        conn.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
        MultiPart mp = new MultiPart();
        StringPart sp = new StringPart();
        if (values != null) {
            for (KVPair<String> value : values) {
                sp.append("--").append(boundary).append("\r\n");
                sp.append("Content-Disposition: form-data; name=\"").append(value.name).append("\"\r\n\r\n");
                sp.append((String)value.value).append("\r\n");
            }
        }
        mp.append(sp);
        for (KVPair<String> file : files) {
            sp = new StringPart();
            File imageFile = new File((String)file.value);
            sp.append("--").append(boundary).append("\r\n");
            sp.append("Content-Disposition: form-data; name=\"").append(file.name).append("\"; filename=\"").append(imageFile.getName()).append("\"\r\n");
            String mime = URLConnection.getFileNameMap().getContentTypeFor((String)file.value);
            if (mime == null || mime.length() <= 0) {
                if (((String)file.value).toLowerCase().endsWith("jpg") || ((String)file.value).toLowerCase().endsWith("jpeg")) {
                    mime = "image/jpeg";
                } else if (((String)file.value).toLowerCase().endsWith("png")) {
                    mime = "image/png";
                } else if (((String)file.value).toLowerCase().endsWith("gif")) {
                    mime = "image/gif";
                } else {
                    FileInputStream fis = new FileInputStream((String)file.value);
                    mime = URLConnection.guessContentTypeFromStream(fis);
                    fis.close();
                    if (mime == null || mime.length() <= 0) {
                        mime = "application/octet-stream";
                    }
                }
            }
            sp.append("Content-Type: ").append(mime).append("\r\n\r\n");
            mp.append(sp);
            FilePart fp = new FilePart();
            fp.setFile((String)file.value);
            mp.append(fp);
            sp = new StringPart();
            sp.append("\r\n");
            mp.append(sp);
        }
        sp = new StringPart();
        sp.append("--").append(boundary).append("--\r\n");
        mp.append(sp);
        return mp;
    }

    private HTTPPart getTextPostHTTPPart(HttpURLConnection conn, String url, ArrayList<KVPair<String>> values) throws Throwable {
        conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        StringPart sp = new StringPart();
        if (values != null) {
            sp.append(this.kvPairsToUrl(values));
        }
        return sp;
    }

    public void rawPost(String url, ArrayList<KVPair<String>> headers, HTTPPart data, RawNetworkCallback callback, NetworkTimeOut timeout) throws Throwable {
        long time = System.currentTimeMillis();
        MobLog.getInstance().i("rawpost: " + url, new Object[0]);
        HttpURLConnection conn = this.getConnection(url, timeout);
        conn.setDoOutput(true);
        conn.setChunkedStreamingMode(0);
        if (headers != null) {
            for (KVPair<String> header : headers) {
                conn.setRequestProperty(header.name, (String)header.value);
            }
        }
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        conn.connect();
        OutputStream os = conn.getOutputStream();
        InputStream is = data.toInputStream();
        byte[] buf = new byte[65536];
        int len = is.read(buf);
        while (len > 0) {
            os.write(buf, 0, len);
            len = is.read(buf);
        }
        os.flush();
        is.close();
        os.close();
        int status = conn.getResponseCode();
        if (status == 200) {
            if (callback != null) {
                InputStream in = conn.getInputStream();
                try {
                    callback.onResponse(in);
                }
                catch (Throwable t) {
                    throw t;
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable) {}
                    }
                    conn.disconnect();
                }
            }
            conn.disconnect();
        } else {
            StringBuilder sb = new StringBuilder();
            InputStreamReader isr = new InputStreamReader(conn.getErrorStream(), Charset.forName("utf-8"));
            BufferedReader br = new BufferedReader(isr);
            String txt = br.readLine();
            while (txt != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(txt);
                txt = br.readLine();
            }
            br.close();
            conn.disconnect();
            HashMap<String, Object> errMap = new HashMap<String, Object>();
            errMap.put("error", sb.toString());
            errMap.put("status", status);
            throw new Throwable(new Hashon().fromHashMap(errMap));
        }
        MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
    }

    public void rawPost(String url, ArrayList<KVPair<String>> headers, HTTPPart data, HttpResponseCallback callback, NetworkTimeOut timeout) throws Throwable {
        this.rawPost(url, headers, data, 0, callback, timeout);
    }

    public void rawPost(String url, ArrayList<KVPair<String>> headers, HTTPPart data, int chunkLength, HttpResponseCallback callback, NetworkTimeOut timeout) throws Throwable {
        long time = System.currentTimeMillis();
        MobLog.getInstance().i("rawpost: " + url, new Object[0]);
        HttpURLConnection conn = this.getConnection(url, timeout);
        conn.setDoOutput(true);
        if (chunkLength >= 0) {
            conn.setChunkedStreamingMode(0);
        }
        if (headers != null) {
            for (KVPair<String> header : headers) {
                conn.setRequestProperty(header.name, (String)header.value);
            }
        }
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        conn.connect();
        OutputStream os = conn.getOutputStream();
        InputStream is = data.toInputStream();
        byte[] buf = new byte[65536];
        int len = is.read(buf);
        while (len > 0) {
            os.write(buf, 0, len);
            len = is.read(buf);
        }
        os.flush();
        is.close();
        os.close();
        if (callback != null) {
            try {
                callback.onResponse(new HttpConnectionImpl23(conn));
            }
            catch (Throwable t) {
                throw t;
            }
            finally {
                conn.disconnect();
            }
        } else {
            conn.disconnect();
        }
        MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
    }

    public void getHttpPostResponse(String url, ArrayList<KVPair<String>> values, KVPair<String> file, ArrayList<KVPair<String>> headers, HttpResponseCallback callback, NetworkTimeOut timeout) throws Throwable {
        HTTPPart part;
        long time = System.currentTimeMillis();
        MobLog.getInstance().i("httpPost: " + url, new Object[0]);
        HttpURLConnection conn = this.getConnection(url, timeout);
        conn.setDoOutput(true);
        conn.setChunkedStreamingMode(0);
        if (file != null && file.value != null && new File((String)file.value).exists()) {
            ArrayList files = new ArrayList();
            files.add(file);
            part = this.getFilePostHTTPPart(conn, url, values, files);
        } else {
            part = this.getTextPostHTTPPart(conn, url, values);
        }
        if (headers != null) {
            for (KVPair kVPair : headers) {
                conn.setRequestProperty(kVPair.name, (String)kVPair.value);
            }
        }
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        conn.connect();
        OutputStream os = conn.getOutputStream();
        InputStream inputStream = part.toInputStream();
        byte[] buf = new byte[65536];
        int len = inputStream.read(buf);
        while (len > 0) {
            os.write(buf, 0, len);
            len = inputStream.read(buf);
        }
        os.flush();
        inputStream.close();
        os.close();
        if (callback != null) {
            try {
                callback.onResponse(new HttpConnectionImpl23(conn));
            }
            catch (Throwable t) {
                throw t;
            }
            finally {
                conn.disconnect();
            }
        } else {
            conn.disconnect();
        }
        MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
    }

    public String httpPut(String url, ArrayList<KVPair<String>> values, KVPair<String> file, ArrayList<KVPair<String>> headers, NetworkTimeOut timeout) throws Throwable {
        return this.httpPut(url, values, file, headers, timeout, null);
    }

    public String httpPut(String url, ArrayList<KVPair<String>> values, KVPair<String> file, ArrayList<KVPair<String>> headers, NetworkTimeOut timeout, OnReadListener listener) throws Throwable {
        BufferedReader br;
        StringBuilder sb;
        String param;
        long time = System.currentTimeMillis();
        MobLog.getInstance().i("httpPut: " + url, new Object[0]);
        if (values != null && (param = this.kvPairsToUrl(values)).length() > 0) {
            url = url + "?" + param;
        }
        HttpURLConnection conn = this.getConnection(url, timeout);
        conn.setDoOutput(true);
        conn.setChunkedStreamingMode(0);
        conn.setRequestMethod("PUT");
        conn.setRequestProperty("Content-Type", "application/octet-stream");
        if (headers != null) {
            for (KVPair<String> header : headers) {
                conn.setRequestProperty(header.name, (String)header.value);
            }
        }
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        conn.connect();
        OutputStream os = conn.getOutputStream();
        FilePart fp = new FilePart();
        if (listener != null) {
            fp.setOnReadListener(listener);
        }
        fp.setFile((String)file.value);
        InputStream is = fp.toInputStream();
        byte[] buf = new byte[65536];
        int len = is.read(buf);
        while (len > 0) {
            os.write(buf, 0, len);
            len = is.read(buf);
        }
        os.flush();
        is.close();
        os.close();
        int status = conn.getResponseCode();
        String resp = null;
        if (status == 200 || status == 201) {
            sb = new StringBuilder();
            InputStreamReader isr = new InputStreamReader(conn.getInputStream(), Charset.forName("utf-8"));
            br = new BufferedReader(isr);
            String txt = br.readLine();
            while (txt != null) {
                if (sb.length() > 0) {
                    sb.append('\n');
                }
                sb.append(txt);
                txt = br.readLine();
            }
        } else {
            StringBuilder sb2 = new StringBuilder();
            InputStreamReader isr = new InputStreamReader(conn.getErrorStream(), Charset.forName("utf-8"));
            BufferedReader br2 = new BufferedReader(isr);
            String txt = br2.readLine();
            while (txt != null) {
                if (sb2.length() > 0) {
                    sb2.append('\n');
                }
                sb2.append(txt);
                txt = br2.readLine();
            }
            br2.close();
            HashMap<String, Object> errMap = new HashMap<String, Object>();
            errMap.put("error", sb2.toString());
            errMap.put("status", status);
            throw new Throwable(new Hashon().fromHashMap(errMap));
        }
        br.close();
        conn.disconnect();
        resp = sb.toString();
        MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
        return resp;
    }

    public ArrayList<KVPair<String[]>> httpHead(String url, ArrayList<KVPair<String>> values, KVPair<String> file, ArrayList<KVPair<String>> headers, NetworkTimeOut timeout) throws Throwable {
        String param;
        long time = System.currentTimeMillis();
        MobLog.getInstance().i("httpHead: " + url, new Object[0]);
        if (values != null && (param = this.kvPairsToUrl(values)).length() > 0) {
            url = url + "?" + param;
        }
        HttpURLConnection conn = this.getConnection(url, timeout);
        conn.setRequestMethod("HEAD");
        if (headers != null) {
            for (KVPair<String> header : headers) {
                conn.setRequestProperty(header.name, (String)header.value);
            }
        }
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        conn.connect();
        Map<String, List<String>> map = conn.getHeaderFields();
        ArrayList<KVPair<String[]>> list = new ArrayList<KVPair<String[]>>();
        if (map != null) {
            for (Map.Entry<String, List<String>> ent : map.entrySet()) {
                List<String> value = ent.getValue();
                if (value == null) {
                    list.add(new KVPair<String[]>(ent.getKey(), new String[0]));
                    continue;
                }
                String[] hds = new String[value.size()];
                for (int i = 0; i < hds.length; ++i) {
                    hds[i] = value.get(i);
                }
                list.add(new KVPair<String[]>(ent.getKey(), hds));
            }
        }
        conn.disconnect();
        MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
        return list;
    }

    public void httpPatch(String url, ArrayList<KVPair<String>> values, KVPair<String> file, long offset, ArrayList<KVPair<String>> headers, OnReadListener listener, HttpResponseCallback callback, NetworkTimeOut timeout) throws Throwable {
        if (Build.VERSION.SDK_INT >= 23) {
            this.httpPatchImpl23(url, values, file, offset, headers, listener, callback, timeout);
        } else {
            this.httpPatchImpl(url, values, file, offset, headers, listener, callback, timeout);
        }
    }

    private void httpPatchImpl(String url, ArrayList<KVPair<String>> values, KVPair<String> file, long offset, ArrayList<KVPair<String>> headers, OnReadListener listener, HttpResponseCallback callback, NetworkTimeOut timeout) throws Throwable {
        Object client;
        int rTimout;
        int cTimeout;
        Object patch;
        String param;
        long time = System.currentTimeMillis();
        MobLog.getInstance().i("httpPatch: " + url, new Object[0]);
        ReflectHelper.importClass("org.apache.http.entity.InputStreamEntity");
        ReflectHelper.importClass("org.apache.http.params.BasicHttpParams");
        ReflectHelper.importClass("org.apache.http.params.HttpConnectionParams");
        ReflectHelper.importClass("org.apache.http.HttpVersion");
        ReflectHelper.importClass("org.apache.http.params.HttpProtocolParams");
        ReflectHelper.importClass("org.apache.http.conn.scheme.SchemeRegistry");
        ReflectHelper.importClass("org.apache.http.conn.scheme.PlainSocketFactory");
        ReflectHelper.importClass("org.apache.http.conn.scheme.Scheme");
        ReflectHelper.importClass("org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager");
        ReflectHelper.importClass("org.apache.http.impl.client.DefaultHttpClient");
        if (values != null && (param = this.kvPairsToUrl(values)).length() > 0) {
            url = url + "?" + param;
        }
        if ((patch = this.getHttpPatch(url)) != null && headers != null) {
            for (KVPair<String> header : headers) {
                ReflectHelper.invokeInstanceMethod(patch, "setHeader", header.name, header.value);
            }
        }
        FilePart fp = new FilePart();
        fp.setOnReadListener(listener);
        fp.setFile((String)file.value);
        fp.setOffset(offset);
        InputStream is = fp.toInputStream();
        long length = fp.length() - offset;
        Object entity = ReflectHelper.newInstance("InputStreamEntity", is, length);
        ReflectHelper.invokeInstanceMethod(entity, "setContentEncoding", "application/offset+octet-stream");
        ReflectHelper.invokeInstanceMethod(patch, "setEntity", entity);
        Object httpParams = ReflectHelper.newInstance("BasicHttpParams", new Object[0]);
        int n = cTimeout = timeout == null ? connectionTimeout : timeout.connectionTimeout;
        if (cTimeout > 0) {
            ReflectHelper.invokeStaticMethod("HttpConnectionParams", "setConnectionTimeout", httpParams, cTimeout);
        }
        int n2 = rTimout = timeout == null ? readTimout : timeout.readTimout;
        if (rTimout > 0) {
            ReflectHelper.invokeStaticMethod("HttpConnectionParams", "setSoTimeout", httpParams, cTimeout);
        }
        ReflectHelper.invokeInstanceMethod(patch, "setParams", httpParams);
        if (url.startsWith("https://")) {
            KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
            trustStore.load(null, null);
            SSLSocketFactoryEx sf = new SSLSocketFactoryEx(trustStore);
            sf.setHostnameVerifier(SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
            Object params = ReflectHelper.newInstance("BasicHttpParams", new Object[0]);
            Object http11 = ReflectHelper.getStaticField("HttpVersion", "HTTP_1_1");
            ReflectHelper.invokeStaticMethod("HttpProtocolParams", "setVersion", params, http11);
            ReflectHelper.invokeStaticMethod("HttpProtocolParams", "setContentCharset", params, "UTF-8");
            Object registry = ReflectHelper.newInstance("SchemeRegistry", new Object[0]);
            Object httpSf = ReflectHelper.invokeStaticMethod("PlainSocketFactory", "getSocketFactory", new Object[0]);
            Object http = ReflectHelper.newInstance("Scheme", "http", httpSf, 80);
            Object https = ReflectHelper.newInstance("Scheme", new Object[]{"https", sf, 443});
            ReflectHelper.invokeInstanceMethod(registry, "register", http);
            ReflectHelper.invokeInstanceMethod(registry, "register", https);
            Object ccm = ReflectHelper.newInstance("ThreadSafeClientConnManager", params, registry);
            client = ReflectHelper.newInstance("DefaultHttpClient", ccm, params);
        } else {
            client = ReflectHelper.newInstance("DefaultHttpClient", new Object[0]);
        }
        Object httpResponse = ReflectHelper.invokeInstanceMethod(client, "execute", patch);
        Object manager = ReflectHelper.invokeInstanceMethod(client, "getConnectionManager", new Object[0]);
        if (callback != null) {
            try {
                callback.onResponse(new HttpConnectionImpl(httpResponse));
            }
            catch (Throwable t) {
                throw t;
            }
            finally {
                ReflectHelper.invokeInstanceMethod(manager, "shutdown", new Object[0]);
            }
        } else {
            ReflectHelper.invokeInstanceMethod(manager, "shutdown", new Object[0]);
        }
        MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
    }

    private Object getHttpPatch(String uri) throws Throwable {
        return null;
    }

    public void httpPatchImpl23(String url, ArrayList<KVPair<String>> values, KVPair<String> file, long offset, ArrayList<KVPair<String>> headers, OnReadListener listener, HttpResponseCallback callback, NetworkTimeOut timeout) throws Throwable {
        String param;
        long time = System.currentTimeMillis();
        MobLog.getInstance().i("httpPatch: " + url, new Object[0]);
        if (values != null && (param = this.kvPairsToUrl(values)).length() > 0) {
            url = url + "?" + param;
        }
        HttpURLConnection conn = this.getConnection(url, timeout);
        conn.setDoOutput(true);
        conn.setChunkedStreamingMode(0);
        conn.setRequestMethod("PATCH");
        conn.setRequestProperty("Content-Type", "application/offset+octet-stream");
        if (headers != null) {
            for (KVPair<String> header : headers) {
                conn.setRequestProperty(header.name, (String)header.value);
            }
        }
        conn.setInstanceFollowRedirects(this.instanceFollowRedirects);
        conn.connect();
        OutputStream os = conn.getOutputStream();
        FilePart fp = new FilePart();
        fp.setOnReadListener(listener);
        fp.setFile((String)file.value);
        fp.setOffset(offset);
        InputStream is = fp.toInputStream();
        byte[] buf = new byte[65536];
        int len = is.read(buf);
        while (len > 0) {
            os.write(buf, 0, len);
            len = is.read(buf);
        }
        os.flush();
        is.close();
        os.close();
        if (callback != null) {
            try {
                callback.onResponse(new HttpConnectionImpl23(conn));
            }
            catch (Throwable t) {
                throw t;
            }
            finally {
                conn.disconnect();
            }
        } else {
            conn.disconnect();
        }
        MobLog.getInstance().i("use time: " + (System.currentTimeMillis() - time), new Object[0]);
    }

    private String kvPairsToUrl(ArrayList<KVPair<String>> values) throws Throwable {
        StringBuilder sb = new StringBuilder();
        for (KVPair<String> value : values) {
            String encodedValue;
            String encodedName = Data.urlEncode(value.name, "utf-8");
            String string = encodedValue = value.value != null ? Data.urlEncode((String)value.value, "utf-8") : "";
            if (sb.length() > 0) {
                sb.append('&');
            }
            sb.append(encodedName).append('=').append(encodedValue);
        }
        return sb.toString();
    }

    private HttpURLConnection getConnection(String urlStr, NetworkTimeOut timeout) throws Throwable {
        int readTimout;
        int connectionTimeout;
        URL ourl = new URL(urlStr);
        HttpURLConnection conn = (HttpURLConnection)ourl.openConnection();
        String filedName = "methodTokens";
        boolean staticType = false;
        Object methods = null;
        try {
            methods = (staticType ? ReflectHelper.getStaticField("HttpURLConnection", filedName) : ReflectHelper.getInstanceField(conn, filedName));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (methods == null) {
            filedName = "PERMITTED_USER_METHODS";
            staticType = true;
            try {
                methods = (staticType ? ReflectHelper.getStaticField("HttpURLConnection", filedName) : ReflectHelper.getInstanceField(conn, filedName));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (methods != null) {
            String[] methodTokens = methods;
            String[] myMethodTokens = new String[methodTokens.length + 1];
            System.arraycopy(methodTokens, 0, myMethodTokens, 0, methodTokens.length);
            myMethodTokens[methodTokens.length] = "PATCH";
            if (staticType) {
                ReflectHelper.setStaticField("HttpURLConnection", filedName, myMethodTokens);
            } else {
                ReflectHelper.setInstanceField(conn, filedName, myMethodTokens);
            }
        }
        if (Build.VERSION.SDK_INT < 8) {
            System.setProperty("http.keepAlive", "false");
        }
        if (conn instanceof HttpsURLConnection) {
            X509HostnameVerifier hostnameVerifier = SSLSocketFactory.STRICT_HOSTNAME_VERIFIER;
            HttpsURLConnection httpsConn = (HttpsURLConnection)conn;
            SSLContext sc = SSLContext.getInstance("TLS");
            TrustManager[] trustManager = new TrustManager[]{new SimpleX509TrustManager(null)};
            sc.init(null, trustManager, new SecureRandom());
            httpsConn.setSSLSocketFactory(sc.getSocketFactory());
            httpsConn.setHostnameVerifier((HostnameVerifier)hostnameVerifier);
        }
        int n = connectionTimeout = timeout == null ? NetworkHelper.connectionTimeout : timeout.connectionTimeout;
        if (connectionTimeout > 0) {
            conn.setConnectTimeout(connectionTimeout);
        }
        int n2 = readTimout = timeout == null ? NetworkHelper.readTimout : timeout.readTimout;
        if (readTimout > 0) {
            conn.setReadTimeout(readTimout);
        }
        return conn;
    }

    public boolean getInstanceFollowRedirects() {
        return this.instanceFollowRedirects;
    }

    public void setInstanceFollowRedirects(boolean followRedirects) {
        this.instanceFollowRedirects = followRedirects;
    }

    public static boolean getFollowRedirects() {
        return followRedirects;
    }

    public static void setFollowRedirects(boolean auto) {
        followRedirects = auto;
    }

    public static String checkHttpRequestUrl(String requestUrl) {
        try {
            String scheme;
            Uri uri;
            String className;
            Object object;
            boolean result;
            if (!TextUtils.isEmpty((CharSequence)requestUrl) && Build.VERSION.SDK_INT >= 23 && !(result = ((Boolean)ReflectHelper.invokeInstanceMethod(object = ReflectHelper.invokeStaticMethod(className = ReflectHelper.importClass("android.security.NetworkSecurityPolicy"), "getInstance", new Object[0]), "isCleartextTrafficPermitted", new Object[0])).booleanValue()) && (requestUrl = requestUrl.trim()).startsWith("http://") && (uri = Uri.parse((String)requestUrl.trim())) != null && (scheme = uri.getScheme()) != null && scheme.equals("http")) {
                String host = uri.getHost();
                String path = uri.getPath();
                if (host != null) {
                    int port = uri.getPort();
                    host = host + (port <= 0 || port == 80 ? "" : ":" + port);
                    if (Build.VERSION.SDK_INT >= 24 && ((Boolean)ReflectHelper.invokeInstanceMethod(object, "isCleartextTrafficPermitted", host)).booleanValue()) {
                        return requestUrl;
                    }
                }
                return "https://" + host + (path == null ? "" : path);
            }
        }
        catch (Throwable t) {
            MobLog.getInstance().d(t);
        }
        return requestUrl;
    }

    static {
        followRedirects = true;
    }

    public static class NetworkTimeOut {
        public int readTimout;
        public int connectionTimeout;
    }

    public static final class SimpleX509TrustManager
    implements X509TrustManager {
        private X509TrustManager standardTrustManager;

        public SimpleX509TrustManager(KeyStore keystore) {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance("X509");
                tmf.init(keystore);
                TrustManager[] trustManagers = tmf.getTrustManagers();
                if (trustManagers == null || trustManagers.length == 0) {
                    throw new NoSuchAlgorithmException("no trust manager found.");
                }
                this.standardTrustManager = (X509TrustManager)trustManagers[0];
            }
            catch (Exception e) {
                MobLog.getInstance().d("failed to initialize the standard trust manager: " + e.getMessage(), new Object[0]);
                this.standardTrustManager = null;
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certificates, String authType) throws CertificateException {
            if (certificates == null) {
                throw new IllegalArgumentException("there were no certificates.");
            }
            if (certificates.length == 1) {
                certificates[0].checkValidity();
            } else if (this.standardTrustManager != null) {
                this.standardTrustManager.checkServerTrusted(certificates, authType);
            } else {
                throw new CertificateException("there were one more certificates but no trust manager found.");
            }
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }
    }
}

