/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.gui;

import com.mob.tools.MobLog;
import java.util.LinkedList;

public class CachePool<K, V> {
    private int capacity;
    private LinkedList<Node<K, V>> pool;
    private int poolSize;
    private OnRemoveListener<K, V> listener;

    public CachePool(int capacity) {
        this.capacity = capacity;
        this.pool = new LinkedList();
    }

    public void setOnRemoveListener(OnRemoveListener<K, V> listener) {
        this.listener = listener;
    }

    public synchronized boolean put(K key, V value, int size) {
        if (this.pool != null && this.capacity > 0) {
            try {
                Node node = new Node();
                node.key = key;
                node.value = value;
                node.cacheTime = System.currentTimeMillis();
                node.size = size;
                this.pool.add(0, node);
                this.poolSize += size;
                while (this.poolSize > this.capacity) {
                    Node<K, V> last = this.pool.removeLast();
                    if (last == null) continue;
                    this.poolSize -= ((Node)last).size;
                    if (this.listener == null) continue;
                    this.listener.onRemove(last.key, last.value);
                }
                return true;
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }
        return false;
    }

    public synchronized boolean put(K key, V value) {
        return this.put(key, value, 1);
    }

    public synchronized V get(K key) {
        if (this.pool != null && this.capacity > 0) {
            try {
                while (this.poolSize > this.capacity) {
                    Node<K, V> last = this.pool.removeLast();
                    if (last == null) continue;
                    this.poolSize -= ((Node)last).size;
                    if (this.listener == null) continue;
                    this.listener.onRemove(last.key, last.value);
                }
                Node node = null;
                for (Node node2 : this.pool) {
                    if (node2 == null || (key != null || node2.key != null) && (key == null || !key.equals(node2.key))) continue;
                    node = node2;
                    break;
                }
                if (node != null) {
                    this.pool.set(0, node);
                    node.cacheTime = System.currentTimeMillis();
                    return node.value;
                }
            }
            catch (Throwable t) {
                MobLog.getInstance().w(t);
            }
        }
        return null;
    }

    public synchronized void clear() {
        if (this.pool != null && this.capacity > 0) {
            if (this.listener == null) {
                this.pool.clear();
            } else {
                while (this.pool.size() > 0) {
                    Node<K, V> last = this.pool.removeLast();
                    if (last == null) continue;
                    this.poolSize -= ((Node)last).size;
                    if (this.listener == null) continue;
                    this.listener.onRemove(last.key, last.value);
                }
            }
            this.poolSize = 0;
        }
    }

    public synchronized void trimBeforeTime(long time) {
        if (this.pool != null && this.capacity > 0) {
            int i = this.pool.size() - 1;
            while (i >= 0) {
                Node<K, V> node = this.pool.get(i);
                if (((Node)node).cacheTime < time) {
                    Node<K, V> removed = this.pool.remove(i);
                    if (removed == null) continue;
                    this.poolSize -= ((Node)removed).size;
                    if (this.listener == null) continue;
                    this.listener.onRemove(removed.key, removed.value);
                    continue;
                }
                --i;
            }
            while (this.poolSize > this.capacity) {
                Node<K, V> last = this.pool.removeLast();
                if (last == null) continue;
                this.poolSize -= ((Node)last).size;
                if (this.listener == null) continue;
                this.listener.onRemove(last.key, last.value);
            }
        }
    }

    public synchronized int size() {
        return this.poolSize;
    }

    public static interface OnRemoveListener<K, V> {
        public void onRemove(K var1, V var2);
    }

    private class Node<K, V> {
        public K key;
        public V value;
        private long cacheTime;
        private int size;

        private Node() {
        }
    }
}

