/*
 * Decompiled with CFR 0.152.
 */
package com.mob.tools.utils;

import com.mob.tools.gui.CachePool;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ReflectHelper {
    private static HashSet<String> packageSet = new HashSet();
    private static HashMap<String, Class<?>> classMap;
    private static HashMap<Class<?>, String> nameMap;
    private static CachePool<String, Method> cachedMethod;
    private static CachePool<String, Constructor<?>> cachedConstr;

    public static String importClass(String className) throws Throwable {
        return ReflectHelper.importClass(null, className);
    }

    public static synchronized String importClass(String name, String className) throws Throwable {
        if (className.endsWith(".*")) {
            packageSet.add(className.substring(0, className.length() - 2));
            return "*";
        }
        Class<?> clz = Class.forName(className);
        if (name == null) {
            name = clz.getSimpleName();
        }
        if (classMap.containsKey(name)) {
            nameMap.remove(classMap.get(name));
        }
        classMap.put(name, clz);
        nameMap.put(clz, name);
        return name;
    }

    private static synchronized Class<?> getImportedClass(String className) {
        Class<?> clz = classMap.get(className);
        if (clz == null) {
            for (String packageName : packageSet) {
                try {
                    ReflectHelper.importClass(packageName + "." + className);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if ((clz = classMap.get(className)) == null) continue;
                break;
            }
        }
        return clz;
    }

    private static Class<?>[] getTypes(Object[] args) {
        Class[] types = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            types[i] = args[i] == null ? null : args[i].getClass();
        }
        return types;
    }

    private static boolean primitiveEquals(Class<?> primitive, Class<?> target) {
        return primitive == Byte.TYPE && target == Byte.class || primitive == Short.TYPE && (target == Short.class || target == Byte.class || target == Character.class) || primitive == Character.TYPE && (target == Character.class || target == Short.class || target == Byte.class) || primitive == Integer.TYPE && (target == Integer.class || target == Short.class || target == Byte.class || target == Character.class) || primitive == Long.TYPE && (target == Long.class || target == Integer.class || target == Short.class || target == Byte.class || target == Character.class) || primitive == Float.TYPE && (target == Float.class || target == Long.class || target == Integer.class || target == Short.class || target == Byte.class || target == Character.class) || primitive == Double.TYPE && (target == Double.class || target == Float.class || target == Long.class || target == Integer.class || target == Short.class || target == Byte.class || target == Character.class) || primitive == Boolean.TYPE && target == Boolean.class;
    }

    private static boolean matchParams(Class<?>[] mTypes, Class<?>[] types) {
        if (mTypes.length == types.length) {
            boolean match = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == null || ReflectHelper.primitiveEquals(mTypes[i], types[i]) || mTypes[i].isAssignableFrom(types[i])) continue;
                match = false;
                break;
            }
            return match;
        }
        return false;
    }

    private static boolean tryMatchParams(Class<?>[] mTypes, Class<?>[] types) {
        if (mTypes.length - types.length == 1) {
            boolean match = true;
            for (int i = 0; i < types.length; ++i) {
                if (types[i] == null || ReflectHelper.primitiveEquals(mTypes[i], types[i]) || mTypes[i].isAssignableFrom(types[i])) continue;
                match = false;
                break;
            }
            return match && mTypes[mTypes.length - 1].isArray();
        }
        return false;
    }

    public static Object newInstance(String className, Object ... args) throws Throwable {
        try {
            return ReflectHelper.onNewInstance(className, args);
        }
        catch (Throwable t) {
            if (t instanceof NoSuchMethodException) {
                throw t;
            }
            String msg = "className: " + className + ", methodName: <init>";
            throw new Throwable(msg, t);
        }
    }

    private static Object onNewInstance(String className, Object ... args) throws Throwable {
        if (className.startsWith("[")) {
            return ReflectHelper.newArray(className, args);
        }
        Class<?> clz = ReflectHelper.getImportedClass(className);
        String mthSign = clz.getName() + "#" + args.length;
        Constructor<?> con = cachedConstr.get(mthSign);
        Class<?>[] types = ReflectHelper.getTypes(args);
        if (con != null && ReflectHelper.matchParams(con.getParameterTypes(), types)) {
            con.setAccessible(true);
            return con.newInstance(args);
        }
        Constructor<?>[] cons = clz.getDeclaredConstructors();
        ArrayList overloads = new ArrayList();
        ArrayList<Class<?>[]> paramsTypes = new ArrayList<Class<?>[]>();
        for (Constructor<?> c : cons) {
            Class<?>[] paramTypes = c.getParameterTypes();
            if (ReflectHelper.matchParams(paramTypes, types)) {
                cachedConstr.put(mthSign, c);
                c.setAccessible(true);
                return c.newInstance(args);
            }
            if (paramTypes.length <= 0 || !paramTypes[paramTypes.length - 1].isArray() || types.length < paramTypes.length - 1) continue;
            overloads.add(c);
            paramsTypes.add(paramTypes);
        }
        for (int i = 0; i < paramsTypes.size(); ++i) {
            Class[] paramTypes = (Class[])paramsTypes.get(i);
            Class<?> componentType = paramTypes[paramTypes.length - 1].getComponentType();
            if (ReflectHelper.tryMatchParams(paramTypes, types)) {
                Object[] newArgs = new Object[args.length + 1];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[args.length] = Array.newInstance(componentType, 0);
                Constructor c = (Constructor)overloads.get(i);
                c.setAccessible(true);
                return c.newInstance(args);
            }
            boolean isElement = true;
            for (int t = paramTypes.length - 1; t < types.length; ++t) {
                if (types[t].equals(componentType)) continue;
                isElement = false;
                break;
            }
            if (!isElement) continue;
            int arrLen = types.length - paramTypes.length + 1;
            Object arr = Array.newInstance(componentType, arrLen);
            for (int e = 0; e < arrLen; ++e) {
                Array.set(arr, e, args[paramTypes.length - 1 + e]);
            }
            Object[] newArgs = new Object[args.length + 1];
            System.arraycopy(args, 0, newArgs, 0, args.length);
            newArgs[args.length] = arr;
            Constructor c = (Constructor)overloads.get(i);
            c.setAccessible(true);
            return c.newInstance(args);
        }
        throw new NoSuchMethodException("className: " + className + ", methodName: <init>");
    }

    private static Object newArray(String className, Object ... args) throws Throwable {
        String tmp = className;
        int dimension = 0;
        while (tmp.startsWith("[")) {
            ++dimension;
            tmp = tmp.substring(1);
        }
        int[] lens = null;
        if (dimension == args.length) {
            lens = new int[dimension];
            for (int i = 0; i < dimension; ++i) {
                try {
                    lens[i] = Integer.parseInt(String.valueOf(args[i]));
                    continue;
                }
                catch (Throwable t) {
                    lens = null;
                    break;
                }
            }
        }
        if (lens != null) {
            Class<Comparable<Byte>> eleClz = null;
            eleClz = "B".equals(tmp) ? Byte.TYPE : ("S".equals(tmp) ? Short.TYPE : ("I".equals(tmp) ? Integer.TYPE : ("J".equals(tmp) ? Long.TYPE : ("F".equals(tmp) ? Float.TYPE : ("D".equals(tmp) ? Double.TYPE : ("Z".equals(tmp) ? Boolean.TYPE : ("C".equals(tmp) ? Character.TYPE : ReflectHelper.getImportedClass(tmp))))))));
            if (eleClz != null) {
                return Array.newInstance(eleClz, lens);
            }
        }
        throw new NoSuchMethodException("className: [" + className + ", methodName: <init>");
    }

    public static <T> T invokeStaticMethod(String className, String methodName, Object[] args, Class<?>[] paramTypes) throws Throwable {
        return ReflectHelper.invokeMethod(className, null, methodName, args, paramTypes);
    }

    public static <T> T invokeStaticMethod(String className, String methodName, Object ... args) throws Throwable {
        try {
            return ReflectHelper.invokeMethod(className, null, methodName, args);
        }
        catch (Throwable t) {
            if (t instanceof NoSuchMethodException) {
                throw t;
            }
            String msg = "className: " + className + ", methodName: " + methodName;
            throw new Throwable(msg, t);
        }
    }

    private static <T> T invokeMethod(String className, Object receiver, String methodName, Object[] args, Class<?>[] paramTypes) throws Throwable {
        Class<?> clz;
        String mthSign;
        Method mth;
        if (args == null) {
            args = new Object[]{};
        }
        if (paramTypes == null) {
            paramTypes = new Class[]{};
        }
        if ((mth = cachedMethod.get(mthSign = (clz = receiver == null ? ReflectHelper.getImportedClass(className) : receiver.getClass()).getName() + "#" + methodName + "#" + args.length)) != null) {
            mth.setAccessible(true);
            if (mth.getReturnType() == Void.TYPE) {
                mth.invoke(receiver, args);
                return null;
            }
            return (T)mth.invoke(receiver, args);
        }
        while (clz != null) {
            try {
                mth = clz.getDeclaredMethod(methodName, paramTypes);
                cachedMethod.put(mthSign, mth);
                mth.setAccessible(true);
                if (mth.getReturnType() == Void.TYPE) {
                    mth.invoke(receiver, args);
                    return null;
                }
                return (T)mth.invoke(receiver, args);
            }
            catch (Throwable throwable) {
                clz = clz.getSuperclass();
            }
        }
        throw new NoSuchMethodException("className: " + (receiver == null ? className : receiver.getClass()) + ", methodName: " + methodName);
    }

    private static <T> T invokeMethod(String className, Object receiver, String methodName, Object ... args) throws Throwable {
        Class<?> clz = receiver == null ? ReflectHelper.getImportedClass(className) : receiver.getClass();
        String mthSign = clz.getName() + "#" + methodName + "#" + args.length;
        Method mth = cachedMethod.get(mthSign);
        Class<?>[] types = ReflectHelper.getTypes(args);
        if (mth != null) {
            boolean reqModifier;
            boolean isReqStatic = Modifier.isStatic(mth.getModifiers());
            boolean bl = receiver == null ? isReqStatic : (reqModifier = !isReqStatic);
            if (reqModifier && ReflectHelper.matchParams(mth.getParameterTypes(), types)) {
                mth.setAccessible(true);
                if (mth.getReturnType() == Void.TYPE) {
                    mth.invoke(receiver, args);
                    return null;
                }
                return (T)mth.invoke(receiver, args);
            }
        }
        ArrayList clzs = new ArrayList();
        while (clz != null) {
            try {
                mth = clz.getDeclaredMethod(methodName, types);
                cachedMethod.put(mthSign, mth);
                mth.setAccessible(true);
                if (mth.getReturnType() == Void.TYPE) {
                    mth.invoke(receiver, args);
                    return null;
                }
                Object obj = mth.invoke(receiver, args);
                return (T)obj;
            }
            catch (Throwable obj) {
                clzs.add(clz);
                clz = clz.getSuperclass();
            }
        }
        ArrayList<Method> overloads = new ArrayList<Method>();
        ArrayList<Class<?>[]> paramsTypes = new ArrayList<Class<?>[]>();
        for (Class clazz : clzs) {
            Method[] mths;
            for (Method m : mths = clazz.getDeclaredMethods()) {
                boolean modifier;
                boolean isStatic = Modifier.isStatic(m.getModifiers());
                boolean bl = receiver == null ? isStatic : (modifier = !isStatic);
                if (!m.getName().equals(methodName) || !modifier) continue;
                Class<?>[] paramTypes = m.getParameterTypes();
                if (ReflectHelper.matchParams(paramTypes, types)) {
                    cachedMethod.put(mthSign, m);
                    m.setAccessible(true);
                    if (m.getReturnType() == Void.TYPE) {
                        m.invoke(receiver, args);
                        return null;
                    }
                    return (T)m.invoke(receiver, args);
                }
                if (paramTypes.length <= 0 || !paramTypes[paramTypes.length - 1].isArray() || types.length < paramTypes.length - 1) continue;
                overloads.add(m);
                paramsTypes.add(paramTypes);
            }
        }
        for (int i = 0; i < paramsTypes.size(); ++i) {
            Class[] classArray = (Class[])paramsTypes.get(i);
            Class<?> componentType = classArray[classArray.length - 1].getComponentType();
            if (ReflectHelper.tryMatchParams(classArray, types)) {
                Object[] newArgs = new Object[args.length + 1];
                System.arraycopy(args, 0, newArgs, 0, args.length);
                newArgs[args.length] = Array.newInstance(componentType, 0);
                Method m = (Method)overloads.get(i);
                m.setAccessible(true);
                if (m.getReturnType() == Void.TYPE) {
                    m.invoke(receiver, newArgs);
                    return null;
                }
                return (T)m.invoke(receiver, newArgs);
            }
            boolean isElement = true;
            for (int t = classArray.length - 1; t < types.length; ++t) {
                if (types[t].equals(componentType)) continue;
                isElement = false;
                break;
            }
            if (!isElement) continue;
            int arrLen = types.length - classArray.length + 1;
            Object arr = Array.newInstance(componentType, arrLen);
            for (int e = 0; e < arrLen; ++e) {
                Array.set(arr, e, args[classArray.length - 1 + e]);
            }
            Object[] newArgs = new Object[classArray.length];
            System.arraycopy(args, 0, newArgs, 0, classArray.length - 1);
            newArgs[classArray.length - 1] = arr;
            Method m = (Method)overloads.get(i);
            m.setAccessible(true);
            if (m.getReturnType() == Void.TYPE) {
                m.invoke(receiver, newArgs);
                return null;
            }
            return (T)m.invoke(receiver, newArgs);
        }
        throw new NoSuchMethodException("className: " + (receiver == null ? className : receiver.getClass()) + ", methodName: " + methodName);
    }

    public static <T> T invokeInstanceMethod(Object receiver, String methodName, Object[] args, Class<?>[] paramTypes) throws Throwable {
        return ReflectHelper.invokeMethod(null, receiver, methodName, args, paramTypes);
    }

    public static <T> T invokeInstanceMethod(Object receiver, String methodName, Object ... args) throws Throwable {
        try {
            return ReflectHelper.invokeMethod(null, receiver, methodName, args);
        }
        catch (Throwable t) {
            if (t instanceof NoSuchMethodException) {
                throw t;
            }
            String msg = "className: " + (receiver == null ? null : receiver.getClass()) + ", methodName: " + methodName;
            throw new Throwable(msg, t);
        }
    }

    public static <T> T getStaticField(String className, String fieldName) throws Throwable {
        try {
            return ReflectHelper.onGetStaticField(className, fieldName);
        }
        catch (Throwable t) {
            if (t instanceof NoSuchFieldException) {
                throw t;
            }
            String msg = "className: " + className + ", fieldName: " + fieldName;
            throw new Throwable(msg, t);
        }
    }

    private static <T> T onGetStaticField(String className, String fieldName) throws Throwable {
        ArrayList clzs = new ArrayList();
        for (Class<?> clz = ReflectHelper.getImportedClass(className); clz != null; clz = clz.getSuperclass()) {
            clzs.add(clz);
        }
        for (Class clazz : clzs) {
            Field fld = null;
            try {
                fld = clazz.getDeclaredField(fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (fld == null || !Modifier.isStatic(fld.getModifiers())) continue;
            fld.setAccessible(true);
            return (T)fld.get(null);
        }
        throw new NoSuchFieldException("className: " + className + ", fieldName: " + fieldName);
    }

    public static void setStaticField(String className, String fieldName, Object value) throws Throwable {
        try {
            ReflectHelper.onSetStaticField(className, fieldName, value);
        }
        catch (Throwable t) {
            if (t instanceof NoSuchFieldException) {
                throw t;
            }
            String msg = "className: " + className + ", fieldName: " + fieldName + ", value: " + String.valueOf(value);
            throw new Throwable(msg, t);
        }
    }

    private static void onSetStaticField(String className, String fieldName, Object value) throws Throwable {
        ArrayList clzs = new ArrayList();
        for (Class<?> clz = ReflectHelper.getImportedClass(className); clz != null; clz = clz.getSuperclass()) {
            clzs.add(clz);
        }
        for (Class clazz : clzs) {
            Field fld = null;
            try {
                fld = clazz.getDeclaredField(fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (fld == null || !Modifier.isStatic(fld.getModifiers())) continue;
            fld.setAccessible(true);
            fld.set(null, value);
            return;
        }
        throw new NoSuchFieldException("className: " + className + ", fieldName: " + fieldName + ", value: " + String.valueOf(value));
    }

    public static <T> T getInstanceField(Object receiver, String fieldName) throws Throwable {
        try {
            return ReflectHelper.onGetInstanceField(receiver, fieldName);
        }
        catch (Throwable t) {
            if (t instanceof NoSuchFieldException) {
                throw t;
            }
            String msg = "className: " + receiver.getClass() + ", fieldName: " + fieldName;
            throw new Throwable(msg, t);
        }
    }

    private static <T> T onGetInstanceField(Object receiver, String fieldName) throws Throwable {
        if (receiver instanceof List || receiver.getClass().isArray()) {
            return (T)ReflectHelper.onGetElement(receiver, fieldName);
        }
        if (receiver instanceof Map) {
            return (T)((Map)receiver).get(fieldName);
        }
        ArrayList clzs = new ArrayList();
        for (Class<?> clz = receiver.getClass(); clz != null; clz = clz.getSuperclass()) {
            clzs.add(clz);
        }
        for (Class clazz : clzs) {
            Field fld = null;
            try {
                fld = clazz.getDeclaredField(fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (fld == null || Modifier.isStatic(fld.getModifiers())) continue;
            fld.setAccessible(true);
            return (T)fld.get(receiver);
        }
        throw new NoSuchFieldException("className: " + receiver.getClass() + ", fieldName: " + fieldName);
    }

    private static Object onGetElement(Object receiver, String fieldName) throws Throwable {
        if (receiver instanceof List) {
            if (fieldName.startsWith("[") && fieldName.endsWith("]")) {
                int index = -1;
                try {
                    String strIndex = fieldName.substring(1, fieldName.length() - 1);
                    index = Integer.parseInt(strIndex);
                }
                catch (Throwable strIndex) {
                    // empty catch block
                }
                if (index != -1) {
                    return ((List)receiver).get(index);
                }
            }
        } else {
            if ("length".equals(fieldName)) {
                return Array.getLength(receiver);
            }
            if (fieldName.startsWith("[") && fieldName.endsWith("]")) {
                int index = -1;
                try {
                    String strIndex = fieldName.substring(1, fieldName.length() - 1);
                    index = Integer.parseInt(strIndex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                if (index != -1) {
                    return Array.get(receiver, index);
                }
            }
        }
        throw new NoSuchFieldException("className: " + receiver.getClass() + ", fieldName: " + fieldName);
    }

    public static void setInstanceField(Object receiver, String fieldName, Object value) throws Throwable {
        try {
            ReflectHelper.onSetInstanceField(receiver, fieldName, value);
        }
        catch (Throwable t) {
            if (t instanceof NoSuchFieldException) {
                throw t;
            }
            String msg = "className: " + receiver.getClass() + ", fieldName: " + fieldName + ", value: " + String.valueOf(value);
            throw new Throwable(msg, t);
        }
    }

    private static void onSetInstanceField(Object receiver, String fieldName, Object value) throws Throwable {
        if (receiver instanceof List || receiver.getClass().isArray()) {
            ReflectHelper.onSetElement(receiver, fieldName, value);
            return;
        }
        if (receiver instanceof Map) {
            ((Map)receiver).put(fieldName, value);
            return;
        }
        ArrayList clzs = new ArrayList();
        for (Class<?> clz = receiver.getClass(); clz != null; clz = clz.getSuperclass()) {
            clzs.add(clz);
        }
        for (Class clazz : clzs) {
            Field fld = null;
            try {
                fld = clazz.getDeclaredField(fieldName);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (fld == null || Modifier.isStatic(fld.getModifiers())) continue;
            fld.setAccessible(true);
            fld.set(receiver, value);
            return;
        }
        throw new NoSuchFieldException("className: " + receiver.getClass() + ", fieldName: " + fieldName + ", value: " + String.valueOf(value));
    }

    private static void onSetElement(Object receiver, String fieldName, Object value) throws Throwable {
        if (receiver instanceof List) {
            if (fieldName.startsWith("[") && fieldName.endsWith("]")) {
                int index = -1;
                try {
                    String strIndex = fieldName.substring(1, fieldName.length() - 1);
                    index = Integer.parseInt(strIndex);
                }
                catch (Throwable strIndex) {
                    // empty catch block
                }
                if (index != -1) {
                    ((List)receiver).set(index, value);
                    return;
                }
            }
        } else if (fieldName.startsWith("[") && fieldName.endsWith("]")) {
            int index = -1;
            try {
                String strIndex = fieldName.substring(1, fieldName.length() - 1);
                index = Integer.parseInt(strIndex);
            }
            catch (Throwable strIndex) {
                // empty catch block
            }
            if (index != -1) {
                String recClzName = receiver.getClass().getName();
                while (recClzName.startsWith("[")) {
                    recClzName = recClzName.substring(1);
                }
                Class<?> vClass = value.getClass();
                if ("B".equals(recClzName)) {
                    if (vClass == Byte.class) {
                        Array.set(receiver, index, value);
                        return;
                    }
                } else if ("S".equals(recClzName)) {
                    Object sValue = null;
                    if (vClass == Short.class) {
                        sValue = value;
                    } else if (vClass == Byte.class) {
                        sValue = (short)((Byte)value).byteValue();
                    }
                    if (sValue != null) {
                        Array.set(receiver, index, sValue);
                        return;
                    }
                } else if ("I".equals(recClzName)) {
                    Object iValue = null;
                    if (vClass == Integer.class) {
                        iValue = value;
                    } else if (vClass == Short.class) {
                        iValue = (int)((Short)value).shortValue();
                    } else if (vClass == Byte.class) {
                        iValue = (int)((Byte)value).byteValue();
                    }
                    if (iValue != null) {
                        Array.set(receiver, index, iValue);
                        return;
                    }
                } else if ("J".equals(recClzName)) {
                    Object jValue = null;
                    if (vClass == Long.class) {
                        jValue = value;
                    } else if (vClass == Integer.class) {
                        jValue = (long)((Integer)value).intValue();
                    } else if (vClass == Short.class) {
                        jValue = (long)((Short)value).shortValue();
                    } else if (vClass == Byte.class) {
                        jValue = (long)((Byte)value).byteValue();
                    }
                    if (jValue != null) {
                        Array.set(receiver, index, jValue);
                        return;
                    }
                } else if ("F".equals(recClzName)) {
                    Object fValue = null;
                    if (vClass == Float.class) {
                        fValue = value;
                    } else if (vClass == Long.class) {
                        fValue = Float.valueOf(((Long)value).longValue());
                    } else if (vClass == Integer.class) {
                        fValue = Float.valueOf(((Integer)value).intValue());
                    } else if (vClass == Short.class) {
                        fValue = Float.valueOf(((Short)value).shortValue());
                    } else if (vClass == Byte.class) {
                        fValue = Float.valueOf(((Byte)value).byteValue());
                    }
                    if (fValue != null) {
                        Array.set(receiver, index, fValue);
                        return;
                    }
                } else if ("D".equals(recClzName)) {
                    Object dValue = null;
                    if (vClass == Double.class) {
                        dValue = value;
                    } else if (vClass == Float.class) {
                        dValue = (double)((Float)value).floatValue();
                    } else if (vClass == Long.class) {
                        dValue = (double)((Long)value).longValue();
                    } else if (vClass == Integer.class) {
                        dValue = (double)((Integer)value).intValue();
                    } else if (vClass == Short.class) {
                        dValue = (double)((Short)value).shortValue();
                    } else if (vClass == Byte.class) {
                        dValue = (double)((Byte)value).byteValue();
                    }
                    if (dValue != null) {
                        Array.set(receiver, index, dValue);
                        return;
                    }
                } else if ("Z".equals(recClzName)) {
                    if (vClass == Boolean.class) {
                        Array.set(receiver, index, value);
                        return;
                    }
                } else if ("C".equals(recClzName)) {
                    if (vClass == Character.class) {
                        Array.set(receiver, index, value);
                        return;
                    }
                } else if (recClzName.equals(vClass.getName())) {
                    Array.set(receiver, index, value);
                    return;
                }
            }
        }
        throw new NoSuchFieldException("className: " + receiver.getClass() + ", fieldName: " + fieldName + ", value: " + String.valueOf(value));
    }

    public static Class<?> getClass(String name) throws Throwable {
        Class<?> clz = ReflectHelper.getImportedClass(name);
        if (clz == null) {
            try {
                clz = Class.forName(name);
                if (clz != null) {
                    classMap.put(name, clz);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return clz;
    }

    public static String getName(Class<?> clz) throws Throwable {
        String name = nameMap.get(clz);
        if (name == null) {
            name = clz.getSimpleName();
            if (classMap.containsKey(name)) {
                nameMap.remove(classMap.get(name));
            }
            classMap.put(name, clz);
            nameMap.put(clz, name);
        }
        return name;
    }

    public static Object createProxy(HashMap<String, ReflectRunnable<Object, Object[]>> proxyHandler, Class<?> ... proxyInterfaces) throws Throwable {
        HashMap<String, ReflectRunnable<Object[], Object>> map = new HashMap<String, ReflectRunnable<Object[], Object>>();
        for (final Map.Entry<String, ReflectRunnable<Object, Object[]>> ent : proxyHandler.entrySet()) {
            map.put(ent.getKey(), new ReflectRunnable<Object[], Object>(){

                @Override
                public Object run(Object[] arg) {
                    return ((Object[])((ReflectRunnable)ent.getValue()).run(arg))[0];
                }
            });
        }
        return ReflectHelper.createProxy(map, proxyInterfaces);
    }

    public static Object createProxy(final Map<String, ReflectRunnable<Object[], Object>> proxyHandler, Class<?> ... proxyInterfaces) throws Throwable {
        if (proxyInterfaces.length == 0) {
            return null;
        }
        ClassLoader loader = proxyInterfaces[0].getClassLoader();
        InvocationHandler handler = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                ReflectRunnable function = (ReflectRunnable)proxyHandler.get(method.getName());
                if (function != null) {
                    return function.run(args);
                }
                throw new NoSuchMethodException();
            }
        };
        return Proxy.newProxyInstance(loader, proxyInterfaces, handler);
    }

    static {
        packageSet.add("java.lang");
        packageSet.add("java.io");
        packageSet.add("java.nio");
        packageSet.add("java.net");
        packageSet.add("java.util");
        packageSet.add("com.mob.tools");
        packageSet.add("com.mob.tools.gui");
        packageSet.add("com.mob.tools.log");
        packageSet.add("com.mob.tools.network");
        packageSet.add("com.mob.tools.utils");
        classMap = new HashMap();
        classMap.put("double", Double.TYPE);
        classMap.put("float", Float.TYPE);
        classMap.put("long", Long.TYPE);
        classMap.put("int", Integer.TYPE);
        classMap.put("short", Short.TYPE);
        classMap.put("byte", Byte.TYPE);
        classMap.put("char", Character.TYPE);
        classMap.put("boolean", Boolean.TYPE);
        classMap.put("Object", Object.class);
        classMap.put("String", String.class);
        classMap.put("Thread", Thread.class);
        classMap.put("Runnable", Runnable.class);
        classMap.put("System", System.class);
        classMap.put("double", Double.class);
        classMap.put("Float", Float.class);
        classMap.put("Long", Long.class);
        classMap.put("Integer", Integer.class);
        classMap.put("Short", Short.class);
        classMap.put("Byte", Byte.class);
        classMap.put("Character", Character.class);
        classMap.put("Boolean", Boolean.class);
        nameMap = new HashMap();
        for (Map.Entry<String, Class<?>> ent : classMap.entrySet()) {
            nameMap.put(ent.getValue(), ent.getKey());
        }
        cachedMethod = new CachePool(25);
        cachedConstr = new CachePool(5);
    }

    public static interface ReflectRunnable<ArgType, RetType> {
        public RetType run(ArgType var1);
    }
}

