/*
 * Decompiled with CFR 0.152.
 */
package com.huike.nova.sdk.ui.douyin.presenter;

import android.content.Context;
import android.view.View;
import android.widget.TextView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import com.fshows.android.stark.utils.FsLogUtil;
import com.google.common.eventbus.Subscribe;
import com.huike.nova.sdk.NovaSdkPortal;
import com.huike.nova.sdk.R;
import com.huike.nova.sdk.constants.enums.OrderChannelType;
import com.huike.nova.sdk.eventbus.NovaSdkEventBusManager;
import com.huike.nova.sdk.eventbus.NovaSdkVerifyRescanEvent;
import com.huike.nova.sdk.eventbus.NovaSdkVerifySuccessEvent;
import com.huike.nova.sdk.ext.ContextExtKt;
import com.huike.nova.sdk.ext.JsonExtKt;
import com.huike.nova.sdk.model.domain.DouyinTicketEntity;
import com.huike.nova.sdk.model.domain.response.DouyinScanCodeResponse;
import com.huike.nova.sdk.ui.base.NovaSdkBaseViewHolderBinding;
import com.huike.nova.sdk.ui.base.NovaSdkBaseViewModel;
import com.huike.nova.sdk.ui.base.NovaSdkBaseViewModelPresenter;
import com.huike.nova.sdk.ui.douyin.DouyinModuleHelper;
import com.huike.nova.sdk.ui.douyin.TicketCodeHelper;
import com.huike.nova.sdk.ui.douyin.viewmodel.DouyinOpenApiViewModel;
import com.huike.nova.sdk.widget.NovaTitleBarView;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import java.util.concurrent.TimeUnit;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 -2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002-.B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0007J\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\u001f\u001a\u00020 J\u0010\u0010!\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\"H\u0007J\b\u0010#\u001a\u00020\u0013H\u0016J\b\u0010$\u001a\u00020\u0013H\u0016J\u0012\u0010%\u001a\u00020\u00132\b\u0010&\u001a\u0004\u0018\u00010\u0006H\u0016J\u0010\u0010'\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00132\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010+\u001a\u00020\u00132\u0006\u0010,\u001a\u00020 H\u0002R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\"\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0015\"\u0004\b\u001a\u0010\u0017\u00a8\u0006/"}, d2={"Lcom/huike/nova/sdk/ui/douyin/presenter/DouyinTicketScanPresenter;", "Lcom/huike/nova/sdk/ui/base/NovaSdkBaseViewModelPresenter;", "Lcom/huike/nova/sdk/ui/douyin/viewmodel/DouyinOpenApiViewModel;", "activity", "Landroidx/fragment/app/FragmentActivity;", "rootView", "Landroid/view/View;", "viewModel", "(Landroidx/fragment/app/FragmentActivity;Landroid/view/View;Lcom/huike/nova/sdk/ui/douyin/viewmodel/DouyinOpenApiViewModel;)V", "errorDisposable", "Lio/reactivex/disposables/Disposable;", "mBinding", "Lcom/huike/nova/sdk/ui/douyin/presenter/DouyinTicketScanPresenter$VH;", "getMBinding", "()Lcom/huike/nova/sdk/ui/douyin/presenter/DouyinTicketScanPresenter$VH;", "mBinding$delegate", "Lkotlin/Lazy;", "startScanning", "Lkotlin/Function0;", "", "getStartScanning", "()Lkotlin/jvm/functions/Function0;", "setStartScanning", "(Lkotlin/jvm/functions/Function0;)V", "stopScanning", "getStopScanning", "setStopScanning", "handleRescanSuccessEvt", "event", "Lcom/huike/nova/sdk/eventbus/NovaSdkVerifyRescanEvent;", "handleScanCode", "code", "", "handleVerifySuccessEvt", "Lcom/huike/nova/sdk/eventbus/NovaSdkVerifySuccessEvent;", "initObserver", "initView", "onClick", "v", "onCreate", "owner", "Landroidx/lifecycle/LifecycleOwner;", "onDestroy", "showLastScanError", "errorMsg", "Companion", "VH", "nova-sdk_debug"})
public final class DouyinTicketScanPresenter
extends NovaSdkBaseViewModelPresenter<DouyinOpenApiViewModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private Function0<Unit> stopScanning;
    @Nullable
    private Function0<Unit> startScanning;
    @Nullable
    private Disposable errorDisposable;
    @NotNull
    private final Lazy mBinding$delegate;
    @NotNull
    private static final String LogTag = "DouyinTicketScanPresenter";

    public DouyinTicketScanPresenter(@NotNull FragmentActivity activity, @NotNull View rootView, @NotNull DouyinOpenApiViewModel viewModel2) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
        Intrinsics.checkNotNullParameter((Object)((Object)viewModel2), (String)"viewModel");
        super(activity, rootView, (NovaSdkBaseViewModel)viewModel2);
        this.mBinding$delegate = LazyKt.lazy((Function0)((Function0)new Function0<VH>(this){
            final /* synthetic */ DouyinTicketScanPresenter this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final VH invoke() {
                return new VH(this.this$0.getRootView());
            }
        }));
    }

    @Nullable
    public final Function0<Unit> getStopScanning() {
        return this.stopScanning;
    }

    public final void setStopScanning(@Nullable Function0<Unit> function0) {
        this.stopScanning = function0;
    }

    @Nullable
    public final Function0<Unit> getStartScanning() {
        return this.startScanning;
    }

    public final void setStartScanning(@Nullable Function0<Unit> function0) {
        this.startScanning = function0;
    }

    private final VH getMBinding() {
        Lazy lazy = this.mBinding$delegate;
        return (VH)lazy.getValue();
    }

    @Override
    public void onCreate(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super.onCreate(owner);
        NovaSdkEventBusManager.register$default(NovaSdkEventBusManager.INSTANCE, this, null, 2, null);
    }

    @Override
    public void onDestroy(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super.onDestroy(owner);
        NovaSdkEventBusManager.INSTANCE.unregister(this);
    }

    @Override
    public void initView() {
        NovaTitleBarView this_$iv = this.getMBinding().getVTitleBar();
        boolean $i$f$setTitleBarClickListener = false;
        this_$iv.setOnTitleBarClickListener(new NovaTitleBarView.OnTitleBarClickListener(this){
            final /* synthetic */ DouyinTicketScanPresenter this$0;
            {
                this.this$0 = douyinTicketScanPresenter;
            }

            public void onBackClick(@NotNull View view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                View it = view;
                boolean bl = false;
                this.this$0.finishCurrentActivity();
            }

            public void onSubIconClick(@NotNull View view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            }

            public void onRightIconClick(@NotNull View view) {
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            }
        });
        this.handleClicks((View)this.getMBinding().getClVerifyCode(), this);
        this.getMBinding().getTvSdkVersion().setText((CharSequence)"1.0.3.3.20240805");
    }

    @Override
    public void initObserver() {
        block0: {
            LifecycleOwner lifecycleOwner;
            LifecycleOwner lifecycleOwner2 = this.getMLifecycleOwner();
            if (lifecycleOwner2 == null) break block0;
            LifecycleOwner $this$initObserver_u24lambda_u243 = lifecycleOwner = lifecycleOwner2;
            boolean bl = false;
            ((DouyinOpenApiViewModel)((Object)this.getMViewModel())).getTicketScanResult().observe($this$initObserver_u24lambda_u243, arg_0 -> DouyinTicketScanPresenter.initObserver$lambda$3$lambda$1((Function1)new Function1<DouyinScanCodeResponse, Unit>(this){
                final /* synthetic */ DouyinTicketScanPresenter this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(DouyinScanCodeResponse it) {
                    Context context = this.this$0.getMContext();
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    NovaSdkPortal.INSTANCE.startExecuteVerifyDouyinTicket(context, it);
                }
            }, arg_0));
            ((DouyinOpenApiViewModel)((Object)this.getMViewModel())).getTicketScanErrorResult().observe($this$initObserver_u24lambda_u243, arg_0 -> DouyinTicketScanPresenter.initObserver$lambda$3$lambda$2((Function1)new Function1<String, Unit>(this){
                final /* synthetic */ DouyinTicketScanPresenter this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                public final void invoke(String it) {
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    DouyinTicketScanPresenter.access$showLastScanError(this.this$0, it);
                }
            }, arg_0));
        }
    }

    @Subscribe
    public final void handleVerifySuccessEvt(@NotNull NovaSdkVerifySuccessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object[] objectArray = new Object[]{JsonExtKt.toJsonString(event)};
        FsLogUtil.debug((String)":= DouyinTicketScanPresenter", (String)"handleVerifySuccessEvt: {}", (Object[])objectArray);
        this.finishCurrentActivity();
    }

    @Subscribe
    public final void handleRescanSuccessEvt(@NotNull NovaSdkVerifyRescanEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.finishCurrentActivity();
    }

    private final void showLastScanError(String errorMsg) {
        Function0<Unit> function0 = this.startScanning;
        if (function0 != null) {
            function0.invoke();
        }
        Disposable disposable = this.errorDisposable;
        if (disposable != null) {
            disposable.dispose();
        }
        Object[] objectArray = new Object[]{errorMsg};
        this.getMBinding().getTvScanCodeHint().setText((CharSequence)ContextExtKt.getResString(R.string.verify_scan_error, objectArray));
        this.errorDisposable = Observable.timer((long)2L, (TimeUnit)TimeUnit.SECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe(arg_0 -> DouyinTicketScanPresenter.showLastScanError$lambda$4((Function1)new Function1<Long, Unit>(this){
            final /* synthetic */ DouyinTicketScanPresenter this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(Long it) {
                DouyinTicketScanPresenter.access$getMBinding(this.this$0).getTvScanCodeHint().setText((CharSequence)ContextExtKt.getResString(R.string.ticket_scan_hint));
            }
        }, arg_0));
    }

    public final void handleScanCode(@NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        FsLogUtil.info((String)LogTag, (String)("handleScanCode >> " + code), (Object[])new Object[0]);
        Function0<Unit> function0 = this.stopScanning;
        if (function0 != null) {
            function0.invoke();
        }
        switch (WhenMappings.$EnumSwitchMapping$0[TicketCodeHelper.INSTANCE.getOrderChannelTypeByTicketCode(code).ordinal()]) {
            case 1: {
                DouyinTicketEntity entity = DouyinModuleHelper.INSTANCE.parseUrlToDouyinTicketEntity(code);
                if (entity.douyinValidate()) {
                    ((DouyinOpenApiViewModel)((Object)this.getMViewModel())).douyinOpenLoopTicketScan(entity.getEncryptedData(), entity.getOutOrderNo());
                    break;
                }
                this.showLastScanError(ContextExtKt.getResString(R.string.scan_correct_ticket_code));
                break;
            }
            case 2: {
                this.showLastScanError(ContextExtKt.getResString(R.string.scan_correct_ticket_code));
                break;
            }
            case 3: {
                DouyinTicketEntity entity = DouyinModuleHelper.INSTANCE.parseUrlToDouyinTicketEntity(code);
                if (entity.alipayValidate()) {
                    ((DouyinOpenApiViewModel)((Object)this.getMViewModel())).douyinOpenLoopTicketScan(entity.getEncryptedData(), entity.getOutOrderNo());
                    break;
                }
                this.showLastScanError(ContextExtKt.getResString(R.string.common_scan_correct_ticket_code));
                break;
            }
            case 4: {
                ((DouyinOpenApiViewModel)((Object)this.getMViewModel())).douyinOpenLoopTicketInput(code, true);
                break;
            }
            case 5: {
                ((DouyinOpenApiViewModel)((Object)this.getMViewModel())).douyinOpenLoopTicketInput(code, true);
                break;
            }
            default: {
                if (TicketCodeHelper.INSTANCE.isCommonCouponPattern(code)) {
                    ((DouyinOpenApiViewModel)((Object)this.getMViewModel())).douyinOpenLoopTicketInput(code, true);
                }
                this.showLastScanError(ContextExtKt.getResString(R.string.common_scan_correct_ticket_code));
            }
        }
    }

    @Override
    public void onClick(@Nullable View v) {
        View view = v;
        Integer n = view != null ? Integer.valueOf(view.getId()) : null;
        int n2 = R.id.cl_verify_code;
        if (n != null && n == n2) {
            NovaSdkPortal.INSTANCE.startDouyinTicketInputActivity(this.getMContext());
        }
    }

    private static final void initObserver$lambda$3$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void initObserver$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final void showLastScanError$lambda$4(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    public static final /* synthetic */ VH access$getMBinding(DouyinTicketScanPresenter $this) {
        return $this.getMBinding();
    }

    public static final /* synthetic */ void access$showLastScanError(DouyinTicketScanPresenter $this, String errorMsg) {
        $this.showLastScanError(errorMsg);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/huike/nova/sdk/ui/douyin/presenter/DouyinTicketScanPresenter$Companion;", "", "()V", "LogTag", "", "nova-sdk_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Lcom/huike/nova/sdk/ui/douyin/presenter/DouyinTicketScanPresenter$VH;", "Lcom/huike/nova/sdk/ui/base/NovaSdkBaseViewHolderBinding;", "rootView", "Landroid/view/View;", "(Landroid/view/View;)V", "clVerifyCode", "Landroidx/constraintlayout/widget/ConstraintLayout;", "getClVerifyCode", "()Landroidx/constraintlayout/widget/ConstraintLayout;", "tvScanCodeHint", "Landroid/widget/TextView;", "getTvScanCodeHint", "()Landroid/widget/TextView;", "tvSdkVersion", "getTvSdkVersion", "vTitleBar", "Lcom/huike/nova/sdk/widget/NovaTitleBarView;", "getVTitleBar", "()Lcom/huike/nova/sdk/widget/NovaTitleBarView;", "nova-sdk_debug"})
    private static final class VH
    extends NovaSdkBaseViewHolderBinding {
        @NotNull
        private final NovaTitleBarView vTitleBar;
        @NotNull
        private final TextView tvScanCodeHint;
        @NotNull
        private final ConstraintLayout clVerifyCode;
        @NotNull
        private final TextView tvSdkVersion;

        public VH(@NotNull View rootView) {
            Intrinsics.checkNotNullParameter((Object)rootView, (String)"rootView");
            super(rootView);
            this.vTitleBar = (NovaTitleBarView)((Object)this.viewById(R.id.v_title_bar));
            this.tvScanCodeHint = (TextView)this.viewById(R.id.tv_scan_code_hint);
            this.clVerifyCode = (ConstraintLayout)this.viewById(R.id.cl_verify_code);
            this.tvSdkVersion = (TextView)this.viewById(R.id.tv_sdk_version);
        }

        @NotNull
        public final NovaTitleBarView getVTitleBar() {
            return this.vTitleBar;
        }

        @NotNull
        public final TextView getTvScanCodeHint() {
            return this.tvScanCodeHint;
        }

        @NotNull
        public final ConstraintLayout getClVerifyCode() {
            return this.clVerifyCode;
        }

        @NotNull
        public final TextView getTvSdkVersion() {
            return this.tvSdkVersion;
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[OrderChannelType.values().length];
            try {
                nArray[OrderChannelType.DouyinOpenLoop.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrderChannelType.DouyinClosedLoop.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrderChannelType.Alipay.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrderChannelType.FubeiQyk.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OrderChannelType.MeiTuan.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

