/*
 * Decompiled with CFR 0.152.
 */
package com.huike.nova.sdk.ui.douyin;

import com.huike.nova.sdk.constants.enums.OrderChannelType;
import com.huike.nova.sdk.ui.douyin.TicketCodeHelper;
import com.huike.nova.sdk.utils.RegexUtil;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0004J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u000e\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0004J\u0010\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0004H\u0002J\u0010\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u001b\u0010\b\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\f\u0010\r\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\u000e\u001a\u00020\t8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\r\u001a\u0004\b\u000f\u0010\u000bR\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u0012\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/huike/nova/sdk/ui/douyin/TicketCodeHelper;", "", "()V", "AMAP_COUPON_PREFIX", "", "AlipayElements", "", "[Ljava/lang/String;", "CommonCouponPattern", "Ljava/util/regex/Pattern;", "getCommonCouponPattern", "()Ljava/util/regex/Pattern;", "CommonCouponPattern$delegate", "Lkotlin/Lazy;", "DouyinClosedLoopPattern", "getDouyinClosedLoopPattern", "DouyinClosedLoopPattern$delegate", "DouyinOpenLoopElements", "MEITUAN_DIANPING_PREFIX", "QYK_COUPON_PREFIX", "getOrderChannelTypeByTicketCode", "Lcom/huike/nova/sdk/constants/enums/OrderChannelType;", "ticketCode", "isAlipayTicket", "", "isCommonCouponPattern", "isDouyinOpenLoopTicket", "isMeiTuanTicket", "isQykTicket", "nova-sdk_debug"})
public final class TicketCodeHelper {
    @NotNull
    public static final TicketCodeHelper INSTANCE = new TicketCodeHelper();
    @NotNull
    private static final String AMAP_COUPON_PREFIX = "GD";
    @NotNull
    private static final String QYK_COUPON_PREFIX = "QYK";
    @NotNull
    private static final String MEITUAN_DIANPING_PREFIX = "DP";
    @NotNull
    private static final String[] DouyinOpenLoopElements;
    @NotNull
    private static final String[] AlipayElements;
    @NotNull
    private static final Lazy DouyinClosedLoopPattern$delegate;
    @NotNull
    private static final Lazy CommonCouponPattern$delegate;

    private TicketCodeHelper() {
    }

    private final Pattern getDouyinClosedLoopPattern() {
        Lazy lazy = DouyinClosedLoopPattern$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-DouyinClosedLoopPattern>(...)");
        return (Pattern)object;
    }

    private final Pattern getCommonCouponPattern() {
        Lazy lazy = CommonCouponPattern$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-CommonCouponPattern>(...)");
        return (Pattern)object;
    }

    public final boolean isCommonCouponPattern(@NotNull String ticketCode) {
        Intrinsics.checkNotNullParameter((Object)ticketCode, (String)"ticketCode");
        return RegexUtil.INSTANCE.match(this.getCommonCouponPattern(), ticketCode);
    }

    @NotNull
    public final OrderChannelType getOrderChannelTypeByTicketCode(@NotNull String ticketCode) {
        Intrinsics.checkNotNullParameter((Object)ticketCode, (String)"ticketCode");
        return StringsKt.startsWith$default((String)ticketCode, (String)AMAP_COUPON_PREFIX, (boolean)false, (int)2, null) ? OrderChannelType.Amap : (this.isDouyinOpenLoopTicket(ticketCode) ? OrderChannelType.DouyinOpenLoop : (RegexUtil.INSTANCE.match(this.getDouyinClosedLoopPattern(), ticketCode) ? OrderChannelType.DouyinClosedLoop : (this.isAlipayTicket(ticketCode) ? OrderChannelType.Alipay : (this.isQykTicket(ticketCode) ? OrderChannelType.FubeiQyk : (this.isMeiTuanTicket(ticketCode) ? OrderChannelType.MeiTuan : OrderChannelType.UnKnown)))));
    }

    private final boolean isDouyinOpenLoopTicket(String ticketCode) {
        String[] $this$forEach$iv = DouyinOpenLoopElements;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)ticketCode, (CharSequence)it, (boolean)false, (int)2, null)) continue;
            return false;
        }
        return true;
    }

    private final boolean isAlipayTicket(String ticketCode) {
        String[] $this$forEach$iv = AlipayElements;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            String element$iv;
            String it = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            if (StringsKt.contains$default((CharSequence)ticketCode, (CharSequence)it, (boolean)false, (int)2, null)) continue;
            return false;
        }
        return true;
    }

    private final boolean isQykTicket(String ticketCode) {
        return StringsKt.startsWith((String)ticketCode, (String)QYK_COUPON_PREFIX, (boolean)true);
    }

    private final boolean isMeiTuanTicket(String ticketCode) {
        return StringsKt.startsWith((String)ticketCode, (String)MEITUAN_DIANPING_PREFIX, (boolean)true);
    }

    static {
        String[] stringArray = new String[]{"app_id=", "encrypted_data=", "out_order_no="};
        DouyinOpenLoopElements = stringArray;
        stringArray = new String[]{"channel_type=ALIPAY", "app_id=", "out_order_no="};
        AlipayElements = stringArray;
        DouyinClosedLoopPattern$delegate = LazyKt.lazy((Function0)DouyinClosedLoopPattern.2.INSTANCE);
        CommonCouponPattern$delegate = LazyKt.lazy((Function0)CommonCouponPattern.2.INSTANCE);
    }
}

