/*
 * Decompiled with CFR 0.152.
 */
package com.huike.nova.sdk.ui.scan.analyzer;

import android.media.Image;
import android.media.ImageReader;
import androidx.core.util.Supplier;
import com.fshows.android.stark.utils.FsLogUtil;
import com.huike.nova.sdk.NovaSdkConfigKt;
import com.huike.nova.sdk.ext.ContextExtKt;
import com.huike.nova.sdk.ui.scan.analyzer.IBarCodeDecoder;
import com.huike.nova.sdk.ui.scan.analyzer.YuvFormatConverter;
import com.huike.nova.sdk.ui.scan.analyzer.impl.ZXingImageReaderDecoder;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u0000 \u00072\u00020\u0001:\u0001\u0007B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/huike/nova/sdk/ui/scan/analyzer/ImageReaderBarcodeDecoder;", "Lcom/huike/nova/sdk/ui/scan/analyzer/IBarCodeDecoder;", "()V", "analysisImageReader", "", "imageReader", "Landroid/media/ImageReader;", "Companion", "nova-sdk_debug"})
public abstract class ImageReaderBarcodeDecoder
implements IBarCodeDecoder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LogTag = ":= ImageReaderAnalyzer";
    private static volatile boolean onceFlag;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String analysisImageReader(@NotNull ImageReader imageReader) {
        Intrinsics.checkNotNullParameter((Object)imageReader, (String)"imageReader");
        Image image = imageReader.acquireLatestImage();
        if (image != null) {
            AutoCloseable autoCloseable = (AutoCloseable)image;
            Throwable throwable = null;
            try {
                Image it = (Image)autoCloseable;
                boolean bl = false;
                int width = it.getWidth();
                int height = it.getHeight();
                if (ContextExtKt.isDebuggable() && !onceFlag) {
                    FsLogUtil.debug((String)LogTag, (String)("width:" + width + ", height:" + height), (Object[])new Object[0]);
                    onceFlag = true;
                }
                if (35 != imageReader.getImageFormat()) {
                    FsLogUtil.error((String)LogTag, (String)("expect YUV_420_888, now = " + imageReader.getImageFormat()), (Object[])new Object[0]);
                    String string2 = null;
                    return string2;
                }
                int yB = it.getPlanes()[0].getBuffer().remaining();
                byte[] data = new byte[yB + yB / 2];
                if (YuvFormatConverter.INSTANCE.readYuvDataToBuffer(it, 842094169, data)) {
                    Object object;
                    Object object2 = this;
                    try {
                        ImageReaderBarcodeDecoder $this$analysisImageReader_u24lambda_u241_u24lambda_u240 = object2;
                        boolean bl2 = false;
                        object = Result.constructor-impl((Object)$this$analysisImageReader_u24lambda_u241_u24lambda_u240.decode(data, width, height));
                    }
                    catch (Throwable throwable2) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable2));
                    }
                    object2 = object;
                    String string3 = (String)(Result.isFailure-impl((Object)object2) ? null : object2);
                    return string3;
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
            }
        }
        return null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/huike/nova/sdk/ui/scan/analyzer/ImageReaderBarcodeDecoder$Companion;", "", "()V", "LogTag", "", "onceFlag", "", "createDecoder", "Lcom/huike/nova/sdk/ui/scan/analyzer/ImageReaderBarcodeDecoder;", "nova-sdk_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ImageReaderBarcodeDecoder createDecoder() {
            IBarCodeDecoder decoder;
            Supplier<IBarCodeDecoder> supplier = NovaSdkConfigKt.getGlobalSdkConfig().getBarcodeOrQrDecoder();
            IBarCodeDecoder iBarCodeDecoder = supplier != null ? (IBarCodeDecoder)supplier.get() : null;
            if (iBarCodeDecoder == null) {
                iBarCodeDecoder = new ZXingImageReaderDecoder();
            }
            return (decoder = iBarCodeDecoder) instanceof ImageReaderBarcodeDecoder ? (ImageReaderBarcodeDecoder)decoder : (ImageReaderBarcodeDecoder)new ImageReaderBarcodeDecoder(decoder){
                final /* synthetic */ IBarCodeDecoder $decoder;
                {
                    this.$decoder = $decoder;
                }

                @Nullable
                public String decode(@Nullable byte[] data, int width, int height) {
                    return this.$decoder.decode(data, width, height);
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

