/*
 * Decompiled with CFR 0.152.
 */
package com.huike.nova.sdk.ext;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.Configuration;
import android.os.Build;
import android.view.LayoutInflater;
import androidx.annotation.StringRes;
import com.google.common.io.ByteStreams;
import com.hjq.toast.Toaster;
import com.huike.nova.sdk.NovaSdkConfigKt;
import com.huike.nova.sdk.NovaSdkInitializer;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0000\u001a\u0012\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0000\u001a/\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00052\u0016\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\b0\u0007\"\u0004\u0018\u00010\bH\u0000\u00a2\u0006\u0002\u0010\t\u001a\b\u0010\n\u001a\u00020\u000bH\u0000\u001a\u0012\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0003H\u0000\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0001H\u0000\u001a\f\u0010\u0011\u001a\u0004\u0018\u00010\u0012*\u00020\u0003\u001a\n\u0010\u0013\u001a\u00020\u0003*\u00020\u0003\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0015H\u0001\u00a8\u0006\u0016"}, d2={"applicationContext", "Landroid/content/Context;", "getResString", "", "resId", "", "formatArg", "", "", "(I[Ljava/lang/Object;)Ljava/lang/String;", "isDebuggable", "", "showToast", "", "content", "getLayoutInflater", "Landroid/view/LayoutInflater;", "loadAssetsAsByteArray", "", "loadAssetsAsText", "wrap", "Landroid/content/ContextWrapper;", "nova-sdk_debug"})
public final class ContextExtKt {
    @NotNull
    public static final Context applicationContext() {
        return NovaSdkInitializer.INSTANCE.getApplicationContext$nova_sdk_debug();
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    @NotNull
    public static final ContextWrapper wrap(@NotNull ContextWrapper $this$wrap) {
        ContextWrapper contextWrapper;
        Intrinsics.checkNotNullParameter((Object)$this$wrap, (String)"<this>");
        Configuration configuration = $this$wrap.getBaseContext().getResources().getConfiguration();
        configuration.fontScale = 1.0f;
        if (Build.VERSION.SDK_INT >= 17) {
            contextWrapper = new ContextWrapper($this$wrap.getBaseContext().createConfigurationContext(configuration));
        } else {
            $this$wrap.getBaseContext().getResources().updateConfiguration(configuration, $this$wrap.getBaseContext().getResources().getDisplayMetrics());
            contextWrapper = new ContextWrapper($this$wrap.getBaseContext());
        }
        return contextWrapper;
    }

    public static final boolean isDebuggable() {
        return NovaSdkConfigKt.getGlobalSdkConfig().getDebuggable();
    }

    @NotNull
    public static final String getResString(@StringRes int resId) {
        String string = ContextExtKt.applicationContext().getString(resId);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"applicationContext().getString(resId)");
        return string;
    }

    @NotNull
    public static final String getResString(@StringRes int resId, Object ... formatArg) {
        Intrinsics.checkNotNullParameter((Object)formatArg, (String)"formatArg");
        String string = ContextExtKt.applicationContext().getString(resId, Arrays.copyOf(formatArg, formatArg.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"applicationContext().getString(resId, *formatArg)");
        return string;
    }

    public static final void showToast(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        if (NovaSdkConfigKt.getGlobalSdkConfig().getToastMaker() != null) {
            Function1<String, Unit> function1 = NovaSdkConfigKt.getGlobalSdkConfig().getToastMaker();
            if (function1 != null) {
                function1.invoke((Object)content);
            }
        } else {
            Toaster.show((CharSequence)content);
        }
    }

    public static final void showToast(@StringRes int resId) {
        String content = ContextExtKt.getResString(resId);
        ContextExtKt.showToast(content);
    }

    @NotNull
    public static final LayoutInflater getLayoutInflater(@NotNull Context $this$getLayoutInflater) {
        Intrinsics.checkNotNullParameter((Object)$this$getLayoutInflater, (String)"<this>");
        LayoutInflater layoutInflater = LayoutInflater.from((Context)$this$getLayoutInflater);
        Intrinsics.checkNotNullExpressionValue((Object)layoutInflater, (String)"from(this)");
        return layoutInflater;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final String loadAssetsAsText(@NotNull String $this$loadAssetsAsText) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$loadAssetsAsText, (String)"<this>");
        Object object2 = $this$loadAssetsAsText;
        try {
            String string;
            String $this$loadAssetsAsText_u24lambda_u241 = object2;
            boolean bl = false;
            Closeable closeable = ContextExtKt.applicationContext().getAssets().open($this$loadAssetsAsText_u24lambda_u241);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                byte[] byArray = ByteStreams.toByteArray((InputStream)it);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(it)");
                byte[] byArray2 = byArray;
                string = new String(byArray2, Charsets.UTF_8);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            object = Result.constructor-impl((Object)string);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = "";
        return (String)(Result.isFailure-impl((Object)object2) ? object : object2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final byte[] loadAssetsAsByteArray(@NotNull String $this$loadAssetsAsByteArray) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$loadAssetsAsByteArray, (String)"<this>");
        Object object2 = $this$loadAssetsAsByteArray;
        try {
            byte[] byArray;
            String $this$loadAssetsAsByteArray_u24lambda_u243 = object2;
            boolean bl = false;
            Closeable closeable = ContextExtKt.applicationContext().getAssets().open($this$loadAssetsAsByteArray_u24lambda_u243);
            Throwable throwable = null;
            try {
                InputStream it = (InputStream)closeable;
                boolean bl2 = false;
                byArray = ByteStreams.toByteArray((InputStream)it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            object = Result.constructor-impl((Object)byArray);
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        object = null;
        return (byte[])(Result.isFailure-impl((Object)object2) ? object : object2);
    }
}

