/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils.globalconfig;

import android.app.Application;
import android.content.Context;
import android.net.Uri;
import androidx.work.Constraints;
import androidx.work.ExistingWorkPolicy;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.fshows.android.stark.FsFoundationInitializer;
import com.fshows.android.stark.http.HttpUtils;
import com.fshows.android.stark.utils.FsLogUtil;
import com.fshows.android.stark.utils.Prefs;
import com.fshows.android.stark.utils.globalconfig.GlobalConfigApi;
import com.fshows.android.stark.utils.globalconfig.GlobalConfigNetProvider;
import com.fshows.android.stark.utils.globalconfig.GlobalConfigSyncWorker;
import com.google.gson.JsonObject;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.disposables.Disposable;
import java.io.InputStreamReader;
import java.io.Reader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u00011B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fJ%\u0010\u001c\u001a\u0004\u0018\u0001H\u001d\"\u0004\b\u0000\u0010\u001d2\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u0002H\u001dH\u0007\u00a2\u0006\u0002\u0010 J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0017H\u0002J\b\u0010#\u001a\u00020\tH\u0002J \u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\t2\u0006\u0010\"\u001a\u00020\u0017H\u0007J\u001a\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u00152\b\u0010*\u001a\u0004\u0018\u00010\u0015H\u0002J\b\u0010+\u001a\u00020\u001aH\u0002J\u000e\u0010,\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u000fJ\u0010\u0010-\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&H\u0007J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u0002000/H\u0002R\u001e\u0010\u0003\u001a\u0010\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\nR\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u001e\u0010\r\u001a\u0012\u0012\u0004\u0012\u00020\u000f0\u000ej\b\u0012\u0004\u0012\u00020\u000f`\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/fshows/android/stark/utils/globalconfig/GlobalConfig;", "", "()V", "EndpointUri", "", "Landroid/net/Uri;", "kotlin.jvm.PlatformType", "[Landroid/net/Uri;", "EnvName", "", "[Ljava/lang/String;", "GlobalConfigAssetFile", "LogTag", "configChangedListeners", "Ljava/util/ArrayList;", "Lcom/fshows/android/stark/utils/globalconfig/GlobalConfig$ConfigChangedListener;", "Lkotlin/collections/ArrayList;", "globalConfigSharedPreferenceKey", "mApplication", "Landroid/app/Application;", "mConfig", "Lorg/json/JSONObject;", "mEnv", "", "mPath", "addConfigChangedListener", "", "listener", "getConfig", "T", "key", "defaultVal", "(Ljava/lang/String;Ljava/lang/Object;)Ljava/lang/Object;", "getEnv", "env", "getGlobalConfigKey", "init", "context", "Landroid/content/Context;", "path", "mergeJsonObject", "source", "target", "notifyChanges", "removeConfigChangedListener", "scheduleSync", "syncGlobalConfig", "Lio/reactivex/Observable;", "", "ConfigChangedListener", "stark_debug"})
public final class GlobalConfig {
    @NotNull
    public static final GlobalConfig INSTANCE = new GlobalConfig();
    @NotNull
    private static final String LogTag = "Stark.GlobalConfig";
    @NotNull
    private static final Uri[] EndpointUri;
    @NotNull
    private static final String[] EnvName;
    @NotNull
    private static final String GlobalConfigAssetFile = "config/global-config%ENV_KEY%.json";
    @NotNull
    private static String globalConfigSharedPreferenceKey;
    private static Application mApplication;
    private static JSONObject mConfig;
    private static int mEnv;
    @NotNull
    private static String mPath;
    @NotNull
    private static final ArrayList<ConfigChangedListener> configChangedListeners;

    private GlobalConfig() {
    }

    public final synchronized void addConfigChangedListener(@NotNull ConfigChangedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        if (!configChangedListeners.contains(listener)) {
            configChangedListeners.add(listener);
        }
    }

    public final synchronized void removeConfigChangedListener(@NotNull ConfigChangedListener listener) {
        Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
        configChangedListeners.remove(listener);
    }

    private final int getEnv(int env) {
        if (!FsFoundationInitializer.isDebug()) {
            return 2;
        }
        return env;
    }

    private final String getGlobalConfigKey() {
        String env = EnvName[mEnv];
        CharSequence charSequence = env;
        boolean bl = false;
        if (charSequence.length() == 0) {
            return globalConfigSharedPreferenceKey;
        }
        return globalConfigSharedPreferenceKey + '_' + env;
    }

    private final synchronized JSONObject mergeJsonObject(JSONObject source, JSONObject target) {
        if (target == null) {
            return source;
        }
        Iterator iterator = source.keys();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"source.keys()");
        boolean bl = false;
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            String key = (String)iterator2.next();
            Object value = source.get(key);
            if (!target.has(key)) {
                target.put(key, value);
                continue;
            }
            Object object = value;
            if (object instanceof JSONObject) {
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                JSONObject targetValue = this.mergeJsonObject((JSONObject)value, target.getJSONObject(key));
                target.put(key, (Object)targetValue);
                continue;
            }
            if (object instanceof JSONArray) {
                Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                int n = 0;
                JSONArray valueArray = (JSONArray)value;
                int n2 = valueArray.length();
                if (n >= n2) continue;
                do {
                    int i;
                    Object object2;
                    if ((object2 = valueArray.get(i = n++)) instanceof JsonObject) {
                        Object object3 = valueArray.get(i);
                        if (object3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.json.JSONObject");
                        }
                        JSONObject obj = (JSONObject)object3;
                        Object object4 = target.getJSONArray(key).get(i);
                        if (object4 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type org.json.JSONObject");
                        }
                        JSONObject targetValue = this.mergeJsonObject(obj, (JSONObject)object4);
                        target.getJSONArray(key).put(i, (Object)targetValue);
                        continue;
                    }
                    target.put(key, (Object)valueArray);
                } while (n < n2);
                continue;
            }
            target.put(key, value);
        }
        return target;
    }

    @JvmStatic
    @NotNull
    public static final GlobalConfig init(@NotNull Context context, @NotNull String path, int env) {
        block10: {
            Object object;
            boolean bl;
            Object object2;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Context context2 = context.getApplicationContext();
            if (context2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.app.Application");
            }
            mApplication = (Application)context2;
            String localConfigFile = null;
            localConfigFile = "";
            GlobalConfig globalConfig = INSTANCE;
            boolean bl2 = false;
            try {
                object2 = Result.Companion;
                GlobalConfig $this$init_u24lambda_u2d0 = globalConfig;
                boolean bl3 = false;
                CharSequence charSequence = EnvName[env];
                Locale locale = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
                boolean bl4 = false;
                String string = charSequence;
                boolean bl5 = false;
                String string2 = string;
                if (string2 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string3 = string2.toLowerCase(locale);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.String).toLowerCase(locale)");
                String envName = string3;
                charSequence = envName;
                bl = false;
                localConfigFile = charSequence.length() == 0 ? StringsKt.replace$default((String)GlobalConfigAssetFile, (String)"%ENV_KEY%", (String)Intrinsics.stringPlus((String)"-", (Object)envName), (boolean)false, (int)4, null) : StringsKt.replace$default((String)GlobalConfigAssetFile, (String)"%ENV_KEY%", (String)"", (boolean)false, (int)4, null);
                FsLogUtil.info(Intrinsics.stringPlus((String)"\u914d\u7f6e\u6587\u4ef6\u8bfb\u53d6\uff1a --> ", (Object)localConfigFile), new Object[0]);
                InputStreamReader reader = new InputStreamReader(context.getAssets().open(localConfigFile), Charsets.UTF_8);
                mConfig = new JSONObject(TextStreamsKt.readText((Reader)reader));
                $this$init_u24lambda_u2d0 = Unit.INSTANCE;
                bl3 = false;
                object2 = Result.constructor-impl((Object)$this$init_u24lambda_u2d0);
            }
            catch (Throwable $this$init_u24lambda_u2d0) {
                Result.Companion bl3 = Result.Companion;
                boolean bl6 = false;
                object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$this$init_u24lambda_u2d0));
            }
            globalConfig = object2;
            bl2 = false;
            boolean bl7 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)globalConfig);
            if (throwable != null) {
                Throwable throwable2 = throwable;
                boolean $this$init_u24lambda_u2d0 = false;
                boolean bl3 = false;
                Throwable throwable3 = throwable2;
                bl = false;
                Throwable it = throwable3;
                boolean bl8 = false;
                FsLogUtil.warn(LogTag, "\u8bfb\u53d6" + localConfigFile + " \u5931\u8d25\uff0c" + it.getMessage(), new Object[0]);
                mConfig = new JSONObject();
            }
            mEnv = INSTANCE.getEnv(env);
            mPath = path;
            Prefs.init(context);
            globalConfig = INSTANCE;
            bl2 = false;
            try {
                object = Result.Companion;
                GlobalConfig $this$init_u24lambda_u2d3 = globalConfig;
                boolean bl9 = false;
                String string = Prefs.getStringPreference($this$init_u24lambda_u2d3.getGlobalConfigKey(), "");
                bl = false;
                boolean it = false;
                String $this$init_u24lambda_u2d3_u24lambda_u2d2 = string;
                boolean bl10 = false;
                CharSequence charSequence = $this$init_u24lambda_u2d3_u24lambda_u2d2;
                boolean bl11 = false;
                boolean bl12 = false;
                if (!(charSequence == null || charSequence.length() == 0)) {
                    CharSequence charSequence2;
                    JSONObject jSONObject = new JSONObject($this$init_u24lambda_u2d3_u24lambda_u2d2);
                    charSequence = mConfig;
                    if (charSequence == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"mConfig");
                        charSequence2 = null;
                    } else {
                        charSequence2 = charSequence;
                    }
                    mConfig = $this$init_u24lambda_u2d3.mergeJsonObject(jSONObject, (JSONObject)charSequence2);
                }
                $this$init_u24lambda_u2d3.notifyChanges();
                GlobalConfig.scheduleSync(context);
                Unit unit = Unit.INSTANCE;
                boolean bl13 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable4) {
                Result.Companion companion = Result.Companion;
                boolean bl14 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable4));
            }
            globalConfig = object;
            bl2 = false;
            boolean bl15 = false;
            Throwable throwable5 = Result.exceptionOrNull-impl((Object)globalConfig);
            if (throwable5 == null) break block10;
            Throwable throwable6 = throwable5;
            boolean bl16 = false;
            boolean bl17 = false;
            Throwable throwable7 = throwable6;
            bl = false;
            Throwable it = throwable7;
            boolean bl18 = false;
            it.printStackTrace();
            mConfig = new JSONObject();
        }
        return INSTANCE;
    }

    @JvmStatic
    public static final void scheduleSync(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Disposable d = INSTANCE.syncGlobalConfig().subscribe(arg_0 -> GlobalConfig.scheduleSync$lambda-5(context, arg_0));
    }

    private final void notifyChanges() {
        Iterable $this$forEach$iv = configChangedListeners;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            JSONObject jSONObject;
            ConfigChangedListener it = (ConfigChangedListener)element$iv;
            boolean bl = false;
            JSONObject jSONObject2 = mConfig;
            if (jSONObject2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mConfig");
                jSONObject = null;
            } else {
                jSONObject = jSONObject2;
            }
            it.onChanged(jSONObject);
        }
    }

    private final Observable<Boolean> syncGlobalConfig() {
        Observable observable = Observable.create(GlobalConfig::syncGlobalConfig$lambda-9);
        Intrinsics.checkNotNullExpressionValue((Object)observable, (String)"create { emitter ->\n    \u2026)\n            }\n        }");
        return observable;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Nullable
    public static final <T> T getConfig(@NotNull String key, T defaultVal) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        GlobalConfig globalConfig = INSTANCE;
        boolean bl = false;
        try {
            JSONObject jSONObject;
            object = Result.Companion;
            GlobalConfig $this$getConfig_u24lambda_u2d11 = globalConfig;
            boolean bl2 = false;
            String[] stringArray = new String[]{"."};
            List list = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)key, (String[])stringArray, (boolean)false, (int)0, (int)6, null));
            Object json = null;
            JSONObject jSONObject2 = mConfig;
            if (jSONObject2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mConfig");
                jSONObject = null;
            } else {
                jSONObject = jSONObject2;
            }
            json = jSONObject;
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                Object object2;
                Object object3;
                void key2;
                int n = index$iv++;
                boolean bl3 = false;
                if (n < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv;
                int index = n;
                boolean bl4 = false;
                if (index < list.size() - 1) {
                    object3 = json.getJSONObject((String)key2);
                    Intrinsics.checkNotNullExpressionValue(object3, (String)"json.getJSONObject(key)");
                    json = object3;
                    continue;
                }
                object3 = defaultVal;
                if (object3 instanceof String) {
                    object2 = json.optString((String)key2, (String)defaultVal);
                } else if (object3 instanceof Integer) {
                    object2 = json.optInt((String)key2, ((Number)defaultVal).intValue());
                } else if (object3 instanceof Long) {
                    object2 = json.optLong((String)key2, ((Number)defaultVal).longValue());
                } else if (object3 instanceof Boolean) {
                    object2 = json.optBoolean((String)key2, ((Boolean)defaultVal).booleanValue());
                } else if (object3 instanceof Float) {
                    object2 = Float.valueOf((float)json.optDouble((String)key2, (double)((Number)defaultVal).floatValue()));
                } else if (object3 instanceof Double) {
                    object2 = json.optDouble((String)key2, ((Number)defaultVal).doubleValue());
                } else if (object3 instanceof BigDecimal) {
                    double d = json.optDouble((String)key2, ((BigDecimal)defaultVal).doubleValue());
                    boolean bl5 = false;
                    object2 = new BigDecimal(String.valueOf(d));
                } else if (object3 instanceof JSONObject) {
                    object2 = json.optJSONObject((String)key2);
                } else {
                    if (defaultVal == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Any");
                    }
                    object2 = defaultVal;
                }
                return (T)object2;
            }
            Unit unit = Unit.INSTANCE;
            boolean bl6 = false;
            object = Result.constructor-impl((Object)unit);
        }
        catch (Throwable throwable) {
            Result.Companion companion = Result.Companion;
            boolean bl7 = false;
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        globalConfig = object;
        bl = false;
        boolean bl8 = false;
        Throwable throwable = Result.exceptionOrNull-impl((Object)globalConfig);
        if (throwable != null) {
            Throwable throwable2 = throwable;
            boolean bl9 = false;
            boolean bl10 = false;
            Throwable throwable3 = throwable2;
            boolean bl11 = false;
            Throwable it = throwable3;
            boolean bl12 = false;
            return defaultVal;
        }
        return null;
    }

    private static final void scheduleSync$lambda-5(Context $context, Boolean it) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        WorkManager workManager = WorkManager.getInstance((Context)$context);
        Intrinsics.checkNotNullExpressionValue((Object)workManager, (String)"getInstance(context)");
        WorkManager workManager2 = workManager;
        OneTimeWorkRequest.Builder builder = new OneTimeWorkRequest.Builder(GlobalConfigSyncWorker.class);
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        WorkRequest workRequest = ((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)builder.setInitialDelay(it != false ? 60L : 30L, TimeUnit.SECONDS)).setConstraints(Constraints.NONE)).build();
        Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"Builder(GlobalConfigSync\u2026Constraints.NONE).build()");
        OneTimeWorkRequest workRequest2 = (OneTimeWorkRequest)workRequest;
        workManager2.enqueueUniqueWork("SYNC-GLOBAL-CFG", ExistingWorkPolicy.REPLACE, workRequest2);
    }

    private static final void syncGlobalConfig$lambda-9(ObservableEmitter emitter) {
        block3: {
            Object object;
            Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
            GlobalConfig globalConfig = INSTANCE;
            boolean bl = false;
            try {
                object = Result.Companion;
                GlobalConfig $this$syncGlobalConfig_u24lambda_u2d9_u24lambda_u2d7 = globalConfig;
                boolean bl2 = false;
                Uri endpointUri = EndpointUri[mEnv];
                String path = mPath;
                Uri url = Uri.withAppendedPath((Uri)endpointUri, (String)path);
                GlobalConfigApi api = HttpUtils.getInstance().get(EndpointUri[mEnv].toString(), new GlobalConfigNetProvider(), GlobalConfigApi.class);
                Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"_t", (Object)String.valueOf(System.currentTimeMillis()))};
                Call<ResponseBody> request = api.getResponse(path, MapsKt.hashMapOf((Pair[])pairArray));
                if (request == null) {
                    emitter.onNext((Object)false);
                    return;
                }
                request.enqueue((Callback)new Callback<ResponseBody>($this$syncGlobalConfig_u24lambda_u2d9_u24lambda_u2d7, (ObservableEmitter<Boolean>)emitter, url){
                    final /* synthetic */ GlobalConfig $this_runCatching;
                    final /* synthetic */ ObservableEmitter<Boolean> $emitter;
                    final /* synthetic */ Uri $url;
                    {
                        this.$this_runCatching = $receiver;
                        this.$emitter = $emitter;
                        this.$url = $url;
                    }

                    public void onResponse(@NotNull Call<ResponseBody> call, @NotNull Response<ResponseBody> response) {
                        block6: {
                            Object object;
                            Intrinsics.checkNotNullParameter(call, (String)"call");
                            Intrinsics.checkNotNullParameter(response, (String)"response");
                            Object object2 = response;
                            GlobalConfig globalConfig = this.$this_runCatching;
                            ObservableEmitter<Boolean> observableEmitter = this.$emitter;
                            boolean bl = false;
                            try {
                                ResponseBody responseBody;
                                String string;
                                object = Result.Companion;
                                Object $this$onResponse_u24lambda_u2d0 = object2;
                                boolean bl2 = false;
                                ResponseBody responseBody2 = (ResponseBody)$this$onResponse_u24lambda_u2d0.body();
                                String string2 = string = responseBody2 == null ? null : responseBody2.string();
                                if (string == null) {
                                    throw new NullPointerException();
                                }
                                String body = string;
                                JSONObject config = new JSONObject(body);
                                responseBody2 = GlobalConfig.access$getMConfig$p();
                                if (responseBody2 == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"mConfig");
                                    responseBody = null;
                                } else {
                                    responseBody = responseBody2;
                                }
                                GlobalConfig.access$setMConfig$p(GlobalConfig.access$mergeJsonObject(globalConfig, config, (JSONObject)responseBody));
                                String key = GlobalConfig.access$getGlobalConfigKey(globalConfig);
                                String p = Prefs.getInstance().getString(key, "");
                                if (!Intrinsics.areEqual((Object)p, (Object)config.toString())) {
                                    GlobalConfig.access$notifyChanges(globalConfig);
                                    Prefs.getInstance().edit().putString(key, config.toString()).apply();
                                }
                                observableEmitter.onNext((Object)true);
                                Unit unit = Unit.INSTANCE;
                                boolean bl3 = false;
                                object = Result.constructor-impl((Object)unit);
                            }
                            catch (Throwable throwable) {
                                Result.Companion companion = Result.Companion;
                                boolean bl4 = false;
                                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                            }
                            object2 = object;
                            globalConfig = this.$url;
                            observableEmitter = this.$emitter;
                            bl = false;
                            boolean bl5 = false;
                            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                            if (throwable == null) break block6;
                            Throwable throwable2 = throwable;
                            boolean bl6 = false;
                            boolean bl7 = false;
                            Throwable throwable3 = throwable2;
                            boolean bl8 = false;
                            Throwable it = throwable3;
                            boolean bl9 = false;
                            FsLogUtil.error("response process " + globalConfig + " error, " + it, new Object[0]);
                            observableEmitter.onNext((Object)false);
                        }
                    }

                    public void onFailure(@NotNull Call<ResponseBody> call, @NotNull Throwable throwable) {
                        Intrinsics.checkNotNullParameter(call, (String)"call");
                        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
                        FsLogUtil.error("request " + this.$url + " error, " + throwable, new Object[0]);
                        this.$emitter.onNext((Object)false);
                    }
                });
                Unit unit = Unit.INSTANCE;
                boolean bl3 = false;
                object = Result.constructor-impl((Object)unit);
            }
            catch (Throwable throwable) {
                Result.Companion companion = Result.Companion;
                boolean bl4 = false;
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            globalConfig = object;
            bl = false;
            boolean bl5 = false;
            Throwable throwable = Result.exceptionOrNull-impl((Object)globalConfig);
            if (throwable == null) break block3;
            Throwable throwable2 = throwable;
            boolean bl6 = false;
            boolean bl7 = false;
            Throwable throwable3 = throwable2;
            boolean bl8 = false;
            Throwable it = throwable3;
            boolean bl9 = false;
            FsLogUtil.error("sync GlobalConfig " + mPath + " error", it, new Object[0]);
            emitter.onNext((Object)false);
        }
    }

    public static final /* synthetic */ void access$setMConfig$p(JSONObject jSONObject) {
        mConfig = jSONObject;
    }

    public static final /* synthetic */ JSONObject access$mergeJsonObject(GlobalConfig $this, JSONObject source, JSONObject target) {
        return $this.mergeJsonObject(source, target);
    }

    public static final /* synthetic */ JSONObject access$getMConfig$p() {
        return mConfig;
    }

    public static final /* synthetic */ String access$getGlobalConfigKey(GlobalConfig $this) {
        return $this.getGlobalConfigKey();
    }

    public static final /* synthetic */ void access$notifyChanges(GlobalConfig $this) {
        $this.notifyChanges();
    }

    static {
        Object[] objectArray = new Uri[]{Uri.parse((String)"https://fshows-app-test.oss-cn-hangzhou.aliyuncs.com/"), Uri.parse((String)"https://fshows-app-pre.oss-cn-hangzhou.aliyuncs.com/"), Uri.parse((String)"https://fshows-app-pro.oss-cn-hangzhou.aliyuncs.com/")};
        EndpointUri = objectArray;
        objectArray = new String[]{"Dev", "Beta", ""};
        EnvName = objectArray;
        globalConfigSharedPreferenceKey = "stark.global_config";
        mEnv = 2;
        mPath = "";
        boolean bl = false;
        configChangedListeners = new ArrayList();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/fshows/android/stark/utils/globalconfig/GlobalConfig$ConfigChangedListener;", "", "onChanged", "", "config", "Lorg/json/JSONObject;", "stark_debug"})
    public static interface ConfigChangedListener {
        public void onChanged(@NotNull JSONObject var1);
    }
}

