/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import android.annotation.SuppressLint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SysPropertyUtil {
    public static final String GET_EMUI_SYSTEM_VERSION = "ro.build.version.emui";
    public static final String GET_MIUI_SYSTEM_VERSION_CODE = "ro.miui.ui.version.code";
    public static final String GET_MIUI_SYSTEM_VERSION_NAME = "ro.miui.ui.version.name";
    public static final String GET_MIUI_SYSTEM_INTERNAL_STORAGE = "ro.miui.internal.storage";
    public static final String GET_OPPO_SYSTEM_VERSION = "ro.build.version.opporom";
    public static final String GET_VIVO_SYSTEM_DISPLAY_ID = "ro.vivo.os.build.display.id";
    public static final String GET_FLYME_SYSTEM_ICON = "persist.sys.use.flyme.icon";
    public static final String GET_FLYME_SYSTEM_SETUP_WIZARD = "ro.meizu.setupwizard.flyme";
    public static final String GET_FLYME_SYSTEM_PUBILSHED = "ro.flyme.published";
    public static final String GET_SYSTEM_DISPLAY_ID = "ro.build.display.id";
    public static final String GET_SYSTEM_VERSION_INCREMENTAL = "ro.build.version.incremental";
    public static final String GET_SYSTEM_RO_SERIALNO = "ro.serialno";
    public static final String GET_SYSTEM_SMARTISAN_VERSION = "ro.smartisan.version";
    public static final String GET_SUNMI_SERIAL = "ro.sunmi.serial";
    public static final String GET_LANDI_SYSTEM_VERSION = "ro.epay.ota.ver";
    private static SysPropertyUtil mInstance;
    private final Properties mProperties = new Properties();
    private final Pattern mPattern = Pattern.compile("\\[(.+)]: \\[(.+)]");

    public static SysPropertyUtil getInstance() throws IOException {
        if (mInstance == null) {
            mInstance = new SysPropertyUtil();
        }
        return mInstance;
    }

    public static String getSerialNumber() {
        return SysPropertyUtil.getProperty(GET_SYSTEM_RO_SERIALNO, "");
    }

    public static String getIncrementalVersion() {
        return SysPropertyUtil.getProperty(GET_SYSTEM_VERSION_INCREMENTAL, "");
    }

    public static String getSunmiSerialNumber() {
        return SysPropertyUtil.getProperty(GET_SUNMI_SERIAL, "");
    }

    public static String getLandiSystemVersion() {
        return SysPropertyUtil.getProperty(GET_LANDI_SYSTEM_VERSION, "");
    }

    @SuppressLint(value={"PrivateApi"})
    public static String getProperty(String key, String defaultValue) {
        try {
            Class<?> clz = Class.forName("android.os.SystemProperties");
            Method method = clz.getMethod("get", String.class, String.class);
            return (String)method.invoke(clz, key, defaultValue);
        }
        catch (Exception e) {
            e.printStackTrace();
            return defaultValue;
        }
    }

    private SysPropertyUtil() {
        try {
            String readLine;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(Runtime.getRuntime().exec("getprop").getInputStream()));
            while ((readLine = bufferedReader.readLine()) != null && !readLine.equals("null")) {
                this.setProperty(readLine);
            }
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
    }

    private void setProperty(String str) {
        Matcher matcher;
        if (StringUtils.isNotEmpty((CharSequence)str) && (matcher = this.mPattern.matcher(str)).find()) {
            this.mProperties.setProperty(matcher.group(1), matcher.group(2));
        }
    }

    public String getProperty(String str) {
        return this.mProperties.getProperty(str);
    }
}

