/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import com.annimon.stream.function.Supplier;
import com.google.common.base.Strings;
import java.util.Random;

public class StringUtil {
    private static final char[] ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();
    private static final char[] NUMBERIC = "1234567890".toCharArray();
    private static final char[] ALL = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890".toCharArray();

    public static String format(String fmt, Object ... args) {
        return (String)Supplier.Util.safe(() -> {
            String pattern1 = fmt.replace("{{}}", "$$BRACE$$").replace("{}", "%s").replace("$$BRACE$$", "{}");
            return Strings.lenientFormat((String)pattern1, (Object[])args);
        }, (Object)"").get();
    }

    public static String randomString(int digit) {
        return StringUtil.randomStringInternal(digit, ALL);
    }

    public static String randomAlphabet(int digit) {
        return StringUtil.randomStringInternal(digit, ALPHABET);
    }

    public static String randomNumberic(int digit) {
        return StringUtil.randomStringInternal(digit, NUMBERIC);
    }

    private static String randomStringInternal(int digit, char[] seed) {
        StringBuilder sb = new StringBuilder(digit);
        Random random = new Random();
        for (int i = 0; i != digit; ++i) {
            sb.append(seed[random.nextInt(seed.length)]);
        }
        return sb.toString();
    }

    public static int findPositionIndex(String str, String str2, int position) {
        int fromIndex = 0;
        int count = 0;
        int index;
        while ((index = str.indexOf(str2, fromIndex)) != -1 && ++count != position) {
            fromIndex = index + str2.length();
        }
        return index;
    }
}

