/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;

public class NetworkUtil {
    public static final int NETWORK_TYPE_NONE = -1;
    public static final int NETWORK_TYPE_2G = 1;
    public static final int NETWORK_TYPE_3G = 2;
    public static final int NETWORK_TYPE_4G = 3;
    public static final int NETWORK_TYPE_WIFI = 5;

    @SuppressLint(value={"MissingPermission"})
    public static int getDevNetworkType(Context context) {
        ConnectivityManager cm = (ConnectivityManager)context.getSystemService("connectivity");
        if (cm == null) {
            return -1;
        }
        NetworkInfo ni = cm.getActiveNetworkInfo();
        if (ni == null) {
            return -1;
        }
        int type = ni.getType();
        if (type == 1) {
            type = 5;
        } else if (type == 0) {
            int subType = ni.getSubtype();
            if (subType == 4 || subType == 1 || subType == 2) {
                type = 1;
            } else if (subType == 3 || subType == 8 || subType == 6 || subType == 5 || subType == 12) {
                type = 2;
            } else if (subType == 13) {
                type = 3;
            }
        }
        return type;
    }

    public static boolean isCellular(Context context) {
        int networkType = NetworkUtil.getDevNetworkType(context.getApplicationContext());
        return networkType != -1 && networkType != 5;
    }

    public static boolean isNetworkActive(int networkType) {
        return networkType != -1;
    }

    public static boolean isNetworkActive(Context context) {
        return NetworkUtil.isNetworkActive(NetworkUtil.getDevNetworkType(context));
    }
}

