/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.http;

import androidx.annotation.NonNull;
import com.annimon.stream.Optional;
import com.annimon.stream.function.Consumer;
import com.fshows.android.stark.FsFoundationInitializer;
import com.fshows.android.stark.http.DirectNetProvider;
import com.fshows.android.stark.http.NetInterceptor;
import com.fshows.android.stark.http.NetProvider;
import com.fshows.android.stark.http.RequestHandler;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.apache.commons.lang3.StringUtils;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.gson.GsonConverterFactory;

public class HttpUtils {
    private HashMap<String, NetProvider> mProviderMap = new HashMap();
    private HashMap<String, Retrofit> mRetrofitMap = new HashMap();
    private HashMap<String, OkHttpClient> mClientMap = new HashMap();
    private static HttpUtils instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HttpUtils getInstance() {
        if (instance != null) return instance;
        Class<HttpUtils> clazz = HttpUtils.class;
        synchronized (HttpUtils.class) {
            if (instance != null) return instance;
            instance = new HttpUtils();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    Retrofit getRetrofit(String baseUrl, NetProvider provider) throws Exception {
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            throw new IllegalAccessException("baseUrl can not be null");
        }
        if (this.mRetrofitMap.get(baseUrl) != null) {
            return this.mRetrofitMap.get(baseUrl);
        }
        NetProvider netProvider = provider;
        if (provider == null && (netProvider = this.mProviderMap.get(baseUrl)) == null) {
            throw new IllegalAccessException("provider can not be null");
        }
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).client(this.getOkHttpClient(baseUrl, netProvider)).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
        this.mRetrofitMap.put(baseUrl, retrofit);
        this.mProviderMap.put(baseUrl, provider);
        return retrofit;
    }

    private OkHttpClient getOkHttpClient(String baseUrl, NetProvider provider) {
        ArrayList<Interceptor> interceptors;
        if (StringUtils.isEmpty((CharSequence)baseUrl)) {
            throw new IllegalStateException("baseUrl can not be null");
        }
        if (this.mClientMap.get(baseUrl) != null) {
            return this.mClientMap.get(baseUrl);
        }
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        if (provider.configConnectTimeoutSecs() != 0L) {
            builder.connectTimeout(provider.configConnectTimeoutSecs(), TimeUnit.SECONDS);
        } else {
            builder.connectTimeout(15000L, TimeUnit.SECONDS);
        }
        if (provider.configReadTimeoutSecs() != 0L) {
            builder.readTimeout(provider.configReadTimeoutSecs(), TimeUnit.SECONDS);
        } else {
            builder.readTimeout(20000L, TimeUnit.SECONDS);
        }
        if (provider.configWriteTimeoutSecs() != 0L) {
            builder.writeTimeout(provider.configWriteTimeoutSecs(), TimeUnit.SECONDS);
        } else {
            builder.writeTimeout(20000L, TimeUnit.SECONDS);
        }
        RequestHandler handler = provider.headerInterceptors();
        if (handler != null) {
            builder.addInterceptor((Interceptor)new NetInterceptor(handler));
        }
        if (FsFoundationInitializer.isDebug()) {
            Consumer<OkHttpClient.Builder> c = FsFoundationInitializer.getOkHttpBuilderDebugConsumer();
            Optional.ofNullable(c).executeIfPresent(it -> it.accept((Object)builder));
        }
        if (!this.empty(interceptors = provider.configInterceptors())) {
            for (Interceptor interceptor : interceptors) {
                builder.addInterceptor(interceptor);
            }
        }
        if (provider.configLogEnable()) {
            HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
            if (FsFoundationInitializer.isDebug()) {
                loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
            } else {
                loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.NONE);
            }
            builder.addInterceptor((Interceptor)loggingInterceptor);
        }
        OkHttpClient client = builder.build();
        this.mClientMap.put(baseUrl, client);
        return client;
    }

    private boolean empty(ArrayList<Interceptor> interceptors) {
        return interceptors == null || interceptors.isEmpty();
    }

    public <T> T get(String baseUrl, NetProvider provider, Class<T> service) {
        try {
            return (T)this.getRetrofit(baseUrl, provider).create(service);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @NonNull
    public Retrofit getDirectRetrofit(String baseUrl) {
        String url = baseUrl;
        if (!Strings.isNullOrEmpty((String)baseUrl) && !baseUrl.endsWith("/")) {
            url = url + "/";
        }
        return new Retrofit.Builder().baseUrl(url).client(this.getOkHttpClient(baseUrl, new DirectNetProvider())).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create()).build();
    }
}

