/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark;

import android.content.Context;
import androidx.annotation.Keep;
import com.fshows.android.foundation.gears.FsGears;
import com.fshows.android.stark.FsXandarConfiguration;
import com.fshows.android.stark.newlog.CrashCollector;
import com.fshows.android.stark.utils.FsLogUtil;
import com.fshows.android.stark.utils.Prefs;
import io.reactivex.plugins.RxJavaPlugins;

@Keep
public class FsFoundationInitializer {
    private static final String TAG = "FsFoundationInitializer";
    private static Context applicationContext;
    private static boolean isDebug;
    private static int mBuildType;

    public static void init(Context context, int buildType) {
        try {
            applicationContext = context.getApplicationContext();
            isDebug = buildType == 0;
            mBuildType = buildType;
            FsFoundationInitializer.initCrash();
            FsFoundationInitializer.initGears();
            Prefs.init(context);
            FsFoundationInitializer.setErrorHandler();
        }
        catch (Exception e) {
            FsLogUtil.error(TAG, e.getMessage(), new Object[0]);
        }
    }

    public static void init(Context context, boolean debug) {
        try {
            applicationContext = context.getApplicationContext();
            isDebug = debug;
            FsFoundationInitializer.initCrash();
            FsFoundationInitializer.initGears();
            Prefs.init(context);
            FsFoundationInitializer.setErrorHandler();
        }
        catch (Exception e) {
            FsLogUtil.error(TAG, e.getMessage(), new Object[0]);
        }
    }

    private static void initCrash() {
        if (!FsFoundationInitializer.isDebug()) {
            CrashCollector.getInstance(applicationContext);
        }
    }

    private static void setErrorHandler() {
        if (!FsFoundationInitializer.isDebug()) {
            RxJavaPlugins.setErrorHandler(throwable -> {
                if (throwable != null) {
                    FsLogUtil.error(TAG, "throwable: " + throwable.getMessage(), new Object[0]);
                }
            });
        }
    }

    private static void initGears() {
        FsGears.init((Context)applicationContext);
    }

    public static Context getApplicationContext() {
        return applicationContext;
    }

    public static boolean isDebug() {
        return isDebug;
    }

    public static int getBuildType() {
        return mBuildType;
    }

    @Deprecated
    public static void setClientInfo(String product, String clientVersion, String versionCode) {
        FsXandarConfiguration.instance.setProduct(product);
        FsXandarConfiguration.instance.setVersion(clientVersion);
    }
}

