/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.log;

import android.content.Context;
import com.fshows.android.stark.log.CrashLogUtil;
import java.io.File;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class CrashCollector
implements Thread.UncaughtExceptionHandler {
    private static final String TAG = CrashCollector.class.getSimpleName();
    private static volatile CrashCollector mInstance = null;
    private Lock mLock = new ReentrantLock();
    private Condition mCondition = this.mLock.newCondition();
    private Context mContext;
    private String mDeviceInfo = null;
    private Thread.UncaughtExceptionHandler mOldHandler;

    private CrashCollector(Context context) {
        this.mContext = context;
        try {
            this.mDeviceInfo = CrashLogUtil.getDeviceInfo(context);
            this.mOldHandler = Thread.getDefaultUncaughtExceptionHandler();
            Thread.setDefaultUncaughtExceptionHandler(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized CrashCollector getInstance(Context context) {
        if (null == mInstance) {
            mInstance = new CrashCollector(context);
        }
        return mInstance;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable ex) {
        if (null != ex) {
            new SaveLogThread(ex).start();
            this.mLock.lock();
            try {
                this.mCondition.await();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            this.mLock.unlock();
        }
        if (null != this.mOldHandler) {
            this.mOldHandler.uncaughtException(thread, ex);
        }
    }

    private class SaveLogThread
    extends Thread {
        private Throwable ex = null;

        public SaveLogThread(Throwable ex) {
            this.ex = ex;
        }

        @Override
        public void run() {
            this.saveCrash2sdcard();
            CrashCollector.this.mLock.lock();
            CrashCollector.this.mCondition.signalAll();
            CrashCollector.this.mLock.unlock();
        }

        private void saveCrash2sdcard() {
            String writeDir = CrashLogUtil.logWriteDir(CrashCollector.this.mContext);
            if (null == writeDir) {
                return;
            }
            String logFileName = CrashLogUtil.logFileName(CrashCollector.this.mContext);
            File writeFile = new File(writeDir, logFileName);
            if (!writeFile.getParentFile().canWrite()) {
                return;
            }
            CrashLogUtil.writeStackTrace(CrashCollector.this.mContext, writeFile, CrashCollector.this.mDeviceInfo, this.ex);
        }
    }
}

