/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.scheme;

import android.net.Uri;
import androidx.annotation.Nullable;
import com.annimon.stream.function.Supplier;
import com.fshows.android.stark.scheme.SchemeData;
import com.google.common.collect.Maps;
import java.util.HashMap;

public class SchemeParser {
    public static final String SCHEME = "$SCHEME";
    public static final String HOST = "$HOST";
    public static final String PATH = "$PATH";

    @Nullable
    public static SchemeData parse(String url) {
        return (SchemeData)Supplier.Util.safe(() -> {
            Uri uri = Uri.parse((String)url);
            HashMap data = Maps.newHashMap();
            data.put(SCHEME, uri.getScheme());
            data.put(HOST, uri.getHost());
            data.put(PATH, uri.getPath());
            for (String key : uri.getQueryParameterNames()) {
                data.put(key, uri.getQueryParameter(key));
            }
            SchemeData schemeData = new SchemeData();
            schemeData.setScheme(url);
            schemeData.setData(data);
            return schemeData;
        }, null).get();
    }
}

