/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.crash;

import android.content.Context;
import android.widget.Toast;
import com.fshows.android.stark.BuildConfig;
import com.fshows.android.stark.log.CrashLogUtil;
import java.io.File;

public abstract class AbstractExceptionHandler {
    private Context mContext;
    private String mDeviceInfo;
    private Toast mToast;
    private long mLastTime = 0L;

    public AbstractExceptionHandler(Context context) {
        this.mContext = context;
        try {
            this.mDeviceInfo = CrashLogUtil.getDeviceInfo(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    final void uncaughtExceptionHappened(Thread thread, Throwable throwable) {
        try {
            this.onUncaughtExceptionHappened(thread, throwable);
            this.saveCrash2sdcard(throwable);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    final void bandageExceptionHappened(Throwable throwable) {
        try {
            this.onBandageExceptionHappened(throwable);
            this.saveCrash2sdcard(throwable);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    final void enterSafeMode() {
        try {
            this.onEnterSafeMode();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    final void mayBeBlackScreen(Throwable throwable) {
        try {
            this.onMayBeBlackScreen(throwable);
            this.saveCrash2sdcard(throwable);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    protected abstract void onUncaughtExceptionHappened(Thread var1, Throwable var2);

    protected abstract void onBandageExceptionHappened(Throwable var1);

    protected abstract void onEnterSafeMode();

    protected void onMayBeBlackScreen(Throwable e) {
    }

    private void saveCrash2sdcard(Throwable ex) {
        long maxInterval;
        long nowTime = System.currentTimeMillis();
        if (nowTime - this.mLastTime < (maxInterval = 1500L)) {
            return;
        }
        this.mLastTime = nowTime;
        this.showToast();
        String writeDir = CrashLogUtil.logWriteDir(this.mContext);
        if (null == writeDir) {
            return;
        }
        String logFileName = CrashLogUtil.logFileName(this.mContext);
        File writeFile = new File(writeDir, logFileName);
        if (!writeFile.getParentFile().canWrite()) {
            return;
        }
        CrashLogUtil.writeStackTrace(this.mContext, writeFile, this.mDeviceInfo, ex);
    }

    private void showToast() {
        if (BuildConfig.DEBUG) {
            if (this.mToast == null) {
                this.mToast = Toast.makeText((Context)this.mContext, (CharSequence)"", (int)0);
                this.mToast.setGravity(17, 0, 0);
            }
            this.mToast.setText((CharSequence)"\u54ce\u5440\uff01\u53d1\u751f\u4e86\u5f02\u5e38\u5566\uff0c\u8bf7\u4e0a\u62a5\u7ed9\u5f00\u53d1\u8005\uff01");
            this.mToast.show();
        }
    }
}

