/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.android.stark.utils;

import android.annotation.TargetApi;
import android.content.Context;
import com.fshows.android.stark.utils.CommonUtil;
import com.fshows.android.stark.utils.FileUtil;
import com.google.common.base.Strings;
import java.io.File;

public class FileCacheUtil {
    private static final String TEMP_FILE_SUFFIX = "_temp";

    @TargetApi(value=19)
    public static String getFileDirPath(Context context, String dirName) {
        String rootPath = FileUtil.getRootPath(context);
        if (Strings.isNullOrEmpty((String)rootPath)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        builder.append(rootPath).append(File.separator).append(dirName);
        return builder.toString();
    }

    public static String getTempCacheFilePath(Context context, String dirName, String cacheFileName) {
        return FileCacheUtil.getFilePath(context, dirName, cacheFileName, true);
    }

    public static String getCacheFilePath(Context context, String dirName, String cacheFileName) {
        return FileCacheUtil.getFilePath(context, dirName, cacheFileName, false);
    }

    @Deprecated
    private static String getPrivateFilePath(Context context, String dirName, String cacheFileName) {
        String rootPath = context.getCacheDir().getAbsolutePath() + File.separator + dirName;
        String[] args1 = new String[]{"chmod", "705", rootPath};
        CommonUtil.exec(args1);
        String key4File = FileUtil.genKeyForUrl(cacheFileName);
        File cacheFile = new File(rootPath, key4File);
        File parentFile = cacheFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        return cacheFile.getAbsolutePath();
    }

    private static String getFilePath(Context context, String dirName, String cacheFileName, boolean temp) {
        File cacheFile;
        File parentFile;
        String rootPath = FileCacheUtil.getFileDirPath(context, dirName);
        String key4File = FileUtil.genKeyForUrl(cacheFileName);
        if (temp) {
            key4File = key4File + TEMP_FILE_SUFFIX;
        }
        if (!(parentFile = (cacheFile = new File(rootPath, key4File)).getParentFile()).exists()) {
            parentFile.mkdirs();
        }
        return cacheFile.getAbsolutePath();
    }

    public static boolean deleteCacheFile(Context context, String dirName, String cacheFileName) {
        String filePath = FileCacheUtil.getCacheFilePath(context, dirName, cacheFileName);
        File file4Delete = new File(filePath);
        return file4Delete.delete();
    }

    public static boolean isFileCached(Context context, String dirName, String cacheFileName) {
        String cachePath = FileCacheUtil.getCacheFilePath(context, dirName, cacheFileName);
        File cacheFile = new File(cachePath);
        return cacheFile.exists();
    }
}

